/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.prescriptive.recommender.ml;

public class NumJa {
    private NumJa() {
    }

    public static double[][] simiRandom(int m, int n, int sheft) {
        double[] uniformRandList = new double[]{0.44472415, 0.93248305, 0.55614803, 0.4165391, 0.63305444, 0.77473826, 0.84692571, 0.20502011, 0.37537012, 0.84405011, 0.43786223, 0.21327387, 0.99603986, 0.49119278, 0.86660532, 0.28452257, 0.2354869, 0.61442271, 0.90956274, 0.1092067, 0.65461257, 0.75004707, 0.42672357, 0.94607561, 0.33166043, 0.79529962, 0.65558414, 0.47806207, 0.2683377, 0.12279999, 0.51273104, 0.71430129, 0.25724062, 0.75395674, 0.26318416, 0.01596625, 0.4950497, 0.06589894, 0.10104361, 0.21753731, 0.44626311, 0.07358467, 0.72700544, 0.94031608, 0.47500343, 0.58591211, 0.77031725, 0.73515357, 0.1134165, 0.10064525};
        double[][] a = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                a[i][j] = uniformRandList[(i + j + sheft) % uniformRandList.length];
            }
        }
        return a;
    }

    public static double[][] add(double[][] a, double[][] b) {
        int m1 = a.length;
        int n1 = a[0].length;
        int m2 = b.length;
        int n2 = b[0].length;
        assert (m1 == m2);
        assert (n1 == n2);
        double[][] c = new double[m1][n1];
        for (int i = 0; i < m1; ++i) {
            for (int j = 0; j < n1; ++j) {
                c[i][j] = a[i][j] + b[i][j];
            }
        }
        return c;
    }

    public static double[][] add(double[][] a, double b) {
        int m1 = a.length;
        int n1 = a[0].length;
        double[][] c = new double[m1][n1];
        for (int i = 0; i < m1; ++i) {
            for (int j = 0; j < n1; ++j) {
                c[i][j] = a[i][j] + b;
            }
        }
        return c;
    }

    public static double[][] addDot(double[][] w, double[][] x, double[][] b) {
        int j;
        int i;
        int m1 = w.length;
        int n1 = w[0].length;
        int m2 = x.length;
        int n2 = x[0].length;
        int m3 = b.length;
        double[][] c = new double[m1][n2];
        for (i = 0; i < m1; ++i) {
            for (j = 0; j < n2; ++j) {
                c[i][j] = b[i][0];
            }
        }
        assert (n1 == m2);
        assert (m1 == m3);
        for (i = 0; i < m1; ++i) {
            for (j = 0; j < n2; ++j) {
                for (int k = 0; k < n1; ++k) {
                    double[] dArray = c[i];
                    int n = j;
                    dArray[n] = dArray[n] + w[i][k] * x[k][j];
                }
            }
        }
        return c;
    }

    public static double[][] subtract(double[][] a, double[][] b) {
        int m = a.length;
        int n = a[0].length;
        double[][] c = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                c[i][j] = a[i][j] - b[i][j];
            }
        }
        return c;
    }

    public static double[][] subtract(double[][] a, double[][] b, double lr) {
        int m = a.length;
        int n = a[0].length;
        double[][] c = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                c[i][j] = a[i][j] - b[i][j] * lr;
            }
        }
        return c;
    }

    public static double[][] subtract(double a, double[][] b) {
        int m = b.length;
        int n = b[0].length;
        double[][] c = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                c[i][j] = a - b[i][j];
            }
        }
        return c;
    }

    public static double[][] dot(double[][] a, double[][] b) {
        int m1 = a.length;
        int n1 = a[0].length;
        int m2 = b.length;
        int n2 = b[0].length;
        assert (n1 == m2);
        double[][] c = new double[m1][n2];
        for (int i = 0; i < m1; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n1; ++k) {
                    double[] dArray = c[i];
                    int n = j;
                    dArray[n] = dArray[n] + a[i][k] * b[k][j];
                }
            }
        }
        return c;
    }

    public static double[][] tDot(double[][] a, double[][] b) {
        int n1 = a.length;
        int m1 = a[0].length;
        int m2 = b.length;
        int n2 = b[0].length;
        assert (n1 == m2);
        double[][] c = new double[m1][n2];
        for (int i = 0; i < m1; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n1; ++k) {
                    double[] dArray = c[i];
                    int n = j;
                    dArray[n] = dArray[n] + a[k][i] * b[k][j];
                }
            }
        }
        return c;
    }

    public static double[][] dotT(double[][] a, double[][] b) {
        int m1 = a.length;
        int n1 = a[0].length;
        int n2 = b.length;
        int m2 = b[0].length;
        assert (n1 == m2);
        double[][] c = new double[m1][n2];
        for (int i = 0; i < m1; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n1; ++k) {
                    double[] dArray = c[i];
                    int n = j;
                    dArray[n] = dArray[n] + a[i][k] * b[j][k];
                }
            }
        }
        return c;
    }

    public static double[][] multiply(double[][] x, double[][] a) {
        int m = a.length;
        int n = a[0].length;
        double[][] y = new double[m][n];
        for (int j = 0; j < m; ++j) {
            for (int i = 0; i < n; ++i) {
                y[j][i] = a[j][i] * x[j][i];
            }
        }
        return y;
    }

    public static double[][] multiply(double x, double[][] a) {
        int m = a.length;
        int n = a[0].length;
        double[][] y = new double[m][n];
        for (int j = 0; j < m; ++j) {
            for (int i = 0; i < n; ++i) {
                y[j][i] = a[j][i] * x;
            }
        }
        return y;
    }

    public static double[][] power(double[][] x, int a) {
        int m = x.length;
        int n = x[0].length;
        double[][] y = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                y[i][j] = Math.pow(x[i][j], a);
            }
        }
        return y;
    }

    public static double[][] sigmoid(double[][] a) {
        int m = a.length;
        int n = a[0].length;
        double[][] z = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                z[i][j] = 1.0 / (1.0 + Math.exp(-a[i][j]));
            }
        }
        return z;
    }

    public static double[][] tanh(double[][] a) {
        int m = a.length;
        int n = a[0].length;
        double[][] z = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                z[i][j] = Math.tanh(a[i][j]);
            }
        }
        return z;
    }

    public static double[][] divide(double[][] x, double a) {
        int m = x.length;
        int n = x[0].length;
        double[][] z = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                z[i][j] = x[i][j] / a;
            }
        }
        return z;
    }

    public static double[][] divide(double[][] x, double[][] a) {
        int m = x.length;
        int n = x[0].length;
        double[][] z = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                z[i][j] = x[i][j] / a[i][j];
            }
        }
        return z;
    }

    public static double[][] sqrt(double[][] x) {
        int m = x.length;
        int n = x[0].length;
        double[][] z = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                z[i][j] = Math.sqrt(x[i][j]);
            }
        }
        return z;
    }

    public static double mse(int batchSize, double[][] y, double[][] a) {
        int m = a.length;
        int n = a[0].length;
        double[][] z = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                z[i][j] = Math.pow(y[i][j] - a[i][j], 2.0);
            }
        }
        double sum = 0.0;
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                sum += z[i][j];
            }
        }
        return sum / (double)batchSize;
    }

    public static String shape(double[][] a) {
        return a.length + " x " + a[0].length;
    }

    public static double mae(int batchSize, double[][] y, double[][] a) {
        int m = a.length;
        int n = a[0].length;
        double[][] z = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                z[i][j] = Math.abs(y[i][j] - a[i][j]);
            }
        }
        double sum = 0.0;
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                sum += z[i][j];
            }
        }
        return sum / (double)batchSize;
    }

    public static double[][] sumDivide(double[][] x, int a) {
        int m = x.length;
        int n = x[0].length;
        double[][] c = new double[m][1];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                double[] dArray = c[i];
                dArray[0] = dArray[0] + x[i][j];
            }
            double[] dArray = c[i];
            dArray[0] = dArray[0] / (double)a;
        }
        return c;
    }
}

