/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.rest.client;

import com.ibm.smarts.core.api.Handlers;
import com.ibm.smarts.core.async.AsyncMetrics;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.rest.client.util.CompletableFutureHelper;
import com.ibm.smarts.core.rest.client.util.JaxRs20Classes;
import com.ibm.smarts.core.rest.client.util.JaxRs20Exceptions;
import com.ibm.smarts.core.util.Ensure;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.core.util.RestMetrics;
import com.ibm.smarts.core.util.Timer;
import com.ibm.smarts.core.util.ToString;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClient
implements Handlers,
Closeable {
    public final RequestContext requestContext;
    protected static final Logger LOGGER = LoggerFactory.getLogger(RestClient.class);
    public final String uri;
    protected final Map<String, List<String>> headers;
    protected final Map<String, NewCookie> setCookies;
    private final RestCallContextFactory restCallContextFactory;
    public static final String REST_CALL_CONTEXT_FACTORY_KEY = "com.ibm.smarts.rest.restCallContextFactory";

    public RestClient(RestCallContextFactory rccf, RequestContext requestContext, String uri) {
        this(rccf, requestContext, uri, null);
    }

    public RestClient(RestCallContextFactory rccf, RequestContext requestContext, String uri, Map<String, List<String>> headers) {
        this(rccf, requestContext, uri, headers, null);
    }

    private RestClient(RestCallContextFactory rccf, RequestContext requestContext, String uri, Map<String, List<String>> headers, Map<String, NewCookie> setCookies) {
        this.requestContext = requestContext;
        this.uri = uri;
        this.headers = headers != null ? new HashMap<String, List<String>>(headers) : new HashMap();
        this.setCookies = RestClient.buildCookiesMap(setCookies);
        Ensure.notNull((String)"RCCF", (Object)rccf);
        this.restCallContextFactory = rccf;
    }

    @Override
    public void close() throws IOException {
    }

    public Map<String, List<String>> getHttpHeaders() {
        return this.headers;
    }

    private <T> RestCallContext<T> callContext(Class<T> klass, MeasuredFuture<T> mf, String path, QueryParams params) {
        return this.callContext(klass, mf, path, params, MediaType.APPLICATION_JSON_TYPE);
    }

    private <T> RestCallContext<T> callContext(Class<T> klass, MeasuredFuture<T> mf, String path, QueryParams params, MediaType mediaType) {
        return this.restCallContextFactory.buildRestCallContext(this.requestContext, klass, mf, this.uri, path, params, mediaType, this.headers, this.setCookies);
    }

    private static String buildMetricsPath(String uri, String path) {
        int paramIdx;
        StringBuilder sb = new StringBuilder();
        sb.append(uri);
        if (!uri.endsWith("/") && !path.startsWith("/")) {
            sb.append("/");
        }
        if ((paramIdx = path.indexOf(63)) == -1) {
            sb.append(path);
        } else {
            sb.append(path.substring(0, paramIdx));
        }
        return sb.toString();
    }

    protected RestMetrics.PathMetrics metricsForPath(String path) {
        return this.metricsForPath(path, null);
    }

    protected RestMetrics.PathMetrics metricsForPath(String path, QueryParams queryParams) {
        String metricsPath = RestClient.buildMetricsPath(this.uri, path);
        String queryString = queryParams == null ? null : queryParams.toUrlString();
        RestMetrics.PathMetrics ret = this.requestContext.restMetrics().forPath(metricsPath, queryString);
        return ret;
    }

    private static Map<String, NewCookie> buildCookiesMap(Map<String, NewCookie> cookies) {
        HashMap<String, NewCookie> ret = new HashMap<String, NewCookie>();
        if (cookies != null) {
            for (Map.Entry<String, NewCookie> e : cookies.entrySet()) {
                ret.put(e.getKey(), e.getValue());
            }
        }
        return ret;
    }

    protected <T> T get(CompletableFuture<T> mf) {
        return CompletableFutureHelper.get(mf);
    }

    private <T> Throwable rebuildException(RestCallContext<T> rcc, Throwable th) {
        return th;
    }

    private JaxRs20Classes.InvocationCallback<Response> callback_response(final RestCallContext<Response> rcc) {
        return new LocalInvocationCallback<Response>(this.requestContext, rcc){

            @Override
            public void completed(Response t) {
                this.reportCompletedResponse(t);
                rcc.getFuture().complete(t);
            }

            @Override
            public void failed(Throwable th) {
                this.handleException(th);
            }
        };
    }

    private JaxRs20Classes.InvocationCallback<String> callback_string(final RestCallContext<String> rcc) {
        return new LocalInvocationCallback<String>(this.requestContext, rcc){

            @Override
            public void completed(String t) {
                this.reportCompleted(t);
                rcc.getFuture().complete(t);
            }

            @Override
            public void failed(Throwable th) {
                this.handleException(th);
            }
        };
    }

    private JaxRs20Classes.InvocationCallback<InputStream> callback_inputStream(final RestCallContext<InputStream> rcc) {
        return new LocalInvocationCallback<InputStream>(this.requestContext, rcc){

            @Override
            public void completed(InputStream t) {
                this.reportCompleted(t);
                rcc.getFuture().complete(t);
            }

            @Override
            public void failed(Throwable th) {
                this.handleException(th);
            }
        };
    }

    public static String getJson(Response resp) {
        Object entity = resp.getEntity();
        String ret = entity != null && entity instanceof String ? (String)entity : null;
        return ret;
    }

    public Response getResponse(String path) throws JaxRs20Exceptions.ClientErrorException {
        CompletableFuture<Response> cf = this.getAsyncResponse(path);
        return this.get(cf);
    }

    public Response getResponse(String path, String trustedServiceId) throws JaxRs20Exceptions.ClientErrorException {
        CompletableFuture<Response> cf = this.getTrustedAsyncResponse(path, null, trustedServiceId);
        return this.get(cf);
    }

    public String get(String path) throws JaxRs20Exceptions.ClientErrorException {
        return this.get(path, null);
    }

    public String maybeGet(String path) throws JaxRs20Exceptions.ClientErrorException {
        return this.maybeGet(path, null);
    }

    public String get(String path, QueryParams queryParams) {
        CompletableFuture<String> cf = this.getAsync(path, queryParams);
        return this.get(cf);
    }

    public String maybeGet(String path, QueryParams queryParams) {
        CompletableFuture<String> cf = this.maybeGetAsync(path, queryParams);
        return this.get(cf);
    }

    public Response getResponse(String path, QueryParams queryParams) {
        return this.get(this.getAsyncResponse(path, queryParams));
    }

    public CompletableFuture<Response> getAsyncResponse(String path) {
        return this.getAsyncResponse(path, null);
    }

    public CompletableFuture<Response> getAsyncResponse(String path, QueryParams queryParams) {
        MeasuredFuture<Response> ret = new MeasuredFuture<Response>(this.metricsForPath((String)path, (QueryParams)queryParams).get);
        RestCallContext<Response> rcc = this.callContext(Response.class, ret, path, queryParams);
        rcc.get(this.callback_response(rcc));
        return ret;
    }

    public CompletableFuture<Response> getTrustedAsyncResponse(String path, QueryParams queryParams, String trustedServiceId) {
        MeasuredFuture<Response> ret = new MeasuredFuture<Response>(this.metricsForPath((String)path, (QueryParams)queryParams).get);
        RestCallContext<Response> rcc = this.callContext(Response.class, ret, path, queryParams);
        rcc.get(this.callback_response(rcc), trustedServiceId);
        return ret;
    }

    public CompletableFuture<String> getAsync(String path) {
        return this.getAsync(path, null);
    }

    public CompletableFuture<String> maybeGetAsync(String path) {
        return this.maybeGetAsync(path, null);
    }

    public CompletableFuture<String> maybeGetAsync(String path, QueryParams queryParams) {
        CompletableFuture<String> f = this.getAsync(path, queryParams);
        return this.nullForHttpNotFound(f);
    }

    public CompletableFuture<String> getAsync(String path, QueryParams queryParams) {
        return this.getAsync(path, queryParams, null);
    }

    public CompletableFuture<String> getAsync(String path, QueryParams queryParams, String trustedServiceId) {
        MeasuredFuture<String> ret = new MeasuredFuture<String>(this.metricsForPath((String)path, (QueryParams)queryParams).get);
        RestCallContext<String> rcc = this.callContext(String.class, ret, path, queryParams);
        if (StringUtils.isBlank((CharSequence)trustedServiceId)) {
            rcc.get(this.callback_string(rcc));
        } else {
            rcc.get(this.callback_string(rcc), trustedServiceId);
        }
        return ret;
    }

    public InputStream getStreaming(String path) {
        CompletableFuture<InputStream> cf = this.getStreamingAsync(path);
        return this.get(cf);
    }

    public CompletableFuture<InputStream> getStreamingAsync(String path) {
        MeasuredFuture<InputStream> ret = new MeasuredFuture<InputStream>(this.metricsForPath((String)path).get);
        RestCallContext<InputStream> rcc = this.callContext(InputStream.class, ret, path, null);
        rcc.get(this.callback_inputStream(rcc));
        return ret;
    }

    public String put(String path, String body) throws JaxRs20Exceptions.ClientErrorException {
        CompletableFuture<String> cf = this.putAsync(path, body);
        return this.get(cf);
    }

    public CompletableFuture<String> putAsync(String path, String body) {
        MeasuredFuture<String> ret = new MeasuredFuture<String>(this.metricsForPath((String)path).put);
        RestCallContext<String> rcc = this.callContext(String.class, ret, path, null);
        rcc.put(JaxRs20Classes.Entity.entity(body, MediaType.APPLICATION_JSON_TYPE), this.callback_string(rcc));
        return ret;
    }

    public Response putResponse(String path, String body) throws JaxRs20Exceptions.ClientErrorException {
        CompletableFuture<Response> cf = this.putAsyncResponse(path, body, null);
        return this.get(cf);
    }

    public Response putResponse(String path, String body, String trustedServiceId) throws JaxRs20Exceptions.ClientErrorException {
        CompletableFuture<Response> cf = this.putAsyncResponse(path, body, trustedServiceId);
        return this.get(cf);
    }

    public CompletableFuture<Response> putAsyncResponse(String path, String body, String trustedServiceId) {
        MeasuredFuture<Response> ret = new MeasuredFuture<Response>(this.metricsForPath((String)path).put);
        RestCallContext<Response> rcc = this.callContext(Response.class, ret, path, null);
        if (trustedServiceId == null) {
            rcc.put(JaxRs20Classes.Entity.entity(body, MediaType.APPLICATION_JSON_TYPE), this.callback_response(rcc));
        } else {
            rcc.put(JaxRs20Classes.Entity.entity(body, MediaType.APPLICATION_JSON_TYPE), this.callback_response(rcc), trustedServiceId);
        }
        return ret;
    }

    public Response putResponse(String path, String body, QueryParams queryParams) {
        MeasuredFuture ret = new MeasuredFuture(this.metricsForPath((String)path).put);
        RestCallContext<Response> rcc = this.callContext(Response.class, ret, path, queryParams);
        rcc.put(JaxRs20Classes.Entity.entity(body, MediaType.APPLICATION_JSON_TYPE), this.callback_response(rcc));
        return (Response)this.get(ret);
    }

    public Response postResponse(String path, String body) throws JaxRs20Exceptions.ClientErrorException {
        return this.postResponse(path, body, null);
    }

    public Response postResponse(String path, String body, QueryParams queryParams) throws JaxRs20Exceptions.ClientErrorException {
        CompletableFuture<Response> cf = this.postAsyncResponse(path, body, queryParams);
        return this.get(cf);
    }

    public CompletableFuture<Response> postAsyncResponse(String path, String body) {
        return this.postAsyncResponse(path, body, null);
    }

    public CompletableFuture<Response> postAsyncResponse(String path, String body, QueryParams queryParams) {
        return this.postAsyncResponse(path, body, queryParams, MediaType.APPLICATION_JSON_TYPE);
    }

    public CompletableFuture<Response> postAsyncResponse(String path, String body, QueryParams queryParams, String trustedServiceId) {
        MeasuredFuture<Response> ret = new MeasuredFuture<Response>(this.metricsForPath((String)path).post);
        RestCallContext<Response> rcc = this.callContext(Response.class, ret, path, queryParams, MediaType.APPLICATION_JSON_TYPE);
        rcc.post(JaxRs20Classes.Entity.entity(body, MediaType.APPLICATION_JSON_TYPE), this.callback_response(rcc), trustedServiceId);
        return ret;
    }

    public <T> CompletableFuture<Response> postAsyncResponse(String path, T entity, QueryParams queryParams, MediaType mediaType) {
        MeasuredFuture<Response> ret = new MeasuredFuture<Response>(this.metricsForPath((String)path).post);
        RestCallContext<Response> rcc = this.callContext(Response.class, ret, path, queryParams, mediaType);
        rcc.post(JaxRs20Classes.Entity.entity(entity, mediaType), this.callback_response(rcc));
        return ret;
    }

    public String post(String path, String body) throws JaxRs20Exceptions.ClientErrorException {
        CompletableFuture<String> cf = this.postAsync(path, body);
        return this.get(cf);
    }

    public String post(String path, String body, String trustedServiceId) throws JaxRs20Exceptions.ClientErrorException {
        CompletableFuture<String> cf = this.postAsync(path, body, null, MediaType.APPLICATION_JSON_TYPE, trustedServiceId);
        return this.get(cf);
    }

    public CompletableFuture<String> postAsync(String path, String body) {
        return this.postAsync(path, body, null);
    }

    public CompletableFuture<String> postAsync(String path, String body, QueryParams queryParams) {
        return this.postAsync(path, body, queryParams, MediaType.APPLICATION_JSON_TYPE);
    }

    public <T> CompletableFuture<String> postAsync(String path, T entity, QueryParams queryParams, MediaType mediaType) {
        return this.postAsync(path, entity, queryParams, mediaType, null);
    }

    public <T> CompletableFuture<String> postAsync(String path, T entity, QueryParams queryParams, MediaType mediaType, String trustedServiceId) {
        MeasuredFuture<String> ret = new MeasuredFuture<String>(this.metricsForPath((String)path).post);
        RestCallContext<String> rcc = this.callContext(String.class, ret, path, queryParams, mediaType);
        if (StringUtils.isBlank((CharSequence)trustedServiceId)) {
            rcc.post(JaxRs20Classes.Entity.entity(entity, mediaType), this.callback_string(rcc));
        } else {
            rcc.post(JaxRs20Classes.Entity.entity(entity, mediaType), this.callback_string(rcc), trustedServiceId);
        }
        return ret;
    }

    public Response deleteResponse(String path) throws JaxRs20Exceptions.ClientErrorException {
        return this.deleteResponse(path, null);
    }

    public Response deleteResponse(String path, String trustedServiceId) throws JaxRs20Exceptions.ClientErrorException {
        return this.deleteResponse(path, null, trustedServiceId);
    }

    public Response deleteResponse(String path, QueryParams params, String trustedServiceId) throws JaxRs20Exceptions.ClientErrorException {
        CompletableFuture<Response> cf = this.deleteAsyncResponse(path, params, trustedServiceId);
        return this.get(cf);
    }

    public CompletableFuture<Response> deleteAsyncResponse(String path, QueryParams params, String trustedServiceId) {
        MeasuredFuture<Response> ret = new MeasuredFuture<Response>(this.metricsForPath((String)path).delete);
        RestCallContext<Response> rcc = this.callContext(Response.class, ret, path, params);
        rcc.delete(this.callback_response(rcc), trustedServiceId);
        return ret;
    }

    public String delete(String path) throws JaxRs20Exceptions.ClientErrorException {
        return this.delete(path, null);
    }

    public String maybeDelete(String path) throws JaxRs20Exceptions.ClientErrorException {
        return this.maybeDelete(path, null);
    }

    public String delete(String path, QueryParams params) throws JaxRs20Exceptions.ClientErrorException {
        CompletableFuture<String> cf = this.deleteAsync(path, params);
        return this.get(cf);
    }

    public String maybeDelete(String path, QueryParams params) throws JaxRs20Exceptions.ClientErrorException {
        CompletableFuture<String> cf = this.maybeDeleteAsync(path, params);
        return this.get(cf);
    }

    public CompletableFuture<String> deleteAsync(String path) {
        return this.deleteAsync(path, null);
    }

    public CompletableFuture<String> deleteAsync(String path, QueryParams queryParams) {
        MeasuredFuture<String> ret = new MeasuredFuture<String>(this.metricsForPath((String)path).delete);
        RestCallContext<String> rcc = this.callContext(String.class, ret, path, queryParams);
        rcc.delete(this.callback_string(rcc));
        return ret;
    }

    public CompletableFuture<String> maybeDeleteAsync(String path) {
        return this.maybeDeleteAsync(path, null);
    }

    public CompletableFuture<String> maybeDeleteAsync(String path, QueryParams queryParams) {
        CompletableFuture<String> f = this.deleteAsync(path, queryParams);
        return this.nullForHttpNotFound(f);
    }

    private <T> CompletableFuture<T> nullForHttpNotFound(CompletableFuture<T> f) {
        return this.nullForHttpStatus(f, 404);
    }

    private <T> CompletableFuture<T> nullForHttpStatus(CompletableFuture<T> f, int ... statuses) {
        CompletionStage ret = f.exceptionally(e -> {
            if (e instanceof JaxRs20Exceptions.ResponseProcessingException) {
                JaxRs20Exceptions.ResponseProcessingException rpe = (JaxRs20Exceptions.ResponseProcessingException)e;
                int respStatus = rpe.getResponse().getStatus();
                for (int status : statuses) {
                    if (status != respStatus) continue;
                    return null;
                }
            }
            f.completeExceptionally((Throwable)e);
            return null;
        });
        return ret;
    }

    private abstract class LocalInvocationCallback<T>
    implements JaxRs20Classes.InvocationCallback<T> {
        private final RestCallContext<T> rcc;

        public LocalInvocationCallback(RequestContext rc, RestCallContext<T> rcc) {
            this.rcc = rcc;
        }

        @Override
        public Class<?> getTemplateClass() {
            return this.rcc.getTemplateClass();
        }

        private String messagePrefix() {
            return "[REST call " + this.rcc.instanceNumber() + "] ";
        }

        private String messagePrefix(String heading) {
            return this.messagePrefix() + heading + " ";
        }

        protected final void reportCompleted(T t) {
            if (LOGGER.isInfoEnabled()) {
                long endTime = System.currentTimeMillis();
                LOGGER.info(this.messagePrefix("TIME ELAPSED (SUCCESS)") + (endTime - this.rcc.getStartTime()) + " ms " + this.rcc.getRestUri());
            }
            if (LOGGER.isDebugEnabled()) {
                String hdr = "COMPLETED";
                LOGGER.debug(this.messagePrefix("COMPLETED") + this.rcc.getRestUri());
                LOGGER.debug(this.messagePrefix("COMPLETED") + "returned " + t);
            }
        }

        protected final void reportCompletedResponse(Response resp) {
            int status = resp.getStatus();
            if (LOGGER.isInfoEnabled()) {
                long endTime = System.currentTimeMillis();
                LOGGER.info(this.messagePrefix("TIME ELAPSED (SUCCESS)") + (endTime - this.rcc.getStartTime()) + " ms " + status + " " + this.rcc.getRestUri());
            }
            if (LOGGER.isDebugEnabled()) {
                MultivaluedMap headers = resp.getMetadata();
                Object entity = resp.getEntity();
                String body = null;
                if (entity != null && entity instanceof String) {
                    body = (String)entity;
                }
                String hdr = "COMPLETED";
                LOGGER.debug(this.messagePrefix("COMPLETED") + status + " " + this.rcc.getRestUri());
                LOGGER.debug(this.messagePrefix("COMPLETED") + "response=" + ToString.valueString((Object)resp));
                LOGGER.debug(this.messagePrefix("COMPLETED") + "headers=" + ToString.valueString((Object)headers));
                LOGGER.debug(this.messagePrefix("COMPLETED") + "body=" + body);
            }
        }

        protected final void reportFailed(Throwable th) {
            if (LOGGER.isInfoEnabled()) {
                long endTime = System.currentTimeMillis();
                LOGGER.info(this.messagePrefix("TIME ELAPSED (FAILED)") + (endTime - this.rcc.getStartTime()) + " ms " + this.rcc.getRestUri());
            }
            if (LOGGER.isDebugEnabled()) {
                String hdr = "COMPLETED FAILED";
                LOGGER.debug(this.messagePrefix("COMPLETED FAILED") + this.rcc.getRestUri() + ": exception: " + th);
            }
        }

        protected final void handleException(Throwable th) {
            Throwable newTh = RestClient.this.rebuildException(this.rcc, th);
            this.reportFailed(newTh);
            this.rcc.getFuture().completeExceptionally(newTh);
        }
    }

    public static class QueryParams {
        public final Map<String, List<Object>> params = new HashMap<String, List<Object>>();

        public QueryParams add(String name, String ... values) {
            this.params.compute(name, (k, v) -> {
                if (v == null) {
                    return Arrays.stream(values).map(sv -> sv).collect(Collectors.toList());
                }
                v.addAll(Arrays.asList(values));
                return v;
            });
            return this;
        }

        public String toUrlString() {
            try {
                URIBuilder bldr = new URIBuilder("");
                this.toUrlString(bldr);
                URI uri = bldr.build();
                String ret = uri.toString();
                return ret;
            }
            catch (URISyntaxException e) {
                throw new InternalException("Could not create query URL for empty string", new Object[]{e});
            }
        }

        public String toUrlStringDecoded() {
            String encoded = this.toUrlString();
            try {
                String ret = URLDecoder.decode(encoded, "UTF-8");
                return ret;
            }
            catch (UnsupportedEncodingException e) {
                throw new InternalException((Throwable)e, "Unknown encoding", new Object[0]);
            }
        }

        public void toUrlString(URIBuilder bldr) {
            Set<String> keySet = this.params.keySet();
            ArrayList<String> keys = new ArrayList<String>(keySet);
            Collections.sort(keys);
            for (String key : keys) {
                List<Object> values = this.params.get(key);
                for (Object value : values) {
                    bldr = bldr.addParameter(key, (String)value);
                }
            }
        }

        public String toString() {
            return ToString.with((Object)this).field("params", this.params).get();
        }
    }

    public static class MeasuredFuture<T>
    extends CompletableFuture<T> {
        private final AsyncMetrics metrics;
        private final long startNanos;

        public MeasuredFuture(AsyncMetrics metrics) {
            this.metrics = metrics;
            this.startNanos = metrics.working.durationStart();
        }

        @Override
        public boolean complete(T value) {
            this.metrics.working.durationEndNow(this.startNanos);
            return super.complete(value);
        }

        @Override
        public boolean completeExceptionally(Throwable ex) {
            this.metrics.working.durationEndNow(this.startNanos);
            return super.completeExceptionally(ex);
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            try (Timer.Stopwatch sw = this.metrics.blocked();){
                Object t = super.get();
                return t;
            }
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try (Timer.Stopwatch sw = this.metrics.blocked();){
                Object t = super.get(timeout, unit);
                return t;
            }
        }
    }

    public static abstract class AbstractRestCallContext<T>
    implements RestCallContext<T> {
        private static final AtomicLong instanceCounter = new AtomicLong();
        public final long instanceNumber = instanceCounter.incrementAndGet();
        public final RequestContext requestContext;
        public final Class<T> klass;
        public final String root;
        public final String path;
        public final QueryParams params;
        public final MediaType mediaType;
        public final Map<String, List<String>> headers;
        public final Map<String, NewCookie> setCookies;
        public final MeasuredFuture<T> mf;
        public long startTime;
        protected String verb = "";

        public AbstractRestCallContext(RequestContext requestContext, Class<T> klass, MeasuredFuture<T> mf, String root, String path, QueryParams params, MediaType mediaType, Map<String, List<String>> headers, Map<String, NewCookie> setCookies) {
            this.requestContext = requestContext;
            this.klass = klass;
            this.mf = mf;
            this.root = root;
            this.path = path;
            this.params = params;
            this.mediaType = mediaType;
            this.headers = headers;
            this.setCookies = setCookies;
        }

        @Override
        public Class<?> getTemplateClass() {
            return this.klass;
        }

        @Override
        public CompletableFuture<T> getFuture() {
            return this.mf;
        }

        @Override
        public long instanceNumber() {
            return this.instanceNumber;
        }

        protected void setHeader(String name, String value) {
            List<String> values = this.headers.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                this.headers.put(name, values);
            }
            values.add(value);
        }

        @Override
        public String getRestUri() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.verb);
            sb.append(" ");
            sb.append(this.root);
            if (!this.root.endsWith("/") && !this.path.startsWith("/")) {
                sb.append("/");
            }
            sb.append(this.path);
            if (this.params != null) {
                sb.append(this.params.toUrlString());
            }
            String ret = sb.toString();
            return ret;
        }

        @Override
        public Long getStartTime() {
            return this.startTime;
        }

        public String buildPath(String path) {
            try {
                URIBuilder bldr = new URIBuilder(path);
                if (this.params != null) {
                    this.params.toUrlString(bldr);
                }
                URI uri = bldr.build();
                String ret = uri.toString();
                return ret;
            }
            catch (URISyntaxException e) {
                throw new InternalException("Could not create URL for path " + ToString.valueString((Object)path) + " call-context: " + this, new Object[]{e});
            }
        }

        private String messagePrefix() {
            return "[REST call " + this.instanceNumber() + "] ";
        }

        private String messagePrefix(String heading) {
            return this.messagePrefix() + heading + " ";
        }

        protected void reportCall(String callBody) {
            this.startTime = System.currentTimeMillis();
            if (LOGGER.isDebugEnabled()) {
                String hdr = "START";
                LOGGER.debug(this.messagePrefix("START") + this.getRestUri());
                LOGGER.debug(this.messagePrefix("START") + "headers=" + ToString.valueString(this.headers));
                LOGGER.debug(this.messagePrefix("START") + "setCookies=" + ToString.valueString(this.setCookies));
                if (callBody != null && !callBody.isEmpty()) {
                    LOGGER.debug(this.messagePrefix("START") + "body=" + callBody);
                }
            }
        }
    }

    public static interface RestCallContext<T> {
        public CompletableFuture<T> getFuture();

        public Future<T> get(JaxRs20Classes.InvocationCallback<T> var1);

        public Future<T> get(JaxRs20Classes.InvocationCallback<T> var1, String var2);

        public Future<T> put(JaxRs20Classes.Entity<?> var1, JaxRs20Classes.InvocationCallback<T> var2);

        public Future<T> put(JaxRs20Classes.Entity<?> var1, JaxRs20Classes.InvocationCallback<T> var2, String var3);

        public Future<T> post(JaxRs20Classes.Entity<?> var1, JaxRs20Classes.InvocationCallback<T> var2);

        public Future<T> post(JaxRs20Classes.Entity<?> var1, JaxRs20Classes.InvocationCallback<T> var2, String var3);

        public Future<T> delete(JaxRs20Classes.InvocationCallback<T> var1);

        public Future<T> delete(JaxRs20Classes.InvocationCallback<T> var1, String var2);

        public String getRestUri();

        public Long getStartTime();

        public JaxRs20Exceptions.ProcessingException buildException(Response var1);

        public long instanceNumber();

        public Class<?> getTemplateClass();
    }

    public static interface RestCallContextFactory {
        public <T> RestCallContext<T> buildRestCallContext(RequestContext var1, Class<T> var2, MeasuredFuture<T> var3, String var4, String var5, QueryParams var6, MediaType var7, Map<String, List<String>> var8, Map<String, NewCookie> var9);
    }
}

