/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.crypto.internal.utils;

import com.ibm.bi.platform.commons.messages.Message;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@FunctionalInterface
public interface Validator<T> {
    public static <T> Validator<T> fromConjunction(List<Validator<T>> validators) {
        Objects.requireNonNull(validators);
        return t -> validators.stream().map(validator -> validator.validate(t)).reduce((validation1, validation2) -> {
            boolean isValidConjunction = validation1.isValid && validation2.isValid;
            Stream messageStream1 = validation1.messages != null ? validation1.messages.stream() : Stream.empty();
            Stream messageStream2 = validation2.messages != null ? validation2.messages.stream() : Stream.empty();
            List<Message> combinedMessages = Stream.concat(messageStream1, messageStream2).filter(Objects::nonNull).collect(Collectors.toList());
            return new ValidatorResult(isValidConjunction, combinedMessages);
        }).orElse(new ValidatorResult(true, null));
    }

    public ValidatorResult validate(T var1);

    public static class ValidatorResult {
        public final boolean isValid;
        public final List<Message> messages;

        public ValidatorResult(boolean isValid, List<Message> messages) {
            this.isValid = isValid;
            this.messages = messages;
        }
    }
}

