/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.api.content;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.content.recommender.api.content.IRExplanationItem;
import com.ibm.smarts.content.recommender.internal.pipeline.explain.ExplanationType;
import com.ibm.smarts.core.exceptions.json.JsonDeserializeException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRExplanation {
    private static final Logger LOGGER = LoggerFactory.getLogger(IRExplanation.class);
    String targetField;
    ExplanationType explanationType;
    List<IRExplanationItem> explanationItems;
    double confidence;

    @JsonCreator
    public IRExplanation(@JsonProperty(value="targetField") String targetField, @JsonProperty(value="explanationType") ExplanationType explanationType, @JsonProperty(value="explanationItems") List<IRExplanationItem> explanationItems, @JsonProperty(value="confidence") double confidence) {
        this.explanationType = explanationType;
        this.explanationItems = explanationItems;
        this.confidence = confidence;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public void setConfidence(double confidence) {
        this.confidence = confidence;
    }

    public ExplanationType getExplanationType() {
        return this.explanationType;
    }

    public void setExplanationType(ExplanationType explanationType) {
        this.explanationType = explanationType;
    }

    public List<IRExplanationItem> getExplanationItems() {
        return this.explanationItems;
    }

    public void setExplanationItems(List<IRExplanationItem> explanationItems) {
        this.explanationItems = explanationItems;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.confidence);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.explanationItems == null ? 0 : this.explanationItems.hashCode());
        result = 31 * result + (this.explanationType == null ? 0 : this.explanationType.hashCode());
        result = 31 * result + (this.targetField == null ? 0 : this.targetField.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IRExplanation other = (IRExplanation)obj;
        if (Double.doubleToLongBits(this.confidence) != Double.doubleToLongBits(other.confidence)) {
            return false;
        }
        if (this.explanationItems == null ? other.explanationItems != null : !this.explanationItems.equals(other.explanationItems)) {
            return false;
        }
        if (this.explanationType != other.explanationType) {
            return false;
        }
        return !(this.targetField == null ? other.targetField != null : !this.targetField.equals(other.targetField));
    }

    public String toJSON() {
        return CommonJAXBHelper.marshalToJSON((Object)this, (boolean)true);
    }

    public static IRExplanation fromJSON(String str) {
        try {
            return (IRExplanation)CommonJAXBHelper.unmarshalFromJSON(IRExplanation.class, (String)str);
        }
        catch (JsonDeserializeException e) {
            LOGGER.error("Error parsing IRExplainComparison", (Throwable)e);
            return null;
        }
    }
}

