/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal.context;

import com.ibm.smarts.ca.core.impl.SmartsCaClientManager;
import com.ibm.smarts.content.recommender.api.content.ComparisonScope;
import com.ibm.smarts.content.recommender.api.content.IRContent;
import com.ibm.smarts.content.recommender.internal.util.QuickAccessSmartsModule;
import com.ibm.smarts.core.util.ObjectCreator;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.schema.SmartsModule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ComparisonContext {
    private final IRContent inputIRContent;
    private SmartsCaClientManager clientManager;
    private List<IRContent> result = new ArrayList<IRContent>();
    private QuickAccessSmartsModule indexedSmartsModule;
    private ComparisonScope scope = null;

    private SmartsCaClientManager getSmartsCaClientManager(RequestContext requestContext) {
        if (requestContext == null) {
            return null;
        }
        ObjectCreator clientManagerCreator = (ObjectCreator)requestContext.getRequestAttribute("com.ibm.smarts.rest.clientManager");
        if (clientManagerCreator == null) {
            return null;
        }
        return (SmartsCaClientManager)clientManagerCreator.create(requestContext);
    }

    public ComparisonContext(IRContent inputIRContent, ComparisonScope scope, RequestContext requestContext, QuickAccessSmartsModule indexedSmartsModule) {
        this.scope = scope;
        this.inputIRContent = inputIRContent;
        this.clientManager = this.getSmartsCaClientManager(requestContext);
        this.indexedSmartsModule = indexedSmartsModule;
    }

    public SmartsCaClientManager getClientManager() {
        return this.clientManager;
    }

    public IRContent getInputIRContent() {
        return this.inputIRContent;
    }

    public void addToResult(IRContent content) {
        this.result.add(content);
    }

    public List<IRContent> getResult() {
        return this.result;
    }

    public void setResult(List<IRContent> result) {
        this.result = result;
    }

    public QuickAccessSmartsModule getIndexedSmartsModule() {
        return this.indexedSmartsModule;
    }

    public int getMaxComparisonsPerIR() {
        return this.scope.getMaxComparisonsPerIR();
    }

    public SmartsModule getSmartsModule() {
        return this.scope.getSmartsModule();
    }

    public boolean isFilterFollowMeasureReplacment() {
        return this.scope.isFilterFollowMeasureReplacment();
    }

    public Map<String, Set<String>> getJoinableColumnMap() {
        return this.scope.getJoinableColumnMap();
    }
}

