/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal.context;

import com.ibm.smarts.ca.core.impl.SmartsCaClientManager;
import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.content.recommender.api.AnalysisScope;
import com.ibm.smarts.content.recommender.api.content.IRCombination;
import com.ibm.smarts.content.recommender.api.content.IRContent;
import com.ibm.smarts.content.recommender.internal.ResolvedTopic;
import com.ibm.smarts.content.recommender.internal.context.CandidateCombination;
import com.ibm.smarts.content.recommender.internal.context.drivers.DecisionTree;
import com.ibm.smarts.content.recommender.internal.context.drivers.Node;
import com.ibm.smarts.content.recommender.internal.util.QuickAccessSmartsModule;
import com.ibm.smarts.core.util.ObjectCreator;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.schema.FieldRecommendationRecord;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class ContentsContext {
    private final AnalysisScope scope;
    private ResolvedTopic resolvedTopic;
    private DecisionTree decisionTree;
    private List<List<Node>> drivers = new ArrayList<List<Node>>();
    private List<CandidateCombination> decisionTreeCombinations = new ArrayList<CandidateCombination>();
    private List<CandidateCombination> candidatePredictiveCombinations = new ArrayList<CandidateCombination>();
    private List<IRCombination> guidedCombinations = new ArrayList<IRCombination>();
    private List<BaseFilter> topBottomInclusionFilters = new ArrayList<BaseFilter>();
    private List<IRContent> irContents = new ArrayList<IRContent>();
    private Set<Set<String>> nonPermissibleCombos = new HashSet<Set<String>>();
    private final RequestContext requestContext;
    private SmartsCaClientManager clientManager;
    private List<FieldRecommendationRecord> interestingFields = new ArrayList<FieldRecommendationRecord>();
    private List<FieldRecommendationRecord> influencerFields = new ArrayList<FieldRecommendationRecord>();
    private List<CandidateCombination> relatedCombinations = new ArrayList<CandidateCombination>();
    private QuickAccessSmartsModule indexedSM;

    public void setClientManager(SmartsCaClientManager clientManager) {
        this.clientManager = clientManager;
    }

    private SmartsCaClientManager getSmartsCaClientManager(RequestContext requestContext) {
        if (requestContext == null) {
            return null;
        }
        ObjectCreator clientManagerCreator = (ObjectCreator)requestContext.getRequestAttribute("com.ibm.smarts.rest.clientManager");
        if (clientManagerCreator == null) {
            return null;
        }
        return (SmartsCaClientManager)clientManagerCreator.create(requestContext);
    }

    public ContentsContext(AnalysisScope scope, RequestContext requestContext, List<FieldRecommendationRecord> interestFields, QuickAccessSmartsModule quick) {
        this.scope = scope;
        this.requestContext = requestContext;
        this.clientManager = this.getSmartsCaClientManager(requestContext);
        this.interestingFields = interestFields;
        this.influencerFields = new ArrayList<FieldRecommendationRecord>();
        this.indexedSM = quick;
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public AnalysisScope getScope() {
        return this.scope;
    }

    public SmartsCaClientManager getClientManager() {
        return this.clientManager;
    }

    public ResolvedTopic getResolvedTopic() {
        return this.resolvedTopic;
    }

    public void setResolvedTopic(ResolvedTopic resolvedTopic) {
        this.resolvedTopic = resolvedTopic;
    }

    public DecisionTree getDecisionTree() {
        return this.decisionTree;
    }

    public void setDecisionTree(DecisionTree decisionTree) {
        this.decisionTree = decisionTree;
    }

    public List<List<Node>> getDrivers() {
        return this.drivers;
    }

    public void setDrivers(List<List<Node>> drivers) {
        this.drivers = drivers;
    }

    public List<CandidateCombination> getDecisionTreeCombinations() {
        return this.decisionTreeCombinations;
    }

    public void addDecisionTreeCombination(CandidateCombination candidate) {
        this.decisionTreeCombinations.add(candidate);
    }

    public void addDecisionTreeCombinations(List<CandidateCombination> candidates) {
        this.decisionTreeCombinations.addAll(candidates);
    }

    public List<FieldRecommendationRecord> getInterestingFields() {
        return this.interestingFields;
    }

    public void setInfluencers(List<FieldRecommendationRecord> recs) {
        this.influencerFields = recs;
    }

    public List<FieldRecommendationRecord> getInfluencers() {
        return this.influencerFields;
    }

    public void setInterestingFields(List<FieldRecommendationRecord> recs) {
        this.interestingFields = recs;
    }

    public List<CandidateCombination> getRelatedCombinations() {
        return this.relatedCombinations;
    }

    public void setRelatedCombinations(List<CandidateCombination> combinations) {
        this.relatedCombinations = combinations;
    }

    public QuickAccessSmartsModule getIndexedSM() {
        return this.indexedSM;
    }

    public void setIndexedSM(QuickAccessSmartsModule indexedSM) {
        this.indexedSM = indexedSM;
    }

    public void addPredictiveCandidateCombination(CandidateCombination candidate) {
        this.candidatePredictiveCombinations.add(candidate);
    }

    public List<BaseFilter> getTopBottomInclusionFilters() {
        return this.topBottomInclusionFilters;
    }

    public List<CandidateCombination> getCandidatePredictiveCombinations() {
        return this.candidatePredictiveCombinations;
    }

    public List<IRContent> getIRContents() {
        return this.irContents;
    }

    public void addIRContent(IRContent ir) {
        this.irContents.add(ir);
    }

    public void addIRContents(List<IRContent> irs) {
        this.irContents.addAll(irs);
    }

    public List<IRCombination> getGuidedCombinations() {
        return this.guidedCombinations;
    }

    public void setGuidedCombinations(List<IRCombination> guidedCombinations) {
        this.guidedCombinations = guidedCombinations;
    }

    public Set<Set<String>> getNonPermissibleCombos() {
        return this.nonPermissibleCombos;
    }

    public void setNonPermissibleCombos(Set<Set<String>> nonPermissibleCombos) {
        this.nonPermissibleCombos = nonPermissibleCombos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContentsContext)) {
            return false;
        }
        ContentsContext that = (ContentsContext)o;
        return Objects.equals(this.getScope(), that.getScope()) && Objects.equals(this.getResolvedTopic(), that.getResolvedTopic()) && Objects.equals(this.getDecisionTree(), that.getDecisionTree()) && Objects.equals(this.getDrivers(), that.getDrivers()) && Objects.equals(this.getDecisionTreeCombinations(), that.getDecisionTreeCombinations()) && Objects.equals(this.getCandidatePredictiveCombinations(), that.getCandidatePredictiveCombinations()) && Objects.equals(this.getGuidedCombinations(), that.getGuidedCombinations()) && Objects.equals(this.getTopBottomInclusionFilters(), that.getTopBottomInclusionFilters()) && Objects.equals(this.irContents, that.irContents) && Objects.equals(this.getNonPermissibleCombos(), that.getNonPermissibleCombos()) && Objects.equals(this.getRequestContext(), that.getRequestContext()) && Objects.equals(this.getClientManager(), that.getClientManager()) && Objects.equals(this.getInterestingFields(), that.getInterestingFields()) && Objects.equals(this.influencerFields, that.influencerFields) && Objects.equals(this.getRelatedCombinations(), that.getRelatedCombinations()) && Objects.equals(this.getIndexedSM(), that.getIndexedSM());
    }

    public int hashCode() {
        return Objects.hash(this.getScope(), this.getResolvedTopic(), this.getDecisionTree(), this.getDrivers(), this.getDecisionTreeCombinations(), this.getCandidatePredictiveCombinations(), this.getGuidedCombinations(), this.getTopBottomInclusionFilters(), this.irContents, this.getNonPermissibleCombos(), this.getRequestContext(), this.getClientManager(), this.getInterestingFields(), this.influencerFields, this.getRelatedCombinations(), this.getIndexedSM());
    }

    public String toString() {
        return "ContentsContext{scope=" + this.scope + ", resolvedTopic=" + this.resolvedTopic + ", decisionTree=" + this.decisionTree + ", drivers=" + this.drivers + ", decisionTreeCombinations=" + this.decisionTreeCombinations + ", candidatePredictiveCombinations=" + this.candidatePredictiveCombinations + ", guidedCombinations=" + this.guidedCombinations + ", topBottomInclusionFilters=" + this.topBottomInclusionFilters + ", irContents=" + this.irContents + ", nonPermissibleCombos=" + this.nonPermissibleCombos + ", requestContext=" + this.requestContext + ", clientManager=" + this.clientManager + ", interestingFields=" + this.interestingFields + ", influencerFields=" + this.influencerFields + ", relatedCombinations=" + this.relatedCombinations + ", indexedSM=" + this.indexedSM + '}';
    }
}

