/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal.context.drivers;

import com.ibm.smarts.content.recommender.internal.util.QuickAccessSmartsModule;
import com.ibm.smarts.schema.BivariateStatistics;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.FieldRecommendationRecord;
import com.ibm.smarts.schema.Statistic;
import com.ibm.smarts.schema.util.ColumnIdentifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DriverSelectorUtil {
    private static final float OBVIOUS_CORRELATION = 0.5f;

    public static List<String> execute(QuickAccessSmartsModule indexedSM, List<FieldRecommendationRecord> influencers, String targetFieldId, int maxNum) {
        ArrayList<String> columnIds = new ArrayList<String>();
        for (FieldRecommendationRecord influencer : influencers) {
            if (!DriverSelectorUtil.isMeasure(indexedSM, influencer.getFieldIDForExpression()) || DriverSelectorUtil.isHighlyCorrelatedWith(indexedSM, influencer.getFieldIDForExpression(), columnIds)) continue;
            columnIds.add(influencer.getFieldIDForExpression());
            if (columnIds.size() != maxNum) continue;
            break;
        }
        return columnIds;
    }

    private static boolean isMeasure(QuickAccessSmartsModule indexedSM, String columnIdForExpr) {
        DatasetInfo ds = indexedSM.getDatasetInfo(columnIdForExpr);
        List<ColumnInfo> measures = indexedSM.getAllMeasures(ds.getId());
        return measures.stream().anyMatch(c -> c.getIdForExpression().equals(columnIdForExpr));
    }

    private static boolean isHighlyCorrelatedWith(QuickAccessSmartsModule indexedSM, String columnIdForExpr, List<String> columnIds) {
        return columnIds.stream().anyMatch(c -> DriverSelectorUtil.isHighlyCorrelated(indexedSM, columnIdForExpr, c));
    }

    private static boolean isHighlyCorrelated(QuickAccessSmartsModule quickAccess, String ci1Id, String ci2Id) {
        BivariateStatistics biv;
        ColumnIdentifier ci2Identifier;
        ColumnIdentifier ci1Identifier = quickAccess.getColumnIdentifier(ci1Id);
        Map<ColumnIdentifier, BivariateStatistics> bivs = quickAccess.getBivariates(ci1Identifier);
        return bivs != null && bivs.containsKey(ci2Identifier = quickAccess.getColumnIdentifier(ci2Id)) && DriverSelectorUtil.isObvious(biv = bivs.get(ci2Identifier));
    }

    private static boolean isObvious(BivariateStatistics biv) {
        for (Statistic stat : biv.getStatistics()) {
            if (!(stat.getValue().floatValue() > 0.5f)) continue;
            return true;
        }
        return false;
    }
}

