/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal.pipeline.content;

import com.ibm.smarts.content.recommender.api.ContentException;
import com.ibm.smarts.content.recommender.api.TopicScope;
import com.ibm.smarts.content.recommender.internal.SmartsStatus;
import com.ibm.smarts.content.recommender.internal.context.CandidateCombination;
import com.ibm.smarts.content.recommender.internal.context.ContentsContext;
import com.ibm.smarts.content.recommender.internal.context.drivers.DecisionTree;
import com.ibm.smarts.content.recommender.internal.context.drivers.Driver;
import com.ibm.smarts.content.recommender.internal.context.drivers.Node;
import com.ibm.smarts.content.recommender.internal.pipeline.content.IContentStep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ContentResolutionFromDecisionTree
implements IContentStep {
    private final double minConfidenceThreshold;
    private final int maxDriverDepth;

    public ContentResolutionFromDecisionTree(double minConfidenceThreshold, int maxDriverDepth) {
        this.minConfidenceThreshold = minConfidenceThreshold;
        this.maxDriverDepth = maxDriverDepth;
    }

    public List<List<Node>> depthFirstTraverse(DecisionTree tree, Node node, List<Node> path) {
        ArrayList<List<Node>> result = new ArrayList<List<Node>>();
        if (node.depth < this.maxDriverDepth) {
            Driver driver = tree.getDriver(node.id);
            if (driver != null && driver.importance < this.minConfidenceThreshold) {
                return Collections.emptyList();
            }
            node.children.forEach(c -> {
                ArrayList<Node> branch = new ArrayList<Node>();
                branch.addAll(path);
                branch.add((Node)c);
                result.addAll(this.depthFirstTraverse(tree, (Node)c, (List<Node>)branch));
            });
        } else {
            result.add(path);
        }
        return result;
    }

    private Optional<CandidateCombination> getTopDriverCandidate(ContentsContext context) {
        DecisionTree tree = context.getDecisionTree();
        List<Driver> drivers = tree.getDrivers();
        Optional<Driver> topDriver = drivers.stream().max(Comparator.comparingDouble(d -> d.importance));
        if (!topDriver.isPresent()) {
            return Optional.empty();
        }
        ArrayList<String> columns = new ArrayList<String>();
        Optional<TopicScope> scope = context.getScope().getPrimaryTopic();
        if (!scope.isPresent()) {
            return Optional.empty();
        }
        columns.add(scope.get().getId());
        columns.add(topDriver.get().id);
        return Optional.of(new CandidateCombination(columns, topDriver.get().id, topDriver.get().importance));
    }

    private double getChainImportance(ContentsContext context, List<String> chain) {
        String specificDriver;
        DecisionTree tree = context.getDecisionTree();
        Driver driver = tree.getDriver(specificDriver = chain.get(chain.size() - 1));
        if (driver != null) {
            return driver.importance;
        }
        Optional<Driver> maxDriver = chain.stream().map(d -> tree.getDriver((String)d)).filter(Objects::nonNull).max(Comparator.comparing(d -> d.importance));
        if (maxDriver.isPresent()) {
            return maxDriver.get().importance;
        }
        return 0.0;
    }

    private List<CandidateCombination> getDriverCandidates(ContentsContext context) {
        List<List<Node>> driverChains = context.getDrivers();
        Set uniqueDriverChain = driverChains.stream().map(dc -> dc.stream().map(n -> n.id).collect(Collectors.toList())).collect(Collectors.toSet());
        Optional<TopicScope> scope = context.getScope().getPrimaryTopic();
        if (!scope.isPresent()) {
            throw new ContentException(SmartsStatus.PRIMARY_TOPIC_MISSING);
        }
        List<CandidateCombination> candidates = uniqueDriverChain.stream().distinct().map(chain -> {
            ArrayList<String> columns = new ArrayList<String>();
            columns.add(((TopicScope)scope.get()).getId());
            columns.addAll((Collection<String>)chain);
            return new CandidateCombination(columns, ((TopicScope)scope.get()).getId(), this.getChainImportance(context, columns));
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return candidates;
    }

    private void addScopeCandidates(ContentsContext context) {
        Optional<CandidateCombination> topDriverContent;
        List<CandidateCombination> candidates = this.getDriverCandidates(context);
        context.addDecisionTreeCombinations(candidates);
        if (candidates.isEmpty() && (topDriverContent = this.getTopDriverCandidate(context)).isPresent()) {
            context.addDecisionTreeCombination(topDriverContent.get());
        }
    }

    @Override
    public void accept(ContentsContext context) {
        DecisionTree tree = context.getDecisionTree();
        if (tree == null) {
            throw new ContentException(SmartsStatus.MISSING_DECISION_TREE);
        }
        Node root = tree.getNode();
        List<List<Node>> drivers = this.depthFirstTraverse(tree, root, Collections.emptyList());
        context.setDrivers(drivers);
        this.addScopeCandidates(context);
    }
}

