/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal.pipeline.content;

import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.ca.core.impl.SmartsCaClientManager;
import com.ibm.smarts.ca.core.impl.frf.CaFRFClient;
import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.content.recommender.api.ContentException;
import com.ibm.smarts.content.recommender.api.TopicScope;
import com.ibm.smarts.content.recommender.internal.SmartsStatus;
import com.ibm.smarts.content.recommender.internal.context.ContentsContext;
import com.ibm.smarts.content.recommender.internal.context.drivers.DecisionTree;
import com.ibm.smarts.content.recommender.internal.pipeline.content.IContentStep;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.rest.client.util.JaxRs20Exceptions;
import com.ibm.smarts.schema.FieldRecommendationRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.WebApplicationException;

public class DecisionTreeRetrieval
implements IContentStep {
    private String createFRFRequest(String moduleId, String targetFieldId) {
        JSONObject request = new JSONObject();
        request.put((Object)"moduleId", (Object)moduleId);
        request.put((Object)"shapedModule", (Object)false);
        request.put((Object)"targetFieldIDForExpression", (Object)targetFieldId);
        Module module = new Module();
        String dummy = CommonJAXBHelper.marshalToJSON((Object)module);
        request.put((Object)"tempModule", (Object)dummy);
        JSONObject tuningParams = new JSONObject();
        tuningParams.put((Object)"allowCategoryTarget", (Object)true);
        tuningParams.put((Object)"noCorrelationLimit", (Object)true);
        request.put((Object)"tuningParams", (Object)tuningParams);
        return request.toString();
    }

    private List<FieldRecommendationRecord> getInfleuncers(String moduleId, String targetFieldId, SmartsCaClientManager clientManager) {
        JSONArray fields;
        JSONObject recommendedFields;
        String frfRequest;
        CaFRFClient frfClient = clientManager.getFRFClient();
        JSONObject response = frfClient.relatedFields(frfRequest = this.createFRFRequest(moduleId, targetFieldId));
        JSONObject predictStatus = (JSONObject)response.get((Object)"predictStatus");
        if (predictStatus == null) {
            return Collections.emptyList();
        }
        if (!((String)predictStatus.get((Object)"state")).equalsIgnoreCase("SUCCESS")) {
            return Collections.emptyList();
        }
        ArrayList<FieldRecommendationRecord> influencers = new ArrayList<FieldRecommendationRecord>();
        JSONObject results = (JSONObject)response.get((Object)"results");
        if (results != null && (recommendedFields = (JSONObject)results.get((Object)"recommendedFields")) != null && (fields = (JSONArray)recommendedFields.get((Object)"fields")) != null && !fields.isEmpty()) {
            int len = fields.size();
            for (int i = 0; i < len; ++i) {
                JSONObject field = (JSONObject)fields.get(i);
                FieldRecommendationRecord record = new FieldRecommendationRecord();
                record.setFieldID((String)field.get((Object)"fieldID"));
                record.setFieldIDForExpression((String)field.get((Object)"fieldIDForExpression"));
                record.setTableID((String)field.get((Object)"tableID"));
                influencers.add(record);
            }
        }
        return influencers;
    }

    private JSONArray buildInputsArray(List<FieldRecommendationRecord> inputs) {
        JSONArray inputsJSON = new JSONArray();
        for (FieldRecommendationRecord frr : inputs) {
            inputsJSON.add((Object)frr.getFieldIDForExpression());
        }
        return inputsJSON;
    }

    private JSONObject buildKeyDriversSpec(String targetFieldId, List<FieldRecommendationRecord> inputs) {
        JSONObject spec = new JSONObject();
        spec.put((Object)"version", (Object)"1.1");
        spec.put((Object)"targetId", (Object)targetFieldId);
        JSONArray inputsArray = this.buildInputsArray(inputs);
        spec.put((Object)"inputs", (Object)inputsArray);
        spec.put((Object)"filters", (Object)new JSONArray());
        JSONArray methodsJSON = new JSONArray();
        methodsJSON.add((Object)"drivers");
        spec.put((Object)"methods", (Object)methodsJSON);
        return spec;
    }

    private String getKeyDrivers(String moduleId, String targetFieldId, String sourceType, SmartsCaClientManager clientManager, List<FieldRecommendationRecord> inputs) {
        try {
            JSONObject keydriversSpec = this.buildKeyDriversSpec(targetFieldId, inputs);
            String keyDrivers = clientManager.getDatasetsClient().getKeyDrivers(moduleId, sourceType, keydriversSpec.toString());
            return keyDrivers;
        }
        catch (InternalException | JaxRs20Exceptions.ResponseProcessingException | WebApplicationException e) {
            throw new ContentException(SmartsStatus.ERROR_FINDING_KEY_DRIVERS);
        }
    }

    @Override
    public void accept(ContentsContext context) {
        Optional<TopicScope> topic = context.getScope().getPrimaryTopic();
        if (!topic.isPresent()) {
            throw new ContentException(SmartsStatus.PRIMARY_TOPIC_MISSING);
        }
        String decisionTree = this.getKeyDrivers(context.getScope().getSmartsModule().getId(), topic.get().getId(), context.getScope().getSourceType(), context.getClientManager(), context.getInfluencers());
        if (decisionTree == null) {
            throw new ContentException(SmartsStatus.MISSING_DECISION_TREE);
        }
        List<DecisionTree> trees = DecisionTree.fromJSON(decisionTree);
        Optional<DecisionTree> tree = trees.stream().filter(t -> t.getTarget().id.equalsIgnoreCase(((TopicScope)topic.get()).getId())).findFirst();
        if (!tree.isPresent()) {
            throw new ContentException(SmartsStatus.MISSING_DECISION_TREE);
        }
        context.setDecisionTree(tree.get());
    }
}

