/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal.pipeline.content;

import com.ibm.smarts.content.recommender.api.ContentException;
import com.ibm.smarts.content.recommender.api.TopicScope;
import com.ibm.smarts.content.recommender.internal.SmartsStatus;
import com.ibm.smarts.content.recommender.internal.context.ContentsContext;
import com.ibm.smarts.content.recommender.internal.pipeline.content.IContentStep;
import com.ibm.smarts.schema.DatasetInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class PrimaryTopicSelection
implements IContentStep {
    @Override
    public void accept(ContentsContext context) {
        if (context == null) {
            throw new ContentException(SmartsStatus.MISSING_CONTEXT);
        }
        if (context.getScope() == null) {
            throw new ContentException(SmartsStatus.MISSING_CONTEXT_SCOPE);
        }
        List<TopicScope> topics = context.getScope().getSecondaryTopics();
        if (topics.isEmpty()) {
            return;
        }
        Predicate<TopicScope> hasFilter = topic -> topic.getFilter() != null;
        Predicate<TopicScope> isMonetary = topic -> {
            DatasetInfo dsInfo = context.getResolvedTopic().getTopicsToDatasets().get(topic.getId());
            List monetaryColumns = context.getIndexedSM().getMonetaryColumns(dsInfo.getId()).stream().map(c -> c.getIdForExpression()).collect(Collectors.toList());
            return monetaryColumns.contains(topic.getId());
        };
        Predicate<TopicScope> isPureMeasure = topic -> {
            DatasetInfo dsInfo = context.getResolvedTopic().getTopicsToDatasets().get(topic.getId());
            List measureColumns = context.getIndexedSM().getMeasures(dsInfo.getId()).stream().map(c -> c.getIdForExpression()).collect(Collectors.toList());
            return measureColumns.contains(topic.getId());
        };
        Predicate<TopicScope> isMeasure = topic -> {
            DatasetInfo dsInfo = context.getResolvedTopic().getTopicsToDatasets().get(topic.getId());
            List measureColumns = context.getIndexedSM().getAllMeasures(dsInfo.getId()).stream().map(c -> c.getIdForExpression()).collect(Collectors.toList());
            return measureColumns.contains(topic.getId());
        };
        Predicate<TopicScope> isPlanned = topic -> {
            DatasetInfo dsInfo = context.getResolvedTopic().getTopicsToDatasets().get(topic.getId());
            return context.getIndexedSM().getPlannedToActual(dsInfo.getId()).containsKey(topic.getId());
        };
        Consumer<TopicScope> setPrimary = topic -> {
            topic.setPrimary(true);
            context.getScope().setPrimaryTopic((TopicScope)topic);
            topics.remove(topic);
        };
        ArrayList<TopicScope> topicWithFilter = new ArrayList<TopicScope>();
        ArrayList<TopicScope> topicMonetary = new ArrayList<TopicScope>();
        ArrayList<TopicScope> topicPureMeasure = new ArrayList<TopicScope>();
        ArrayList<TopicScope> topicMeasure = new ArrayList<TopicScope>();
        for (TopicScope topic2 : topics) {
            if (hasFilter.test(topic2)) {
                topicWithFilter.add(topic2);
                continue;
            }
            if (isMonetary.test(topic2)) {
                topicMonetary.add(topic2);
                continue;
            }
            if (isPureMeasure.test(topic2)) {
                topicPureMeasure.add(topic2);
                continue;
            }
            if (!isMeasure.test(topic2)) continue;
            topicMeasure.add(topic2);
        }
        if (!topicWithFilter.isEmpty()) {
            ((TopicScope)topicWithFilter.get(0)).setPrimary(true);
            setPrimary.accept((TopicScope)topicWithFilter.get(0));
        } else if (!topicMonetary.isEmpty()) {
            ((TopicScope)topicMonetary.get(0)).setPrimary(true);
            setPrimary.accept((TopicScope)topicMonetary.get(0));
        } else if (!topicPureMeasure.isEmpty()) {
            ((TopicScope)topicPureMeasure.get(0)).setPrimary(true);
            setPrimary.accept((TopicScope)topicPureMeasure.get(0));
        } else if (!topicMeasure.isEmpty()) {
            ((TopicScope)topicMeasure.get(0)).setPrimary(true);
            setPrimary.accept((TopicScope)topicMeasure.get(0));
        } else {
            setPrimary.accept(topics.get(0));
        }
    }
}

