/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal.pipeline.content;

import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.common.modifiers.FilterType;
import com.ibm.smarts.common.modifiers.FilterTypeConversionException;
import com.ibm.smarts.common.modifiers.InclusionExclusionFilter;
import com.ibm.smarts.content.recommender.api.ContentException;
import com.ibm.smarts.content.recommender.api.TopicScope;
import com.ibm.smarts.content.recommender.api.content.IRColumn;
import com.ibm.smarts.content.recommender.api.content.IRCombination;
import com.ibm.smarts.content.recommender.api.content.IRContent;
import com.ibm.smarts.content.recommender.internal.SmartsStatus;
import com.ibm.smarts.content.recommender.internal.context.CandidateCombination;
import com.ibm.smarts.content.recommender.internal.context.ContentsContext;
import com.ibm.smarts.content.recommender.internal.pipeline.content.IContentStep;
import com.ibm.smarts.content.recommender.internal.util.CommonUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecondaryContentAggregation
implements IContentStep {
    private static final int MAX_NUMBER_OF_IRS = 3;
    private final int defaultMaxCombinations;
    private final TopicScope originalPrimary;
    private static final Logger LOGGER = LoggerFactory.getLogger(SecondaryContentAggregation.class);

    public SecondaryContentAggregation(int maxCombinations, TopicScope originalPrimary) {
        this.defaultMaxCombinations = maxCombinations;
        this.originalPrimary = originalPrimary;
    }

    @Override
    public void accept(ContentsContext context) {
        if (context == null) {
            throw new ContentException(SmartsStatus.MISSING_CONTEXT);
        }
        if (context.getScope() == null) {
            throw new ContentException(SmartsStatus.MISSING_CONTEXT_SCOPE);
        }
        List<CandidateCombination> candidates = this.getAppropriateSecondaryCombinations(context.getRelatedCombinations(), this.originalPrimary);
        if (candidates.size() <= 1) {
            return;
        }
        candidates = candidates.subList(0, Math.min(this.defaultMaxCombinations, candidates.size()));
        int count = 0;
        for (BaseFilter filter : context.getTopBottomInclusionFilters()) {
            if (!filter.getType().equals((Object)FilterType.INCLUSION_EXCLUSION)) continue;
            ArrayList<IRCombination> combinations = new ArrayList<IRCombination>();
            combinations.addAll(candidates.stream().map(r -> new IRCombination(r.getColumns().stream().map(c -> new IRColumn((String)c, CommonUtil.findAggregation(c, context))).collect(Collectors.toList()), Collections.emptyList(), r.getScore())).collect(Collectors.toList()));
            ArrayList<BaseFilter> filters = new ArrayList<BaseFilter>();
            filters.add(filter);
            try {
                InclusionExclusionFilter ief = filter.toInclusionExclusionFilter();
                IRContent irToAdd = new IRContent(((InclusionExclusionFilter.DataValue)ief.getInclusionValues().get(0)).getUniqueValue(), ((InclusionExclusionFilter.DataValue)ief.getInclusionValues().get(0)).getDisplayValue(), combinations, filters);
                irToAdd.getGlobalFilters().addAll(context.getScope().getFilters());
                context.addIRContent(irToAdd);
                if (++count != 3) continue;
                break;
            }
            catch (FilterTypeConversionException e) {
                throw new ContentException(SmartsStatus.FAILED_TO_CONVERT_FILTER);
            }
        }
    }

    private List<CandidateCombination> getAppropriateSecondaryCombinations(List<CandidateCombination> secondaryCandidates, TopicScope originalTopic) {
        ArrayList<CandidateCombination> appropriateCombinations = new ArrayList<CandidateCombination>();
        for (CandidateCombination combo : secondaryCandidates) {
            if (combo.getColumns().contains(originalTopic.getId())) continue;
            appropriateCombinations.add(combo);
        }
        return appropriateCombinations;
    }
}

