/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal.pipeline.content;

import com.ibm.smarts.common.modifiers.InclusionExclusionFilter;
import com.ibm.smarts.common.modifiers.MissingFilterParametersException;
import com.ibm.smarts.common.modifiers.TopBottomFilter;
import com.ibm.smarts.common.modifiers.TopBottomFilteringMethod;
import com.ibm.smarts.content.recommender.api.ContentException;
import com.ibm.smarts.content.recommender.api.TopicScope;
import com.ibm.smarts.content.recommender.internal.ContentQueryUtil;
import com.ibm.smarts.content.recommender.internal.SmartsStatus;
import com.ibm.smarts.content.recommender.internal.context.ContentsContext;
import com.ibm.smarts.content.recommender.internal.pipeline.content.IContentStep;
import com.ibm.smarts.content.recommender.internal.util.Pair;
import com.ibm.smarts.model.value.Value;
import com.ibm.smarts.schema.AggregationType;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.StatisticType;
import com.ibm.smarts.schema.util.StatisticsUtil;
import java.util.ArrayList;
import java.util.List;

public class TopBottomContentResolution
implements IContentStep {
    private static final int MAXIMUM_DOMAIN_SIZE = 3;
    private final TopicScope primary;

    public TopBottomContentResolution(TopicScope topBottomFilteredTopic) {
        this.primary = topBottomFilteredTopic;
    }

    @Override
    public void accept(ContentsContext context) {
        if (context == null) {
            throw new ContentException(SmartsStatus.MISSING_CONTEXT);
        }
        if (context.getScope() == null) {
            throw new ContentException(SmartsStatus.MISSING_CONTEXT_SCOPE);
        }
        if (context.getScope().getQueryableAssetId() == null) {
            throw new ContentException(SmartsStatus.MISSING_CONTEXT_SCOPE);
        }
        List<InclusionExclusionFilter> queriedValues = this.getQueriedValues(context);
        context.getTopBottomInclusionFilters().addAll(queriedValues);
    }

    private List<InclusionExclusionFilter> getQueriedValues(ContentsContext context) {
        int percentageDomainSize;
        ContentQueryUtil util = new ContentQueryUtil(context.getClientManager(), context.getScope().getQueryableAssetId(), context.getScope().getSourceType());
        TopBottomFilter topBottomfilter = this.primary.getFilter();
        Pair<String, AggregationType> aggregatedMeasure = this.getAggregatedMeasure(context, topBottomfilter.getByColumn());
        ColumnInfo categorical = context.getIndexedSM().getColumnInfo(this.primary.getId());
        Value distinctCountValue = StatisticsUtil.getStatisticValue((ColumnInfo)categorical, (StatisticType)StatisticType.DISTINCT_COUNT);
        int domainSize = Math.min(topBottomfilter.getDomainSize(), 3);
        if (distinctCountValue != null && topBottomfilter.getMethod() == TopBottomFilteringMethod.PERCENTAGE && (percentageDomainSize = topBottomfilter.getDomainSize() * distinctCountValue.intValue() / 100) > 0 && percentageDomainSize < 3) {
            domainSize = topBottomfilter.getDomainSize();
        }
        List<Pair<String, String>> dataValuePairs = util.getQueriedValuesFromFilters(context.getScope().getFilters(), aggregatedMeasure, this.primary.getId(), topBottomfilter, domainSize);
        List<InclusionExclusionFilter.DataValue> dataValues = this.makeDataValueFromPairs(dataValuePairs);
        ArrayList<InclusionExclusionFilter> iefs = new ArrayList<InclusionExclusionFilter>();
        for (InclusionExclusionFilter.DataValue dataValue : dataValues) {
            ArrayList<InclusionExclusionFilter.DataValue> values = new ArrayList<InclusionExclusionFilter.DataValue>();
            values.add(dataValue);
            try {
                InclusionExclusionFilter inclusionExclusionFilter = new InclusionExclusionFilter(this.primary.getId(), null, categorical.getPrettyName(), values, null, null, false);
                iefs.add(inclusionExclusionFilter);
            }
            catch (MissingFilterParametersException mfpe) {
                throw new ContentException(SmartsStatus.UNABLE_TO_GET_TOP_BOTTOM);
            }
        }
        return iefs;
    }

    private Pair<String, AggregationType> getAggregatedMeasure(ContentsContext context, String byColumn) {
        TopicScope primaryTopic;
        Pair<String, AggregationType> measureAggregation = null;
        if (context.getScope().getPrimaryTopic().isPresent() && (primaryTopic = context.getScope().getPrimaryTopic().get()).getId().equals(byColumn)) {
            measureAggregation = new Pair<String, AggregationType>(byColumn, primaryTopic.getAggregationType());
        }
        if (measureAggregation == null && !context.getScope().getSecondaryTopics().isEmpty()) {
            List<TopicScope> secondaryTopics = context.getScope().getSecondaryTopics();
            for (TopicScope secondaryTopic : secondaryTopics) {
                if (!secondaryTopic.getId().equals(byColumn)) continue;
                measureAggregation = new Pair<String, AggregationType>(byColumn, secondaryTopic.getAggregationType());
            }
        }
        ColumnInfo aggregatedMeasure = context.getIndexedSM().getColumnInfo(byColumn);
        if (measureAggregation == null && aggregatedMeasure != null) {
            measureAggregation = new Pair<String, AggregationType>(byColumn, aggregatedMeasure.getDefaultAggregation());
        }
        return measureAggregation;
    }

    private List<InclusionExclusionFilter.DataValue> makeDataValueFromPairs(List<Pair<String, String>> dataValuePairs) {
        ArrayList<InclusionExclusionFilter.DataValue> dataValueList = new ArrayList<InclusionExclusionFilter.DataValue>();
        for (Pair<String, String> dvp : dataValuePairs) {
            dataValueList.add(new InclusionExclusionFilter.DataValue(dvp.getLeft(), dvp.getRight()));
        }
        return dataValueList;
    }
}

