/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal.pipeline.prescribe;

import com.ibm.smarts.common.modifiers.FilterTypeConversionException;
import com.ibm.smarts.common.modifiers.InclusionExclusionFilter;
import com.ibm.smarts.content.recommender.api.ContentException;
import com.ibm.smarts.content.recommender.api.content.IRPrescription;
import com.ibm.smarts.content.recommender.api.content.IRPrescriptionItem;
import com.ibm.smarts.content.recommender.internal.SmartsStatus;
import com.ibm.smarts.content.recommender.internal.context.PrescribeContext;
import com.ibm.smarts.content.recommender.internal.pipeline.prescribe.IPrescribeStep;
import com.ibm.smarts.content.recommender.internal.util.CommonUtil;
import com.ibm.smarts.content.recommender.internal.util.QuickAccessSmartsModule;
import com.ibm.smarts.model.value.Value;
import com.ibm.smarts.prescriptive.recommender.api.GoalSpecifications;
import com.ibm.smarts.prescriptive.recommender.api.IPrescriptiveRecommender;
import com.ibm.smarts.prescriptive.recommender.api.Metric;
import com.ibm.smarts.prescriptive.recommender.api.MetricType;
import com.ibm.smarts.prescriptive.recommender.api.PerformanceMetricType;
import com.ibm.smarts.prescriptive.recommender.api.PrescriptionItem;
import com.ibm.smarts.prescriptive.recommender.api.PrescriptiveRecommenderFactory;
import com.ibm.smarts.prescriptive.recommender.api.TargetValueType;
import com.ibm.smarts.prescriptive.recommender.internal.PrescriptiveException;
import com.ibm.smarts.schema.ColumnInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class PrescriptionAnalysis
implements IPrescribeStep {
    private static final int TARGET_COLUMN_INDEX = 0;
    private static final int START_INFLUENCERS_INDEX = 1;
    private static final MetricType DEFAULT_METRIC_TYPE = MetricType.INCREASE;
    private static final PerformanceMetricType DEFAULT_PERFORMANCE_METRIC_TYPE = PerformanceMetricType.ACCURACY;
    private static final TargetValueType DEFAULT_TARGET_VALUE_TYPE = TargetValueType.PERCENT;
    private static final int DEFAULT_VALUE = 30;

    @Override
    public void accept(PrescribeContext context) {
        List prescriptions;
        List influencersIndexList = IntStream.range(1, context.getKeyDrivers().size()).boxed().collect(Collectors.toList());
        InclusionExclusionFilter filter = CommonUtil.getFocalFieldFilter(context.getPrescribeScope().getFilters());
        try {
            filter = context.getPrescribeScope().getFilters().get(0).toInclusionExclusionFilter();
        }
        catch (FilterTypeConversionException e2) {
            throw new ContentException(SmartsStatus.INAPPOPRIATE_FILTER_FOR_COMPARISON_ANALYSIS);
        }
        if (filter == null) {
            throw new ContentException(SmartsStatus.INAPPOPRIATE_FILTER_FOR_COMPARISON_ANALYSIS);
        }
        String filterColId = filter.getColumnId();
        String filterValue = (String)filter.getFilterCondition().getValues().get(0);
        if (filterColId == null || filterValue == null) {
            throw new ContentException(SmartsStatus.INAPPOPRIATE_FILTER_FOR_COMPARISON_ANALYSIS);
        }
        Optional<Map.Entry> entry = context.getRectangleOfData().getColumnInfoMap().entrySet().stream().filter(e -> ((ColumnInfo)e.getValue()).getIdForExpression().equals(filterColId)).findFirst();
        if (!entry.isPresent()) {
            throw new ContentException(SmartsStatus.MISSING_INDEXED_COLUMN_INFO);
        }
        int indexFound = (Integer)entry.get().getKey();
        Optional<List> r = context.getRectangleOfData().getValues().stream().filter(row -> ((Value)row.get(indexFound)).stringValue().contains(filterValue)).findFirst();
        if (!r.isPresent()) {
            throw new ContentException(SmartsStatus.MISSING_INDEXED_COLUMN_INFO);
        }
        List rowFound = r.get();
        GoalSpecifications goalSpec = null;
        goalSpec = context.getPrescribeScope().getGoalMetric() == null ? new GoalSpecifications(new Metric(DEFAULT_METRIC_TYPE, 30.0, DEFAULT_TARGET_VALUE_TYPE), DEFAULT_PERFORMANCE_METRIC_TYPE, rowFound) : new GoalSpecifications(new Metric(context.getPrescribeScope().getGoalMetric().getMetricType(), context.getPrescribeScope().getGoalMetric().getTargetValue(), context.getPrescribeScope().getGoalMetric().getTargetValueType()), DEFAULT_PERFORMANCE_METRIC_TYPE, rowFound);
        IPrescriptiveRecommender prescriptiveRec = PrescriptiveRecommenderFactory.getPrescriptiveRecommender();
        prescriptiveRec.fit(context.getRectangleOfData(), 0, influencersIndexList);
        try {
            prescriptions = prescriptiveRec.getPrescription(goalSpec);
        }
        catch (PrescriptiveException e3) {
            throw new ContentException(SmartsStatus.PRESCRIPTIVE_ERROR);
        }
        QuickAccessSmartsModule quick = new QuickAccessSmartsModule(context.getPrescribeScope().getSmartsModule());
        String prettyName = quick.getColumnInfo(context.getPrescribeScope().getTargetColumnId()).getPrettyName();
        prescriptions.forEach(p -> context.getPrescriptions().add(new IRPrescription(prettyName, this.createIRPrescriptionItems(p.getPrescriptionItem()), new Metric(DEFAULT_METRIC_TYPE, p.expectedResult().getTargetValue(), DEFAULT_TARGET_VALUE_TYPE), p.isGoalAchieved())));
    }

    private List<IRPrescriptionItem> createIRPrescriptionItems(List<PrescriptionItem> prescriptionItems) {
        ArrayList<IRPrescriptionItem> irItems = new ArrayList<IRPrescriptionItem>();
        for (PrescriptionItem prescriptionItem : prescriptionItems) {
            irItems.add(new IRPrescriptionItem(prescriptionItem.getColumnId(), prescriptionItem.getMetric()));
        }
        return irItems;
    }
}

