/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.incremental.IncrementalStages;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.saturation.ExtendedSaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.SaturationStatistics;
import org.semanticweb.elk.reasoner.saturation.conclusions.ConclusionStatistics;
import org.semanticweb.elk.reasoner.saturation.conclusions.ConclusionVisitor;
import org.semanticweb.elk.reasoner.saturation.conclusions.CountingConclusionVisitor;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;

abstract class AbstractIncrementalContextInitializationStage
extends AbstractReasonerStage {
    static final Logger LOGGER_ = Logger.getLogger(AbstractIncrementalContextInitializationStage.class);
    static final boolean COLLECT_CONCLUSION_COUNTS = LOGGER_.isDebugEnabled();
    protected final SaturationStatistics stageStatistics_ = new SaturationStatistics();
    protected int initContexts;
    protected int maxContexts;
    protected Iterator<IndexedClassExpression> todo = null;
    private ExtendedSaturationStateWriter writer_;

    public AbstractIncrementalContextInitializationStage(AbstractReasonerState reasoner, AbstractReasonerStage ... preStages) {
        super(reasoner, preStages);
    }

    @Override
    public String getName() {
        return this.stage().toString();
    }

    protected ConclusionVisitor<?> getConclusionVisitor(ConclusionStatistics conclusionStatistics) {
        return COLLECT_CONCLUSION_COUNTS ? new CountingConclusionVisitor(conclusionStatistics.getProducedConclusionCounts()) : ConclusionVisitor.DUMMY;
    }

    @Override
    public boolean preExecute() {
        if (!super.preExecute()) {
            return false;
        }
        ConclusionVisitor<?> visitor = this.getConclusionVisitor(this.stageStatistics_.getConclusionStatistics());
        this.writer_ = this.reasoner.saturationState.getExtendedWriter(visitor);
        return true;
    }

    @Override
    public void executeStage() throws ElkInterruptedException {
        while (true) {
            if (this.isInterrupted()) {
                return;
            }
            if (!this.todo.hasNext()) break;
            IndexedClassExpression ice = this.todo.next();
            if (ice.getContext() != null) {
                this.writer_.initContext(ice.getContext());
            }
            ++this.initContexts;
            this.progressMonitor.report(this.initContexts, this.maxContexts);
        }
    }

    @Override
    public boolean postExecute() {
        if (!super.postExecute()) {
            return false;
        }
        this.reasoner.ruleAndConclusionStats.add(this.stageStatistics_);
        return true;
    }

    @Override
    public boolean dispose() {
        if (!super.dispose()) {
            return false;
        }
        this.writer_ = null;
        return true;
    }

    @Override
    public void printInfo() {
        if (this.initContexts > 0 && LOGGER_.isDebugEnabled()) {
            LOGGER_.debug((Object)("Contexts init:" + this.initContexts));
        }
    }

    protected abstract IncrementalStages stage();
}

