/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.dashboard.generator.api;

import com.ibm.smarts.content.recommender.api.AnalysisScope;
import com.ibm.smarts.content.recommender.api.IContentRecommender;
import com.ibm.smarts.content.recommender.api.TopicScope;
import com.ibm.smarts.content.recommender.api.content.IRCombination;
import com.ibm.smarts.content.recommender.api.content.IRContent;
import com.ibm.smarts.content.recommender.internal.util.QuickAccessSmartsModule;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.dashboard.generator.internal.DashboardGeneratorContext;
import com.ibm.smarts.dashboard.generator.schema.core.ChartContent;
import com.ibm.smarts.dashboard.generator.schema.core.Container;
import com.ibm.smarts.dashboard.generator.schema.core.ContentGroup;
import com.ibm.smarts.ir.visualizer.IRVisualizerUtil;
import com.ibm.smarts.ir.visualizer.IRVisualizerUtilParams;
import com.ibm.smarts.schema.AggregationType;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.ColumnIdentifier;
import com.ibm.smarts.visualization.recommender.api.IVisualizationRecommender;
import com.ibm.smarts.visualization.recommender.api.VisualizationParameters;
import com.ibm.smarts.visualization.recommender.exceptions.RecommendationException;
import com.ibm.smarts.visualization.recommender.schema.IRecommendedVisualization;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashboardGenerator {
    private DashboardGeneratorContext context;
    private static final Logger LOGGER = LoggerFactory.getLogger(DashboardGenerator.class);
    private static final List<String> NOT_ALLOWED_IN_MAIN_GROUP = Arrays.asList("KPI", "Singleton");
    private static final int MIN_NUM_CHARTS = 1;

    public DashboardGenerator(DashboardGeneratorContext context) {
        this.context = context;
    }

    public List<Container> getAggregatedIrs() {
        AnalysisScope scopeCopy = new AnalysisScope(this.context.getAnalysisScope());
        List<IRContent> primaryIrs = this.executePrimaryPipeline(this.context.getContentRecommender(), this.context.getAnalysisScope(), this.context.getRequestContext());
        List<IRContent> secondaryIrs = this.executeSecondaryPipeline(this.context.getContentRecommender(), scopeCopy, this.context.getRequestContext());
        boolean predictFlag = secondaryIrs.isEmpty() && this.context.isIncludePredictChart();
        List<Container> primaryContainers = this.processIrsToContainers(primaryIrs, this.context.getSmartsModule(), this.context.getVisRecommender(), this.context.getRequestContext().productLocale, predictFlag, this.context.getIncludedCharts(), this.context.getExcludedCharts());
        List<Container> secondaryContainers = this.processIrsToContainers(secondaryIrs, this.context.getSmartsModule(), this.context.getVisRecommender(), this.context.getRequestContext().productLocale, predictFlag, this.context.getIncludedCharts(), this.context.getExcludedCharts());
        ArrayList<Container> aggregatedContainers = new ArrayList<Container>();
        aggregatedContainers.addAll(primaryContainers);
        aggregatedContainers.addAll(secondaryContainers);
        return aggregatedContainers;
    }

    private List<IRContent> executePrimaryPipeline(IContentRecommender contentRecommender, AnalysisScope scope, RequestContext requestContext) {
        return contentRecommender.recommendIRs(scope, requestContext);
    }

    private List<IRContent> executeSecondaryPipeline(IContentRecommender contentRecommender, AnalysisScope scope, RequestContext requestContext) {
        return contentRecommender.recommendInstanceIRs(scope, requestContext);
    }

    public List<Container> processIrsToContainers(List<IRContent> irs, SmartsModule sm, IVisualizationRecommender visRecommender, Locale locale, boolean predictFlag, List<String> includedCharts, List<String> excludedCharts) {
        if (irs.isEmpty()) {
            return Collections.emptyList();
        }
        QuickAccessSmartsModule indexedSm = new QuickAccessSmartsModule(sm);
        ArrayList<Container> containers = new ArrayList<Container>();
        for (IRContent ir : irs) {
            if (ir.getCombinations().size() <= 1) continue;
            ChartContent predictChart = null;
            if (predictFlag) {
                predictChart = this.findPredictChart(visRecommender, sm, ir, locale);
            }
            IRVisualizerUtilParams irVisParams = new IRVisualizerUtilParams(visRecommender, sm, ir, locale, this.getAggregationsFromScope(this.context));
            irVisParams.setIncludedChartTypes(includedCharts);
            irVisParams.setExcludedChartTypes(excludedCharts);
            Map combinationToChartMap = IRVisualizerUtil.generate((IRVisualizerUtilParams)irVisParams);
            if (combinationToChartMap.isEmpty()) continue;
            String containerTitle = this.createContainerTitle(ir, indexedSm);
            containers.add(this.createContainerForIr(containerTitle, ir, predictChart, combinationToChartMap));
        }
        return containers;
    }

    private Map<String, AggregationType> getAggregationsFromScope(DashboardGeneratorContext context) {
        HashMap<String, AggregationType> aggregationMap = new HashMap<String, AggregationType>();
        Optional primaryTopic = context.getAnalysisScope().getPrimaryTopic();
        if (primaryTopic.isPresent() && ((TopicScope)primaryTopic.get()).getAggregationTypeOverride() != null) {
            aggregationMap.put(((TopicScope)primaryTopic.get()).getId(), ((TopicScope)primaryTopic.get()).getAggregationTypeOverride());
        }
        List secondaryTopics = context.getAnalysisScope().getSecondaryTopics();
        for (TopicScope secondaryTopic : secondaryTopics) {
            if (secondaryTopic.getAggregationTypeOverride() == null) continue;
            aggregationMap.put(secondaryTopic.getId(), secondaryTopic.getAggregationTypeOverride());
        }
        return aggregationMap;
    }

    private ChartContent findPredictChart(IVisualizationRecommender visRecommender, SmartsModule sm, IRContent ir, Locale locale) {
        String columnId = ir.getTopicId();
        List predictRecommendations = new ArrayList();
        try {
            VisualizationParameters visParams = new VisualizationParameters();
            visParams.setPredictiveOnly(true);
            predictRecommendations = visRecommender.recommend(null, sm, locale, Arrays.asList(columnId), visParams);
        }
        catch (RecommendationException e) {
            LOGGER.error("Vis Recommender failed {}", (Object)e.getMessage());
        }
        if (predictRecommendations.isEmpty()) {
            return null;
        }
        return new ChartContent((IRecommendedVisualization)predictRecommendations.get(0));
    }

    private Container createContainerForIr(String containerTitle, IRContent ir, ChartContent predictChart, Map<IRCombination, IRecommendedVisualization> combinationsToRecommendations) {
        List<Object> chartsContent = new ArrayList();
        if (!combinationsToRecommendations.isEmpty()) {
            chartsContent = ir.getCombinations().stream().map(comb -> (IRecommendedVisualization)combinationsToRecommendations.get(comb)).filter(Objects::nonNull).map(chart -> new ChartContent(chart)).collect(Collectors.toList());
        }
        ArrayList<ContentGroup> groups = new ArrayList<ContentGroup>();
        ContentGroup mainGroup = new ContentGroup();
        ContentGroup secondaryGroup = new ContentGroup();
        boolean isContainerWithPredictive = false;
        if (predictChart != null) {
            mainGroup.addContent(predictChart);
            isContainerWithPredictive = true;
        }
        if (!chartsContent.isEmpty()) {
            boolean isMainGroupFull = false;
            for (ChartContent chartContent : chartsContent) {
                if (!isMainGroupFull && !NOT_ALLOWED_IN_MAIN_GROUP.contains(chartContent.getChart().getChartType())) {
                    mainGroup.addContent(chartContent);
                    isMainGroupFull = true;
                    continue;
                }
                secondaryGroup.addContent(chartContent);
            }
        }
        if (!mainGroup.getContents().isEmpty()) {
            groups.add(mainGroup);
            if (!secondaryGroup.getContents().isEmpty()) {
                groups.add(secondaryGroup);
            }
        }
        return new Container(containerTitle, null, groups, isContainerWithPredictive);
    }

    private String createContainerTitle(IRContent ir, QuickAccessSmartsModule indexedSm) {
        ColumnInfo ci;
        ColumnIdentifier colId = indexedSm.getColumnIdentifier(ir.getTopicId());
        String title = colId == null ? ir.getTopicId() : ((ci = colId.getColumnInfo()).getPrettyName() != null && !ci.getPrettyName().isEmpty() ? ci.getPrettyName() : ci.getName());
        return title;
    }
}

