/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.resource;

import com.ibm.smarts.core.exceptions.InternalException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ResourceHelper {
    public static InputStream streamFromResource(String path) {
        InputStream is = ResourceHelper.class.getResourceAsStream(path);
        if (is != null) {
            return is;
        }
        throw new RuntimeException("Resource does not exist: " + path);
    }

    public static Properties propsFromResource(String path) {
        Properties ret = new Properties();
        try (InputStream is = ResourceHelper.streamFromResource(path);){
            ret.load(is);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e, "Loading properties from resource " + path, new Object[0]);
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String stringFromResource(String path) {
        try (InputStream is = ResourceHelper.streamFromResource(path);){
            String string = ResourceHelper.stringFromStream(is, 8192);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not close resource stream at " + path, e);
        }
    }

    public static String stringFromStream(InputStream is, int bufSize) {
        byte[] buf = new byte[bufSize];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int count;
            while ((count = is.read(buf)) != -1) {
                baos.write(buf, 0, count);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load string from resource", e);
        }
        try {
            String ret = baos.toString("UTF-8");
            return ret;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Loading string from resource", e);
        }
    }

    public static List<String> stringsFromResource(String path) {
        return ResourceHelper.stringsFromResource(path, false);
    }

    public static List<String> stringsFromResource(String path, boolean trim) {
        String[] lines;
        ArrayList<String> ret = new ArrayList<String>();
        String string = ResourceHelper.stringFromResource(path);
        for (String line : lines = string.split("\n")) {
            if (trim) {
                line = line.trim();
            }
            ret.add(line);
        }
        return ret;
    }
}

