/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.util;

import com.ibm.smarts.core.async.AsyncMetrics;
import com.ibm.smarts.core.mq.QueueId;
import com.ibm.smarts.core.util.AbstractMetrics;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;

public class MessageQueueingMetrics
extends AbstractMetrics<MessageQueueingMetrics> {
    private final ConcurrentHashMap<String, ExchangeMetrics> exchangeMetrics;
    private final ExchangeMetrics overall;

    public MessageQueueingMetrics() {
        this(new ExchangeMetrics(null, null), new ConcurrentHashMap<String, ExchangeMetrics>());
    }

    private MessageQueueingMetrics(ExchangeMetrics overall, ConcurrentHashMap<String, ExchangeMetrics> exchangeMetrics) {
        this.overall = overall;
        this.exchangeMetrics = exchangeMetrics;
    }

    public ExchangeMetrics forExchange(QueueId queueId) {
        String exchangeName = queueId.exchangeId.toString();
        return this.forExchange(exchangeName);
    }

    private ExchangeMetrics forExchange(String exchangeName) {
        ExchangeMetrics ret = this.exchangeMetrics.computeIfAbsent(exchangeName, p -> new ExchangeMetrics(this.overall, (String)p));
        return ret;
    }

    @Override
    public boolean isTouched() {
        return MessageQueueingMetrics.isTouched(this.exchangeMetrics.values());
    }

    @Override
    public long firstTouchNanos() {
        return MessageQueueingMetrics.firstTouchNanos(this.exchangeMetrics.values());
    }

    @Override
    public long lastTouchNanos() {
        return MessageQueueingMetrics.lastTouchNanos(this.exchangeMetrics.values());
    }

    public MessageQueueingMetrics combine(MessageQueueingMetrics other) {
        ExchangeMetrics newOverall = this.overall.combine(null, other.overall);
        HashSet queueNames = new HashSet();
        queueNames.addAll(this.exchangeMetrics.keySet());
        queueNames.addAll(other.exchangeMetrics.keySet());
        ConcurrentHashMap<String, ExchangeMetrics> map = new ConcurrentHashMap<String, ExchangeMetrics>();
        for (String queueName : queueNames) {
            ExchangeMetrics thisMetrics = this.exchangeMetrics.get(queueName);
            ExchangeMetrics otherMetrics = other.exchangeMetrics.get(queueName);
            ExchangeMetrics qm = MessageQueueingMetrics.maybeCombine(newOverall, thisMetrics, otherMetrics);
            map.put(queueName, qm);
        }
        return new MessageQueueingMetrics(newOverall, map);
    }

    private static ExchangeMetrics maybeCombine(ExchangeMetrics overall, ExchangeMetrics left, ExchangeMetrics right) {
        if (left != null && right != null) {
            return left.combine(overall, right);
        }
        if (left == null) {
            return right.combine(overall, new ExchangeMetrics(overall, right.exchangeName));
        }
        return left.combine(overall, new ExchangeMetrics(overall, left.exchangeName));
    }

    @Override
    public String toString(boolean pretty, int indent) {
        String[] names;
        StringBuilder sb = new StringBuilder();
        sb.append("[MessageQueueingMetrics");
        for (String name : names = MessageQueueingMetrics.sortedStrings(this.exchangeMetrics.keySet())) {
            ExchangeMetrics pm = this.forExchange(name);
            sb.append(MessageQueueingMetrics.linePrefix(pretty, indent + 1) + pm.toString(pretty, indent + 2));
        }
        sb.append(MessageQueueingMetrics.linePrefix(pretty, indent + 1) + "overall: " + this.overall.toString(pretty, indent + 2));
        sb.append("]");
        String ret = sb.toString();
        return ret;
    }

    public static class QueueMetrics
    extends AbstractMetrics<QueueMetrics> {
        final QueueMetrics parent;
        public final String queueName;
        public final AsyncMetrics metrics;

        public QueueMetrics(QueueMetrics parent, String queueName) {
            this(parent, queueName, new AsyncMetrics(parent != null ? parent.metrics : null));
        }

        private QueueMetrics(QueueMetrics parent, String queueName, AsyncMetrics metrics) {
            this.parent = parent;
            this.queueName = queueName;
            this.metrics = metrics;
        }

        @Override
        public boolean isTouched() {
            return this.metrics.isTouched();
        }

        @Override
        public long firstTouchNanos() {
            return this.metrics.firstTouchNanos();
        }

        @Override
        public long lastTouchNanos() {
            return this.metrics.lastTouchNanos();
        }

        public QueueMetrics combine(QueueMetrics newParent, QueueMetrics other) {
            return new QueueMetrics(newParent, this.queueName, this.metrics.combine(newParent != null ? newParent.metrics : null, other.metrics));
        }

        @Override
        public String toString(boolean pretty, int indent) {
            StringBuilder sb = new StringBuilder();
            sb.append("[QueueMetrics");
            if (this.queueName != null) {
                sb.append(" name=" + this.queueName);
            }
            QueueMetrics.maybeAppend(pretty, indent, sb, this.metrics, "metrics");
            sb.append("]");
            String ret = sb.toString();
            return ret;
        }

        private static void maybeAppend(boolean pretty, int indent, StringBuilder sb, AsyncMetrics am, String name) {
            if (am.isTouched()) {
                sb.append(QueueMetrics.linePrefix(pretty, indent) + name + "=" + am.toString(pretty, indent + 1));
            }
        }
    }

    public static class ExchangeMetrics
    extends AbstractMetrics<ExchangeMetrics> {
        final ExchangeMetrics parent;
        public final String exchangeName;
        public final QueueMetrics metrics;
        private final ConcurrentHashMap<String, QueueMetrics> queueMetrics;

        public ExchangeMetrics(ExchangeMetrics parent, String exchangeName) {
            this(parent, exchangeName, new QueueMetrics(parent != null ? parent.metrics : null, null), new ConcurrentHashMap<String, QueueMetrics>());
        }

        private ExchangeMetrics(ExchangeMetrics parent, String exchangeName, QueueMetrics overall, ConcurrentHashMap<String, QueueMetrics> queueMetrics) {
            this.parent = parent;
            this.exchangeName = exchangeName;
            this.metrics = overall;
            this.queueMetrics = queueMetrics;
        }

        public QueueMetrics forQueue(QueueId queueId) {
            String queueName = queueId.toString();
            return this.forQueue(queueName);
        }

        private QueueMetrics forQueue(String queueName) {
            QueueMetrics ret = this.queueMetrics.computeIfAbsent(queueName, p -> new QueueMetrics(this.metrics, (String)p));
            return ret;
        }

        @Override
        public boolean isTouched() {
            return ExchangeMetrics.isTouched(this.queueMetrics.values());
        }

        @Override
        public long firstTouchNanos() {
            return ExchangeMetrics.firstTouchNanos(this.queueMetrics.values());
        }

        @Override
        public long lastTouchNanos() {
            return ExchangeMetrics.lastTouchNanos(this.queueMetrics.values());
        }

        public ExchangeMetrics combine(ExchangeMetrics newParent, ExchangeMetrics other) {
            QueueMetrics newOverall = this.metrics.combine(null, other.metrics);
            HashSet queueNames = new HashSet();
            queueNames.addAll(this.queueMetrics.keySet());
            queueNames.addAll(other.queueMetrics.keySet());
            ConcurrentHashMap<String, QueueMetrics> map = new ConcurrentHashMap<String, QueueMetrics>();
            for (String queueName : queueNames) {
                QueueMetrics thisMetrics = this.queueMetrics.get(queueName);
                QueueMetrics otherMetrics = other.queueMetrics.get(queueName);
                QueueMetrics qm = ExchangeMetrics.maybeCombine(newOverall, thisMetrics, otherMetrics);
                map.put(queueName, qm);
            }
            return new ExchangeMetrics(newParent, this.exchangeName, newOverall, map);
        }

        private static QueueMetrics maybeCombine(QueueMetrics overall, QueueMetrics left, QueueMetrics right) {
            if (left != null && right != null) {
                return left.combine(overall, right);
            }
            if (left == null) {
                return right.combine(overall, new QueueMetrics(overall, right.queueName));
            }
            return left.combine(overall, new QueueMetrics(overall, left.queueName));
        }

        @Override
        public String toString(boolean pretty, int indent) {
            StringBuilder sb = new StringBuilder();
            sb.append("[ExchangeMetrics");
            if (this.exchangeName != null) {
                sb.append(" exchangeName=" + this.exchangeName);
            }
            sb.append(ExchangeMetrics.linePrefix(pretty, indent) + "exchangeMetrics=" + this.metrics.toString(pretty, indent + 1));
            if (this.queueMetrics.size() > 0) {
                String[] names;
                for (String name : names = ExchangeMetrics.sortedStrings(this.queueMetrics.keySet())) {
                    sb.append(ExchangeMetrics.linePrefix(pretty, indent) + this.queueMetrics.get(name).toString(pretty, indent + 1));
                }
            }
            sb.append("]");
            String ret = sb.toString();
            return ret;
        }
    }
}

