/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.DefaultAdditionalInfoHandler;
import com.cognos.accman.jcam.crypto.SystemProtectionSession;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.IPFTraceLogger;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.res.MessageSet;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Date;

public class DSServiceAccessSession
extends DefaultAdditionalInfoHandler {
    static IPFTraceLogger dsserviceTraceLogger = new IPFTraceLogger("Trace.CAM.JCAM.DSService");
    public static final byte VERSION1 = 1;
    public static final byte VERSION2 = 2;
    private static final int SALT_LENGTH = 8;
    private SystemProtectionSession sps = null;
    private SecureRandom random = null;
    private MessageDigest md1 = null;
    private byte version = (byte)2;

    public DSServiceAccessSession() throws CAMCryptoException {
        dsserviceTraceLogger.logEnter();
        this.sps = new SystemProtectionSession();
        this.random = JVMEnvironment.getInstance().getSecureRandom();
        Configuration config = Configuration.getInstance();
        String shaAlg = config.getSHAAlgorithm();
        this.md1 = CAMCryptoUtilities.getMessageDigest(shaAlg);
        dsserviceTraceLogger.logExit(true);
    }

    public byte[] getToken(byte[] password) throws CAMCryptoException {
        byte[] token;
        dsserviceTraceLogger.logEnter();
        if (password == null || password.length == 0) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_DSServiceAccessSession_no_password"));
        }
        byte[] decodedPassword = CryptoWrapper.decodeBase64(password);
        byte[] workingPassword = this.sps.decryptData(decodedPassword);
        if (this.version == 1) {
            token = this.createToken1(workingPassword);
        } else if (this.version == 2) {
            token = this.createToken2(workingPassword);
        } else {
            CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_DSServiceAccessSession_no_password"));
            dsserviceTraceLogger.logExit(cce);
            throw cce;
        }
        dsserviceTraceLogger.logExit(true);
        return CryptoWrapper.encodeBase64(token);
    }

    private byte[] createToken1(byte[] workingPassword) {
        dsserviceTraceLogger.logEnter();
        Date now = new Date();
        long lNow = now.getTime();
        byte[] byteTime = CryptoWrapper.toByteArray(lNow /= 1000L, 0);
        int timelen = byteTime.length;
        byte[] byteTimeLen = CryptoWrapper.toByteArray(timelen);
        byte[] salt = new byte[8];
        this.random.nextBytes(salt);
        int saltlen = salt.length;
        byte[] byteSaltLen = CryptoWrapper.toByteArray(saltlen);
        dsserviceTraceLogger.trace("DSServiceAccessSession:createToken1 - create version 1 token using algorithm: " + this.md1.getAlgorithm());
        this.md1.reset();
        this.md1.update(this.version);
        this.md1.update(byteTime);
        this.md1.update(salt);
        this.md1.update(workingPassword);
        byte[] tmpDigest = this.md1.digest();
        this.md1.update(workingPassword);
        this.md1.update(tmpDigest);
        byte[] mac = this.md1.digest();
        int maclen = mac.length;
        byte[] byteMacLen = CryptoWrapper.toByteArray(maclen);
        int tokenlen = 5 + timelen + 4 + saltlen + 4 + maclen;
        int pos = 0;
        byte[] token = new byte[tokenlen];
        token[0] = (byte)(this.version & 0xFF);
        System.arraycopy(byteTimeLen, 0, token, ++pos, byteTimeLen.length);
        System.arraycopy(byteTime, 0, token, pos += byteTimeLen.length, timelen);
        System.arraycopy(byteSaltLen, 0, token, pos += timelen, byteSaltLen.length);
        System.arraycopy(salt, 0, token, pos += byteSaltLen.length, saltlen);
        System.arraycopy(byteMacLen, 0, token, pos += saltlen, byteMacLen.length);
        System.arraycopy(mac, 0, token, pos += byteMacLen.length, maclen);
        pos += maclen;
        dsserviceTraceLogger.logExit(true);
        return token;
    }

    private byte[] createToken2(byte[] workingPassword) throws CAMCryptoException {
        dsserviceTraceLogger.logEnter();
        MessageDigest md = null;
        Configuration config = Configuration.getInstance();
        String alg = config.getDigestAlgorithm();
        int alglen = alg.length();
        md = CAMCryptoUtilities.getMessageDigest(alg);
        Date now = new Date();
        long lNow = now.getTime();
        byte[] byteTime = CryptoWrapper.toByteArray(lNow /= 1000L, 0);
        int timelen = byteTime.length;
        byte[] byteTimeLen = CryptoWrapper.toByteArray(timelen);
        byte[] salt = new byte[8];
        this.random.nextBytes(salt);
        int saltlen = salt.length;
        dsserviceTraceLogger.trace("DSServiceAccessSession:createToken1 - create version 2 token using algorithm: " + alg);
        md.reset();
        md.update(this.version);
        md.update(byteTime);
        md.update(salt);
        md.update(workingPassword);
        byte[] tmpDigest = md.digest();
        md.update(workingPassword);
        md.update(tmpDigest);
        byte[] mac = md.digest();
        int maclen = mac.length;
        int tokenlen = 5 + timelen + 4 + saltlen + 4 + maclen + 4 + alglen;
        int pos = 1;
        byte[] token = new byte[tokenlen];
        token[0] = (byte)(this.version & 0xFF);
        pos += CAMCryptoUtilities.addTokenField(token, pos, byteTime);
        pos += CAMCryptoUtilities.addTokenField(token, pos, salt);
        pos += CAMCryptoUtilities.addTokenField(token, pos, mac);
        pos += CAMCryptoUtilities.addTokenField(token, pos, alg.getBytes());
        dsserviceTraceLogger.logExit(true);
        return token;
    }

    public boolean verifyToken(byte[] password, byte[] token) throws CAMCryptoException {
        dsserviceTraceLogger.logEnter();
        dsserviceTraceLogger.trace("token = " + new String(token));
        if (token == null || token.length == 0) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_DSServiceAccessSession_no_token"));
        }
        if (password == null || password.length == 0) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_DSServiceAccessSession_no_password"));
        }
        byte[] decodedPassword = CryptoWrapper.decodeBase64(password);
        byte[] workingPassword = this.sps.decryptData(decodedPassword);
        byte[] decodedToken = CryptoWrapper.decodeBase64(token);
        boolean bFlag = false;
        byte reqVersion = decodedToken[0];
        if (reqVersion == 1) {
            bFlag = this.verifyToken1(workingPassword, decodedToken);
        } else if (reqVersion == 2) {
            bFlag = this.verifyToken2(workingPassword, decodedToken);
        } else {
            CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_DSServiceAccessSession_invalid_version"));
            dsserviceTraceLogger.logExit(cce);
            throw cce;
        }
        dsserviceTraceLogger.logExit(bFlag);
        return bFlag;
    }

    private boolean verifyToken1(byte[] workingPassword, byte[] decodedToken) throws CAMCryptoException {
        dsserviceTraceLogger.logEnter();
        int pos = 0;
        byte reqVersion = decodedToken[0];
        byte[] byteTimeLen = new byte[4];
        System.arraycopy(decodedToken, ++pos, byteTimeLen, 0, 4);
        int timelen = CryptoWrapper.toInt(byteTimeLen, 0, 4);
        byte[] byteTime = new byte[timelen];
        System.arraycopy(decodedToken, pos += 4, byteTime, 0, timelen);
        long time = CryptoWrapper.toLong(byteTime);
        byte[] byteSaltLen = new byte[4];
        System.arraycopy(decodedToken, pos += timelen, byteSaltLen, 0, 4);
        int saltlen = CryptoWrapper.toInt(byteSaltLen, 0, 4);
        byte[] byteSalt = new byte[saltlen];
        System.arraycopy(decodedToken, pos += 4, byteSalt, 0, saltlen);
        byte[] byteMacLen = new byte[4];
        System.arraycopy(decodedToken, pos += saltlen, byteMacLen, 0, 4);
        int maclen = CryptoWrapper.toInt(byteMacLen, 0, 4);
        byte[] byteDigest = new byte[maclen];
        System.arraycopy(decodedToken, pos += 4, byteDigest, 0, maclen);
        pos += maclen;
        dsserviceTraceLogger.trace("DSServiceAccessSession:verifyToken1 - verify version 1 token using algorithm: " + this.md1.getAlgorithm());
        this.md1.reset();
        this.md1.update(reqVersion);
        this.md1.update(byteTime);
        this.md1.update(byteSalt);
        this.md1.update(workingPassword);
        byte[] tmpDigest = this.md1.digest();
        this.md1.update(workingPassword);
        this.md1.update(tmpDigest);
        byte[] mac = this.md1.digest();
        boolean bFlag = false;
        if (MessageDigest.isEqual(mac, byteDigest)) {
            bFlag = true;
        }
        dsserviceTraceLogger.logExit(bFlag);
        return bFlag;
    }

    private boolean verifyToken2(byte[] workingPassword, byte[] decodedToken) throws CAMCryptoException {
        dsserviceTraceLogger.logEnter();
        int sizeFieldLength = 4;
        int pos = 1;
        byte reqVersion = decodedToken[0];
        byte[] byteTime = CAMCryptoUtilities.getTokenField(decodedToken, pos);
        long time = CryptoWrapper.toLong(byteTime);
        byte[] byteSalt = CAMCryptoUtilities.getTokenField(decodedToken, pos += sizeFieldLength + byteTime.length);
        byte[] byteDigest = CAMCryptoUtilities.getTokenField(decodedToken, pos += sizeFieldLength + byteSalt.length);
        byte[] byteAlgorithm = CAMCryptoUtilities.getTokenField(decodedToken, pos += sizeFieldLength + byteDigest.length);
        pos += sizeFieldLength + byteAlgorithm.length;
        String alg = new String(byteAlgorithm);
        dsserviceTraceLogger.trace("DSServiceAccessSession:verifyToken2 - verify version 2 token using algorithm: " + alg);
        MessageDigest md = CAMCryptoUtilities.getMessageDigest(alg);
        md.reset();
        md.update(reqVersion);
        md.update(byteTime);
        md.update(byteSalt);
        md.update(workingPassword);
        byte[] tmpDigest = md.digest();
        md.update(workingPassword);
        md.update(tmpDigest);
        byte[] mac = md.digest();
        boolean bFlag = false;
        if (MessageDigest.isEqual(mac, byteDigest)) {
            bFlag = true;
        }
        dsserviceTraceLogger.logExit(bFlag);
        return bFlag;
    }

    boolean verifyToken(byte[] token) throws CAMCryptoException {
        return false;
    }

    public void setVersion(byte v) {
        this.version = v;
    }
}

