/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.autoca.XmlCaRequest;
import com.cognos.accman.autoca.client.CaClient;
import com.cognos.accman.autoca.client.CaClientException;
import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMCryptoServerException;
import com.cognos.accman.jcam.crypto.casync.CaFreshnessHandler;
import com.cognos.accman.jcam.crypto.casync.CaSyncHandler;
import com.cognos.accman.jcam.crypto.jni.JNIFileLock;
import com.cognos.accman.jcam.crypto.jni.JNISystemProperties;
import com.cognos.accman.jcam.crypto.misc.CAMCSKKeyStore;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.CAMKeyStore;
import com.cognos.accman.jcam.crypto.misc.CMStoreWrapper;
import com.cognos.accman.jcam.crypto.misc.CMStoreWrapperException;
import com.cognos.accman.jcam.crypto.misc.CSKDigest;
import com.cognos.accman.jcam.crypto.misc.CSKToCMSyncher;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapperException;
import com.cognos.accman.jcam.crypto.misc.EncodedCSK;
import com.cognos.accman.jcam.crypto.misc.EncodedCSKRequest;
import com.cognos.accman.jcam.crypto.misc.HttpClientInitializer;
import com.cognos.accman.jcam.crypto.misc.IPFTraceLogger;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.jcam.crypto.misc.KeyExpiryChecker;
import com.cognos.accman.jcam.crypto.misc.KeyStoreManager;
import com.cognos.accman.jcam.crypto.misc.KeyStoreReader;
import com.cognos.accman.jcam.crypto.misc.KeysAlreadyExistException;
import com.cognos.accman.jcam.crypto.misc.PemGenerator;
import com.cognos.accman.jcam.crypto.misc.PriorityUrlList;
import com.cognos.accman.jcam.crypto.misc.SANExtAttributes;
import com.cognos.accman.jcam.crypto.pkcs.PKCS7SignedData;
import com.cognos.accman.res.MessageSet;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URL;
import java.nio.channels.FileLock;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpRecoverableException;
import org.apache.commons.httpclient.methods.PostMethod;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;

public class KeyStoreWriter {
    private static final int GET_REMOTE_CSK_TIMEOUT = 60000;
    private static KeyStoreManager ksMgr = KeyStoreManager.getInstance();
    private static boolean syncCompleted = false;
    private static boolean keyFormatUpgradeCompleted = false;
    private static final byte PKCS1_WITH_IPADDR = 4;
    private static final byte PKCS1_WITH_IPADDR_DIGEST = 5;
    public static final String CSK_REQ_HEAD = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\">\n<SOAP-ENV:Header>\n<bus:biBusHeader xsi:type=\"bus:biBusHeader\">\n<CAM xsi:nil=\"true\"/>\n<CAMProtect xsi:type=\"bus:CAMProtect\">\n<trustedValue xsi:type=\"xsd:base64Binary\">";
    public static final String CSK_REQ_TAIL = "</trustedValue >\n<serviceId xsi:type=\"xsd:string\">CAMconfig</serviceId>\n</CAMProtect>\n</bus:biBusHeader>\n</SOAP-ENV:Header>\n<SOAP-ENV:Body>\n<cm:query xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\">\n<search xsi:type=\"xsd:string\">/directory</search>\n<properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[1]\">\n<item xsi:type=\"cm:propEnum\">commonSymmetricKey</item>\n</properties>\n</cm:query>\n</SOAP-ENV:Body>\n</SOAP-ENV:Envelope>\n";
    static IPFTraceLogger cskTraceLogger = new IPFTraceLogger("Trace.CAM.JCAM.KeyManagement.CSK");
    static IPFTraceLogger pkiTraceLogger = new IPFTraceLogger("Trace.CAM.JCAM.KeyManagement.PKI");
    static IPFTraceLogger caTraceLogger = new IPFTraceLogger("Trace.CAM.JCAM.KeyManagement.CA");

    public static void createCSK() throws CAMCryptoException {
        boolean alreadyExists;
        cskTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        try {
            alreadyExists = ksMgr.getCSKKeystore().containsAlias(config.getCSKAlias());
        }
        catch (CAMCryptoException e) {
            cskTraceLogger.logExit(e);
            throw e;
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{config.getCSKLocation()}));
            cskTraceLogger.logExit(cce);
            throw cce;
        }
        if (alreadyExists) {
            cskTraceLogger.trace("CSK already exists");
            if (config.getWeAreCM() || config.isStandaloneCA()) {
                throw new KeysAlreadyExistException(MessageSet.getMessage("CAM_CRP_csk_already_created"));
            }
            KeyStoreWriter.requestAndStoreRemoteCSK(null);
        } else if (config.getWeAreCM() || config.isStandaloneCA()) {
            try {
                cskTraceLogger.trace("CM install, request and store remote CSK");
                KeyStoreWriter.requestAndStoreRemoteCSK(null);
            }
            catch (Exception e) {
                cskTraceLogger.trace("Not able to get remote CSK, create new CSK");
                KeyStoreWriter.createNewCSK();
            }
        } else {
            cskTraceLogger.trace("Not a CM install, request and store remote CSK");
            KeyStoreWriter.requestAndStoreRemoteCSK(null);
        }
        cskTraceLogger.logExit(true);
    }

    public static void createCAKeyPair() throws CAMCryptoException {
        pkiTraceLogger.logEnter();
        X509Certificate caCert = KeyStoreWriter.createCAKeyPair(false);
        if (caCert != null) {
            CaSyncHandler cash = CaSyncHandler.getInstance();
            cash.addCertToCS(caCert);
        }
        pkiTraceLogger.logExit(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateCSK() throws CAMCryptoException {
        cskTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        Object object = KeyExpiryChecker.csklock;
        synchronized (object) {
            if (config.getWeAreCM()) {
                if (KeyExpiryChecker.hasCSKExpired()) {
                    cskTraceLogger.trace("CM install, create new CSK");
                    KeyStoreWriter.createNewCSK();
                }
            } else {
                cskTraceLogger.trace("Request and store remote CSK");
                KeyStoreWriter.requestAndStoreRemoteCSK(null);
            }
        }
        cskTraceLogger.logExit(true);
    }

    public static void updateSigningKeyPair() throws CAMCryptoException {
        pkiTraceLogger.logEnter();
        KeyStoreWriter.createKeyPairAndAddToKeystore("encryption");
        pkiTraceLogger.logExit(true);
    }

    public static void updateEncryptionKeyPair() throws CAMCryptoException {
        pkiTraceLogger.logEnter();
        KeyStoreWriter.createKeyPairAndAddToKeystore("encryption");
        pkiTraceLogger.logExit(true);
    }

    public static void updateCAKeyPair() throws CAMCryptoException {
        caTraceLogger.logEnter();
        X509Certificate caCert = KeyStoreWriter.createCAKeyPair(true);
        if (caCert != null) {
            CaSyncHandler cash = CaSyncHandler.getInstance();
            cash.addCertToCS(caCert);
        }
        caTraceLogger.logExit(true);
    }

    public static void expireEncryptKeyPair() throws CAMCryptoException {
        pkiTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        CAMKeyStore store = ksMgr.getCAKeystore("encryption");
        try {
            store.lock();
            store.loadKeyStore();
            if (store.getPrivateKey("encryption") != null) {
                store.expireKeyPair("encryption");
                store.saveKeyStore();
            }
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_save_keystore_error", new String[]{config.getCAMKeystoreLocation()}));
            pkiTraceLogger.logExit(cce);
            throw cce;
        }
        finally {
            store.unlock();
        }
        pkiTraceLogger.logExit(true);
    }

    public static void expireSignKeyPair() throws CAMCryptoException {
        pkiTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        CAMKeyStore store = ksMgr.getCAKeystore("encryption");
        try {
            store.lock();
            store.loadKeyStore();
            if (store.getPrivateKey("encryption") != null) {
                store.expireKeyPair("encryption");
                store.saveKeyStore();
            }
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_save_keystore_error", new String[]{config.getCAMKeystoreLocation()}));
            pkiTraceLogger.logExit(cce);
            throw cce;
        }
        finally {
            store.unlock();
        }
        pkiTraceLogger.logExit(true);
    }

    public static void expireCAKeyPair() throws CAMCryptoException {
        caTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        CAMKeyStore store = ksMgr.getCAKeystore("ca");
        try {
            store.lock();
            store.loadKeyStore();
            if (store.getPrivateKey("ca") != null) {
                store.expireKeyPair("ca");
                store.saveKeyStore();
            }
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_save_keystore_error", new String[]{config.getCAMKeystoreLocation()}));
            caTraceLogger.logExit(cce);
            throw cce;
        }
        finally {
            store.unlock();
        }
        caTraceLogger.logExit(true);
    }

    public static void expireCsk() throws CAMCryptoException {
        cskTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        try {
            if (ksMgr.getCSKKeystore().containsAlias(config.getCSKAlias())) {
                SecretKey existingCSK = (SecretKey)ksMgr.getCSKKeystore().getKey(config.getCSKAlias(), config.getCSKPassword().toCharArray());
                if (existingCSK != null) {
                    byte[] cskDigest = CAMCryptoUtilities.digestCSK(existingCSK);
                    String backedUpCSKAlias = new String(CryptoWrapper.encodeBase64(cskDigest)).toLowerCase();
                    ksMgr.getCSKKeystore().setKeyEntry(backedUpCSKAlias, existingCSK, config.getCSKPassword().toCharArray(), null);
                }
                ksMgr.getCSKKeystore().deleteEntry(config.getCSKAlias());
            }
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_save_keystore_error", new String[]{config.getCSKLocation()}));
            cskTraceLogger.logExit(cce);
            throw cce;
        }
        cskTraceLogger.logExit(true);
    }

    public static void createNewCSK() throws CAMCryptoException {
        cskTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        try {
            String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
            KeyGenerator kg = KeyGenerator.getInstance(config.getCSKAlgorithm(), jceProvider);
            kg.init(config.getCSKSize());
            SecretKey csk = kg.generateKey();
            if (csk == null || csk.toString().length() == 0) {
                cskTraceLogger.trace("Empty CSK is created !!! with algorithm = " + config.getCSKAlgorithm() + " of jceProvider = " + jceProvider);
            }
            KeyStoreWriter.storeLatestCSK(csk);
            if (config.getWeAreCM()) {
                KeyStoreWriter.syncCSKKeystoreWithCM();
            }
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_could_not_create_csk", new String[]{config.getCSKLocation()}));
            cskTraceLogger.logExit(cce);
            throw cce;
        }
        cskTraceLogger.logExit(true);
    }

    private static void storeLatestCSK(SecretKey csk) throws CAMCryptoException {
        cskTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        try {
            if (ksMgr.getCSKKeystore().containsAlias(config.getCSKAlias())) {
                SecretKey existingCSK = (SecretKey)ksMgr.getCSKKeystore().getKey(config.getCSKAlias(), config.getCSKPassword().toCharArray());
                if (existingCSK != null) {
                    byte[] cskDigest = CAMCryptoUtilities.digestCSK(existingCSK);
                    String backedUpCSKAlias = new String(CryptoWrapper.encodeBase64(cskDigest)).toLowerCase();
                    ksMgr.getCSKKeystore().setKeyEntry(backedUpCSKAlias, existingCSK, config.getCSKPassword().toCharArray(), null);
                }
                ksMgr.getCSKKeystore().deleteEntry(config.getCSKAlias());
            }
            ksMgr.getCSKKeystore().setKeyEntry(config.getCSKAlias(), csk, config.getCSKPassword().toCharArray(), null);
            CSKDigest.getInstance().setCSKUpdateRequired();
            if (!config.getCacheCSKLocally()) {
                cskTraceLogger.logExit();
                return;
            }
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_save_keystore_error", new String[]{config.getCSKLocation()}));
            cskTraceLogger.logExit(cce);
            throw cce;
        }
        KeyStoreWriter.writeCSKKeystoresToDisk();
        cskTraceLogger.logExit(true);
    }

    private static void storeOldCSK(SecretKey csk) throws CAMCryptoException {
        cskTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        byte[] cskDigest = CAMCryptoUtilities.digestCSK(csk);
        String CSKAlias = new String(CryptoWrapper.encodeBase64(cskDigest)).toLowerCase();
        try {
            ksMgr.getCSKKeystore().setKeyEntry(CSKAlias, csk, config.getCSKPassword().toCharArray(), null);
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_save_keystore_error", new String[]{config.getCSKLocation()}));
            cskTraceLogger.logExit(cce);
            throw cce;
        }
        if (!config.getCacheCSKLocally()) {
            cskTraceLogger.logExit();
            return;
        }
        KeyStoreWriter.writeCSKKeystoresToDisk();
        cskTraceLogger.logExit(true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void writeCSKKeystoresToDisk() throws CAMCryptoException {
        FileOutputStream bksFos;
        block15: {
            cskTraceLogger.logEnter();
            Configuration config = Configuration.getInstance();
            String jceksFilename = config.getCSKLocation();
            String bksFilename = jceksFilename + ".bks";
            String ksLockFilename = jceksFilename + ".lock";
            JNIFileLock ksFileLock = null;
            bksFos = null;
            try {
                StringBuffer sb = new StringBuffer();
                ksFileLock = JNISystemProperties.lockFile((String)ksLockFilename, (StringBuffer)sb);
                File fileObj = new File(bksFilename).getParentFile();
                fileObj.mkdir();
                bksFos = new FileOutputStream(bksFilename);
                ksMgr.getCSKKeystore().store(bksFos, config.getCSKPassword().toCharArray());
                KeyStoreWriter.chtagKeyStoreBinaryOnzOS(new File(bksFilename));
                FileOutputStream fos = new FileOutputStream(new File(config.getCSKLocationForCPP()));
                FileLock fileLock = fos.getChannel().lock();
                SecretKey currentCSK = KeyStoreReader.getCSKFromKeystoreOrRemoteServer();
                Date date = ksMgr.getCSKKeystore().getCreationDate(config.getCSKAlias());
                if (JVMEnvironment.getInstance().isFIPSEnabled()) {
                    KeyStoreWriter.writeEncryptedCSKToFile_FIPS(fos, currentCSK, date);
                } else {
                    KeyStoreWriter.writeEncryptedCSKToFile(fos, currentCSK, date);
                }
                Enumeration<String> aliases = ksMgr.getCSKKeystore().aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    SecretKey ksCSK = (SecretKey)ksMgr.getCSKKeystore().getKey(alias, config.getCSKPassword().toCharArray());
                    date = ksMgr.getCSKKeystore().getCreationDate(alias);
                    boolean sameKey = Arrays.equals(ksCSK.getEncoded(), currentCSK.getEncoded());
                    if (sameKey) continue;
                    if (JVMEnvironment.getInstance().isFIPSEnabled()) {
                        KeyStoreWriter.writeEncryptedCSKToFile_FIPS(fos, ksCSK, date);
                        continue;
                    }
                    KeyStoreWriter.writeEncryptedCSKToFile(fos, ksCSK, date);
                }
                fos.close();
                KeyStoreWriter.chtagKeyStoreBinaryOnzOS(new File(config.getCSKLocationForCPP()));
                if (ksFileLock == null) break block15;
            }
            catch (CAMCryptoException e) {
                try {
                    cskTraceLogger.logExit(e);
                    throw e;
                    catch (Exception e2) {
                        CAMCryptoException cce = new CAMCryptoException(e2, MessageSet.getMessage("CAM_CRP_save_keystore_error", new String[]{config.getCSKLocation()}));
                        cskTraceLogger.logExit(cce);
                        throw cce;
                    }
                }
                catch (Throwable throwable) {
                    if (ksFileLock != null) {
                        JNISystemProperties.unlockFile(ksFileLock);
                    }
                    if (bksFos == null) throw throwable;
                    try {
                        bksFos.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            JNISystemProperties.unlockFile((JNIFileLock)ksFileLock);
        }
        if (bksFos != null) {
            try {
                bksFos.close();
            }
            catch (IOException sb) {}
        }
        cskTraceLogger.logExit(true);
    }

    protected static void writeEncryptedCSKToFile(FileOutputStream fos, SecretKey csk, Date creationDate) throws CAMCryptoException {
        cskTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        try {
            String pwd = config.getCSKPassword();
            SecureRandom random = JVMEnvironment.getInstance().getSecureRandom();
            byte[] salt = new byte[24];
            random.nextBytes(salt);
            PKCS5S2ParametersGenerator generator = new PKCS5S2ParametersGenerator();
            generator.init(pwd.getBytes(), salt, 100);
            ParametersWithIV cpiv = (ParametersWithIV)generator.generateDerivedParameters(192, 64);
            KeyParameter key = (KeyParameter)cpiv.getParameters();
            byte[] keyMaster = key.getKey();
            DESedeKeySpec ks = new DESedeKeySpec(keyMaster);
            String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
            SecretKeyFactory skf = SecretKeyFactory.getInstance("TripleDES", jceProvider);
            SecretKey desEdeKey = skf.generateSecret(ks);
            byte[] iv = cpiv.getIV();
            IvParameterSpec ivParam = new IvParameterSpec(iv);
            EncodedCSK encodedCsk = new EncodedCSK(creationDate, csk);
            byte[] cskBytes = encodedCsk.getEncoded();
            byte[] out = new byte[cskBytes.length + 8];
            Cipher encryptCipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            encryptCipher.init(1, (Key)desEdeKey, ivParam, random);
            int outLen = encryptCipher.doFinal(cskBytes, 0, cskBytes.length, out, 0);
            byte[] encCsk = new byte[outLen];
            System.arraycopy(out, 0, encCsk, 0, outLen);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(salt);
            baos.write(encCsk);
            baos.close();
            byte[] b64data = CryptoWrapper.encodeBase64(baos.toByteArray());
            fos.write("-----BEGIN CSK V3.0-----\n".getBytes());
            fos.write(b64data);
            fos.write("\n".getBytes());
            fos.write("-----END CSK V3.0-----\n".getBytes());
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_cpp_csk_store_save_error", new String[]{config.getCSKLocationForCPP()}));
        }
    }

    protected static void writeEncryptedCSKToFile_FIPS(FileOutputStream fos, SecretKey csk, Date creationDate) throws CAMCryptoException {
        Configuration config = Configuration.getInstance();
        try {
            String pwd = config.getCSKPassword();
            String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
            SecretKey aesKey = CAMCSKKeyStore.getSecertKeyfromString(pwd, "AES", jceProvider);
            byte[] cskBytes = null;
            EncodedCSK encodedCsk = new EncodedCSK(creationDate, csk);
            cskBytes = encodedCsk.getEncoded();
            SecureRandom random = JVMEnvironment.getInstance().getSecureRandom();
            byte[] salt = new byte[24];
            random.nextBytes(salt);
            byte[] out = new byte[cskBytes.length + 16];
            Cipher cipher = Cipher.getInstance("AES", jceProvider);
            cipher.init(1, aesKey);
            int outLen = cipher.doFinal(cskBytes, 0, cskBytes.length, out, 0);
            byte[] encCsk = new byte[outLen];
            System.arraycopy(out, 0, encCsk, 0, outLen);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(salt);
            baos.write(encCsk);
            baos.close();
            byte[] b64data = CryptoWrapper.encodeBase64(baos.toByteArray());
            fos.write("-----BEGIN CSK V4.0-----\n".getBytes());
            fos.write(b64data);
            fos.write("\n".getBytes());
            fos.write("-----END CSK V4.0-----\n".getBytes());
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_cpp_csk_store_save_error", new String[]{config.getCSKLocationForCPP()}));
            cskTraceLogger.logExit(cce);
            throw cce;
        }
        cskTraceLogger.logExit(true);
    }

    public static Certificate[] requestAndSignCertificate(KeyPair keyPair) throws CAMCryptoException, CryptoWrapperException, CaClientException {
        Configuration config = Configuration.getInstance();
        Certificate cert = null;
        Certificate caCert = null;
        if (config.getWeAreCM() || config.isStandaloneCA()) {
            byte[] pkcs10data = CryptoWrapper.createCertificateRequest(config.getServerDN(), keyPair.getPublic(), keyPair.getPrivate(), "SHA1", null);
            cert = CryptoWrapper.generateCertificate(pkcs10data, KeyStoreReader.getCACertificate(), KeyStoreReader.getCAPrivateKey());
            caCert = KeyStoreReader.getCACertificate();
        } else {
            PriorityUrlList urls = config.getPeers();
            boolean bFoundTarget = false;
            Iterator<URL> thisUrl = urls.getIterator();
            CaClient caClient = new CaClient();
            CaClientException firstError = null;
            while (thisUrl.hasNext()) {
                URL url = thisUrl.next();
                config.setLastUrlTried(url);
                try {
                    XmlCaRequest caRequest = caClient.genCARequest(config.getServerDN(), keyPair.getPublic(), keyPair.getPrivate(), config.getCAPassword());
                    caClient.requestCertificate(caRequest, url, config.getCAPassword());
                }
                catch (CaClientException ca) {
                    if (firstError != null) continue;
                    firstError = new CaClientException(ca, MessageSet.getMessage("CAM_CRP_ca_connection_failed"));
                    continue;
                }
                urls.updateURLPriority(url);
                bFoundTarget = true;
                break;
            }
            if (!bFoundTarget) {
                pkiTraceLogger.logExit("No available URL", firstError);
                throw firstError;
            }
            cert = caClient.getRequestedCert();
            caCert = caClient.getCaCert();
        }
        Certificate[] certChain = new Certificate[]{cert, caCert};
        return certChain;
    }

    public static void createKeyPairAndAddToKeystore(String alias) throws CAMCryptoException {
        KeyPair keyPair = KeyStoreWriter.createKeyPair(alias);
        Certificate[] certChain = KeyStoreWriter.buildCertificateChain(alias, keyPair);
        KeyStoreWriter.updateKeystore(alias, keyPair, certChain);
    }

    private static KeyPair createKeyPair(String alias) throws CAMCryptoException {
        pkiTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        String keyAlgorithm = null;
        int keySize = 0;
        if (0 == alias.compareToIgnoreCase("encryption")) {
            keyAlgorithm = config.getEncryptionKeyPairAlgorithm();
            keySize = config.getEncryptionKeyPairSize();
        } else if (0 == alias.compareToIgnoreCase("ca")) {
            keyAlgorithm = config.getCAKeyPairAlgorithm();
            keySize = config.getCAKeyPairSize();
        } else {
            return null;
        }
        try {
            KeyPairGenerator keyGen;
            if (JVMEnvironment.getInstance().isFIPSEnabled()) {
                String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
                keyGen = KeyPairGenerator.getInstance(keyAlgorithm, jceProvider);
            } else {
                keyGen = KeyPairGenerator.getInstance(keyAlgorithm);
            }
            keyGen.initialize(keySize);
            KeyPair keyPair = keyGen.generateKeyPair();
            pkiTraceLogger.logExit(true);
            return keyPair;
        }
        catch (NoSuchAlgorithmException e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_could_not_create_enc_key_pair"));
            pkiTraceLogger.logExit(cce);
            throw cce;
        }
        catch (NoSuchProviderException nspe) {
            pkiTraceLogger.logExit(nspe);
            throw new CAMCryptoException(nspe, MessageSet.getMessage("CAM_CRP_could_not_create_enc_key_pair"));
        }
    }

    public static Certificate[] createAndRequestCertificateFromCM(String alias, KeyPair keyPair) throws CAMCryptoException {
        pkiTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        CAMKeyStore caStore = ksMgr.getCAKeystore(alias);
        Certificate cert = null;
        Certificate caCert = null;
        caStore.loadKeyStore();
        PriorityUrlList urls = config.getPeers();
        boolean bFoundTarget = false;
        Iterator<URL> thisUrl = urls.getIterator();
        CaClient caClient = new CaClient();
        CaClientException firstError = null;
        while (thisUrl.hasNext()) {
            URL url = thisUrl.next();
            config.setLastUrlTried(url);
            try {
                XmlCaRequest caRequest = caClient.genCARequest(config.getServerDN(), keyPair.getPublic(), keyPair.getPrivate(), config.getCAPassword());
                caClient.requestCertificate(caRequest, url, config.getCAPassword());
            }
            catch (CaClientException ca) {
                if (firstError != null) continue;
                firstError = ca;
                continue;
            }
            urls.updateURLPriority(url);
            bFoundTarget = true;
            break;
        }
        if (!bFoundTarget) {
            pkiTraceLogger.logExit("No available URL", firstError);
            throw firstError;
        }
        cert = caClient.getRequestedCert();
        caCert = caClient.getCaCert();
        KeyStoreWriter.storeCACertificate(caCert);
        Certificate[] certChain = new Certificate[]{cert, caCert};
        pkiTraceLogger.logExit(true);
        return certChain;
    }

    public static Certificate[] buildCertificateChain(String alias, KeyPair keyPair) throws CAMCryptoException, CryptoWrapperException {
        Configuration config = Configuration.getInstance();
        Certificate[] certChain = null;
        if (config.getWeAreCM() || config.isStandaloneCA()) {
            byte[] pkcs10data = CryptoWrapper.createCertificateRequest(config.getServerDN(), keyPair.getPublic(), keyPair.getPrivate(), "SHA1", null);
            Certificate cert = CryptoWrapper.generateCertificate(pkcs10data, KeyStoreReader.getCACertificate(), KeyStoreReader.getCAPrivateKey());
            Certificate caCert = KeyStoreReader.getCACertificate();
            certChain = new Certificate[]{cert, caCert};
        } else {
            certChain = KeyStoreWriter.createAndRequestCertificateFromCM(alias, keyPair);
        }
        return certChain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateKeystore(String alias, KeyPair keyPair, Certificate[] certChain) throws CAMCryptoException {
        KeyStoreManager ksMgr = KeyStoreManager.getInstance();
        CAMKeyStore caStore = ksMgr.getCAKeystore(alias);
        try {
            caStore.lock();
            caStore.loadKeyStore();
            if (0 == alias.compareToIgnoreCase("encryption")) {
                caStore.setCert(alias, certChain, keyPair.getPrivate());
            } else if (caStore.getPrivateKey(alias) != null) {
                caStore.rolloverCert(alias, certChain, keyPair.getPrivate());
            } else {
                caStore.setCert(alias, certChain, keyPair.getPrivate());
            }
            caStore.saveKeyStore();
        }
        finally {
            caStore.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate createCAKeyPair(boolean overideCurrentKeyPair) throws CAMCryptoException {
        caTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        CAMKeyStore store = ksMgr.getCAKeystore("ca");
        X509Certificate caCert = null;
        try {
            store.lock();
            store.loadKeyStore();
            if (!overideCurrentKeyPair && store.getPrivateKey("ca") != null) {
                throw new KeysAlreadyExistException(MessageSet.getMessage("CAM_CRP_ca_key_pair_already_created"));
            }
            KeyPair caPair = KeyStoreWriter.createKeyPair("ca");
            caCert = CryptoWrapper.createSelfSignedCertificate(caPair, CAMCryptoUtilities.reverseDN(config.getCASubjectDN()), null, -1L);
            Certificate[] certChain = new Certificate[]{caCert};
            if (store.getPrivateKey("ca") != null) {
                store.rolloverCert("ca", certChain, caPair.getPrivate());
            } else {
                store.setCert("ca", certChain, caPair.getPrivate());
            }
            KeyPair encKeyPair = KeyStoreWriter.createKeyPair("encryption");
            Certificate[] encCertChain = KeyStoreWriter.requestAndSignCertificate(encKeyPair);
            PrivateKey encPrivateKey = encKeyPair.getPrivate();
            if (overideCurrentKeyPair) {
                store.rolloverCert("encryption", encCertChain, encPrivateKey);
            } else {
                store.setCert("encryption", encCertChain, encPrivateKey);
            }
            store.saveKeyStore();
        }
        finally {
            store.unlock();
        }
        caTraceLogger.logExit(true);
        return caCert;
    }

    public static String createNewCamCryptoKeyPairAndGenerateCSR(String dn, String ksLoc, String password, String algorithm, SANExtAttributes sanExtAttrs) throws CAMCryptoException {
        pkiTraceLogger.logEnter();
        CAMKeyStore store = null;
        try {
            KeyPairGenerator keyGen;
            String storeType = JVMEnvironment.getInstance().getPKCS12KeystoreType();
            store = new CAMKeyStore(ksLoc, password, storeType, "BC");
            store.lock();
            store.loadKeyStore();
            if (JVMEnvironment.getInstance().isFIPSEnabled()) {
                String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
                keyGen = KeyPairGenerator.getInstance(algorithm, jceProvider);
            } else {
                keyGen = KeyPairGenerator.getInstance(algorithm);
            }
            int keyLength = 0;
            keyLength = JVMEnvironment.getInstance().isFIPSEnabled() ? JNISystemProperties.getFIPSKeyLength() : JNISystemProperties.getRSAKeyLength();
            keyGen.initialize(keyLength);
            KeyPair encryptionPair = keyGen.generateKeyPair();
            String shaAlg = null;
            shaAlg = JVMEnvironment.getInstance().isFIPSEnabled() ? "SHA256" : "SHA1";
            X509Certificate selfSignedCert = CryptoWrapper.createSelfSignedCertificate(encryptionPair, CAMCryptoUtilities.reverseDN(dn), shaAlg, 30L);
            Certificate[] certChain = new Certificate[]{selfSignedCert};
            boolean weShouldRollover = true;
            X509Certificate oldCert = (X509Certificate)store.getCertificate("encryption");
            if (oldCert == null || oldCert.getIssuerDN().equals(oldCert.getSubjectDN())) {
                weShouldRollover = false;
            }
            if (weShouldRollover) {
                store.rolloverCert("encryption", certChain, encryptionPair.getPrivate());
            } else {
                store.setCert("encryption", certChain, encryptionPair.getPrivate());
            }
            store.saveKeyStore();
            byte[] pkcs10data = CryptoWrapper.createCertificateRequest(dn, encryptionPair.getPublic(), encryptionPair.getPrivate(), shaAlg, sanExtAttrs);
            byte[] pemCSR = PemGenerator.encode(pkcs10data, "NEW CERTIFICATE REQUEST");
            pkiTraceLogger.logExit(true);
            String string = new String(pemCSR);
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_could_not_create_enc_key_pair"));
            pkiTraceLogger.logExit(cce);
            throw cce;
        }
        catch (NoSuchProviderException nspe) {
            throw new CAMCryptoException(nspe, MessageSet.getMessage("CAM_CRP_could_not_create_enc_key_pair"));
        }
        finally {
            store.unlock();
        }
    }

    public static void storeThirdPartyCamCryptoCert(Certificate thirdPartyEncryptionCert, Certificate[] externalCaCertChain, String ksLoc, String password) throws CAMCryptoException {
        pkiTraceLogger.logEnter();
        CAMKeyStore store = null;
        String storeType = JVMEnvironment.getInstance().getPKCS12KeystoreType();
        try {
            store = new CAMKeyStore(ksLoc, password, storeType, "BC");
            store.lock();
            store.loadKeyStore();
            store.setThirdPartyCert("encryption", KeyStoreWriter._orderCertChain(thirdPartyEncryptionCert, externalCaCertChain));
            store.saveKeyStore();
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_could_not_store_third_party_enc_cert"));
            pkiTraceLogger.logExit(cce);
            throw cce;
        }
        finally {
            store.unlock();
        }
        pkiTraceLogger.logExit(true);
    }

    public static void storeCACertificate(Certificate caCert) throws CAMCryptoException {
        caTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        CAMKeyStore store = ksMgr.getCAKeystore("ca");
        try {
            store.lock();
            store.loadKeyStore();
            store.setCaCert(caCert);
            store.saveKeyStore();
        }
        finally {
            store.unlock();
        }
        caTraceLogger.logExit(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeThirdPartyCaCert(Certificate[] thirdPartyCaCerts, String ksLoc, String password) throws CAMCryptoException {
        caTraceLogger.logEnter();
        CAMKeyStore store = null;
        String storeType = JVMEnvironment.getInstance().getPKCS12KeystoreType();
        try {
            store = new CAMKeyStore(ksLoc, password, storeType, "BC");
            store.lock();
            store.loadKeyStore();
            for (int i = 0; i < thirdPartyCaCerts.length; ++i) {
                CaFreshnessHandler cafh = null;
                try {
                    cafh = CaFreshnessHandler.getInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (cafh != null) {
                    cafh.invalidateLocalFreshness();
                }
                store.addTrustedCert(thirdPartyCaCerts[i]);
            }
            store.saveKeyStore();
        }
        finally {
            store.unlock();
        }
        caTraceLogger.logExit(true);
    }

    private static Certificate[] _orderCertChain(Certificate thirdPartyCert, Certificate[] externalCaCertChain) throws Exception {
        PKIXCertPathBuilderResult result;
        caTraceLogger.logEnter();
        ArrayList<X509Certificate> certlist = new ArrayList<X509Certificate>();
        CertificateFactory cf = null;
        if (JVMEnvironment.getInstance().isFIPSEnabled()) {
            String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
            cf = CertificateFactory.getInstance("X.509", jceProvider);
        } else {
            cf = CertificateFactory.getInstance("X.509", "BC");
        }
        byte[] encodedCert = thirdPartyCert.getEncoded();
        ByteArrayInputStream certBais = new ByteArrayInputStream(thirdPartyCert.getEncoded());
        X509Certificate bcThirdPartyCert = (X509Certificate)cf.generateCertificate(certBais);
        certlist.add(bcThirdPartyCert);
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        X509Certificate rootCert = null;
        for (int c = 0; c < externalCaCertChain.length; ++c) {
            byte[] encoded = externalCaCertChain[c].getEncoded();
            ByteArrayInputStream bais = new ByteArrayInputStream(encoded);
            X509Certificate bcCert = (X509Certificate)cf.generateCertificate(bais);
            if (bcCert.getIssuerDN().equals(bcCert.getSubjectDN())) {
                TrustAnchor ta = new TrustAnchor(bcCert, null);
                trustAnchors.add(ta);
                rootCert = bcCert;
                continue;
            }
            certlist.add(bcCert);
        }
        if (trustAnchors.isEmpty()) {
            CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_ca_cert_chain_missing_root_cert"));
            caTraceLogger.logExit(cce);
            throw cce;
        }
        CollectionCertStoreParameters ccsp = new CollectionCertStoreParameters(certlist);
        Provider provider = Security.getProvider("BC");
        CertStore certstore = CertStore.getInstance("Collection", (CertStoreParameters)ccsp, provider);
        X509CertSelector targetConstraints = new X509CertSelector();
        byte[] subject = bcThirdPartyCert.getSubjectX500Principal().getEncoded();
        targetConstraints.setSubject(subject);
        PKIXBuilderParameters params = new PKIXBuilderParameters(trustAnchors, (CertSelector)targetConstraints);
        params.addCertStore(certstore);
        params.setRevocationEnabled(false);
        CertPathBuilder cpb = CertPathBuilder.getInstance("PKIX", "BC");
        try {
            result = (PKIXCertPathBuilderResult)cpb.build(params);
        }
        catch (CertPathBuilderException cpbe) {
            CAMCryptoException cce = new CAMCryptoException(cpbe, MessageSet.getMessage("CAM_CRP_could_not_build_cert_chain"));
            caTraceLogger.logExit(cce);
            throw cce;
        }
        CertPath certPath = result.getCertPath();
        List<? extends Certificate> builtlist = certPath.getCertificates();
        Certificate[] chain = new Certificate[builtlist.size() + 1];
        builtlist.toArray(chain);
        chain[chain.length - 1] = rootCert;
        caTraceLogger.logExit(true);
        return chain;
    }

    public static SecretKey requestAndStoreRemoteCSK(byte[] digest) throws CAMCryptoException {
        CaFreshnessHandler cafh;
        cskTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        if (!config.getUsingThirdPartyCA() && (cafh = CaFreshnessHandler.getInstance()).needSync()) {
            CaSyncHandler cash = CaSyncHandler.getInstance();
            cash.synchronizeCaCerts();
        }
        try {
            byte[] hostIP = InetAddress.getLocalHost().getAddress();
            byte[] rawEncCert = KeyStoreReader.getEncryptionCertificate().getEncoded();
            byte[] locale = CAMCryptoUtilities.findLocale().getBytes();
            String cskRequestSoapXML = KeyStoreWriter.createCSKRequestSoapXML(locale, hostIP, rawEncCert, digest);
            PriorityUrlList peersList = config.getPeers();
            SecretKey csk = KeyStoreWriter.sendRequestDecryptResponseGetCSK(peersList, cskRequestSoapXML);
            if (digest != null) {
                KeyStoreWriter.storeOldCSK(csk);
            } else {
                KeyStoreWriter.storeLatestCSK(csk);
            }
            cskTraceLogger.logExit(true);
            return csk;
        }
        catch (CAMCryptoException cce) {
            cskTraceLogger.logExit(cce);
            throw cce;
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_req_csk_http_error", new String[]{config.getPeer().toString()}));
            cskTraceLogger.logExit(cce);
            throw cce;
        }
    }

    public static SecretKey sendRequestDecryptResponseGetCSK(PriorityUrlList peersList, String cskRequestSoapXML) throws CAMCryptoException {
        SecretKey csk = null;
        CAMCryptoException firstError = null;
        Iterator<URL> urlIt = peersList.getIterator();
        while (urlIt.hasNext()) {
            URL url = urlIt.next();
            try {
                PostMethod post = new PostMethod();
                post.setRequestBody(cskRequestSoapXML);
                post.setPath(url.getFile());
                post.setRequestHeader("Content-type", "text/xml");
                post.setRequestHeader("SOAPAction", "\"http://www.ibm.com/xmlns/prod/cognos/contentManagerService/201404/\"");
                HttpClient hc = HttpClientInitializer.getInstance().createHttpClient(url);
                hc.setConnectionTimeout(60000);
                hc.setTimeout(60000);
                String response = null;
                int resultCode = 0;
                try {
                    resultCode = hc.executeMethod((HttpMethod)post);
                    response = CAMCryptoUtilities.getResponseString(post);
                    post.releaseConnection();
                }
                catch (HttpRecoverableException e) {
                    if (firstError != null) break;
                    firstError = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_req_csk_http_error", new String[]{url.toString()}));
                    break;
                }
                catch (Exception e) {
                    if (firstError != null) continue;
                    firstError = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_req_csk_http_error", new String[]{url.toString()}));
                    continue;
                }
                if (resultCode < 200 || resultCode > 299) {
                    if (firstError != null) continue;
                    firstError = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_req_http_ret_code_error", new String[]{String.valueOf(resultCode)}));
                    continue;
                }
                Document doc = DocumentHelper.parseText((String)response);
                List nodeList = doc.selectNodes("/*[local-name()='Envelope']/*[local-name()='Body']/*[local-name()='queryResponse']/*[local-name()='queryResult']/*[local-name()='item']/*[local-name()='commonSymmetricKey']/*[local-name()='value']");
                Iterator it = nodeList.iterator();
                if (!it.hasNext()) {
                    CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_remote_csk_req_parse_error"));
                    cskTraceLogger.logExit(cce);
                    throw cce;
                }
                Node node = (Node)it.next();
                if (it.hasNext()) {
                    CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_remote_csk_req_parse_error"));
                    cskTraceLogger.logExit(cce);
                    throw cce;
                }
                byte[] b64CSKResponse = node.getText().getBytes();
                try {
                    csk = KeyStoreWriter.decryptReqponseGetCSK(b64CSKResponse);
                }
                catch (CAMCryptoException cce) {
                    if (!(cce instanceof CAMCryptoServerException)) continue;
                    firstError = cce;
                    break;
                }
                catch (Exception cce) {
                    continue;
                }
                peersList.updateURLPriority(url);
                break;
            }
            catch (Exception e) {
                if (firstError != null) continue;
                firstError = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_req_csk_http_error", new String[]{url.toString()}));
            }
        }
        if (firstError != null) {
            cskTraceLogger.logExit(firstError);
            throw firstError;
        }
        return csk;
    }

    public static SecretKey decryptReqponseGetCSK(byte[] b64CSKResponse) throws CAMCryptoException {
        Configuration config = Configuration.getInstance();
        SecretKey csk = null;
        byte[] rawResponse = CryptoWrapper.decodeBase64(b64CSKResponse);
        rawResponse = CryptoWrapper.decodeBase64(rawResponse);
        byte reqVersion = rawResponse[0];
        byte respType = rawResponse[1];
        byte[] rawEncryptedCSK = new byte[rawResponse.length - 2];
        System.arraycopy(rawResponse, 2, rawEncryptedCSK, 0, rawResponse.length - 2);
        if (reqVersion != 2) {
            CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_csk_invalid_msg_version"));
            cskTraceLogger.logExit(cce);
            throw cce;
        }
        if (respType == 9) {
            CAMCryptoUtilities.throwServerException(rawEncryptedCSK);
        }
        try {
            PrivateKey encPrivateKey = KeyStoreReader.getEncryptionPrivateKey();
            String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
            Cipher c = Cipher.getInstance("RSA", jceProvider);
            c.init(2, encPrivateKey);
            EncodedCSK ecsk = new EncodedCSK(c.doFinal(rawEncryptedCSK));
            csk = ecsk.getKey();
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_req_csk_cm_failure"));
            cskTraceLogger.logExit(cce);
            throw cce;
        }
        return csk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncCSKKeystoreWithCM() throws CAMCryptoException {
        cskTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        try {
            Object object = KeyExpiryChecker.csklock;
            synchronized (object) {
                EncodedCSK ecsk;
                byte[] cmKeyData;
                byte[] cmCskBytes;
                String alias;
                int i;
                ksMgr.getCMCSKStore();
                cskTraceLogger.trace("Merging CM keystore with local copy");
                String currentAlias = config.getCSKAlias();
                if (!keyFormatUpgradeCompleted) {
                    cskTraceLogger.trace("Trying to upgrade CM CSK store key format");
                    CMStoreWrapper cmks = ksMgr.getCMCSKStore();
                    String[] cmAliases = cmks.getAllDataKeys();
                    if (cmAliases != null) {
                        for (i = 0; i < cmAliases.length; ++i) {
                            alias = cmAliases[i];
                            cmCskBytes = cmks.getData(alias);
                            if (cmCskBytes == null) continue;
                            cskTraceLogger.trace("Upgrading CSK with name " + alias + " in CM.");
                            EncodedCSK ecsk2 = new EncodedCSK(cmCskBytes);
                            if (!ecsk2.getWasInOldFormat()) continue;
                            byte[] upgradedCsk = ecsk2.getEncoded();
                            cmks.setData(alias, upgradedCsk);
                        }
                    }
                    keyFormatUpgradeCompleted = true;
                }
                if (ksMgr.getCMCSKStore().getData(currentAlias) == null) {
                    cskTraceLogger.trace("CM keystore does not have a master CSK");
                    if (ksMgr.getCSKKeystore().containsAlias(currentAlias)) {
                        SecretKey ksCsk = (SecretKey)ksMgr.getCSKKeystore().getKey(currentAlias, config.getCSKPassword().toCharArray());
                        Date ksCskCreationDate = ksMgr.getCSKKeystore().getCreationDate(currentAlias);
                        EncodedCSK ecsk3 = new EncodedCSK(ksCskCreationDate, ksCsk);
                        byte[] encodedCSK = ecsk3.getEncoded();
                        if (encodedCSK.length != 0) {
                            ksMgr.getCMCSKStore().setData(currentAlias, encodedCSK);
                            cskTraceLogger.trace("Added master CSK to CM keystore");
                        } else {
                            cskTraceLogger.trace("Not able to add empty CSK to CM database !!!");
                        }
                    }
                } else if (!ksMgr.getCSKKeystore().containsAlias(currentAlias)) {
                    cskTraceLogger.trace("Local keystore does not have a master CSK");
                    cmKeyData = ksMgr.getCMCSKStore().getData(currentAlias);
                    if (cmKeyData != null) {
                        ecsk = new EncodedCSK(cmKeyData);
                        SecretKey cmCsk = ecsk.getKey();
                        KeyStoreWriter.storeLatestCSK(cmCsk);
                        cskTraceLogger.trace("Added master CSK to local keystore");
                    }
                } else {
                    cmKeyData = ksMgr.getCMCSKStore().getData(currentAlias);
                    if (cmKeyData != null) {
                        ecsk = new EncodedCSK(cmKeyData);
                        SecretKey cmCsk = ecsk.getKey();
                        Date cmCskCreationDate = ecsk.getCreationDate();
                        SecretKey ksCsk = (SecretKey)ksMgr.getCSKKeystore().getKey(currentAlias, config.getCSKPassword().toCharArray());
                        Date ksCskCreationDate = ksMgr.getCSKKeystore().getCreationDate(currentAlias);
                        if (!cmCsk.equals(ksCsk)) {
                            if (cmCskCreationDate.after(ksCskCreationDate)) {
                                cskTraceLogger.trace("Master CSK Mismatch, using the CM one as the new master");
                                KeyStoreWriter.storeLatestCSK(cmCsk);
                            } else {
                                cskTraceLogger.trace("Master CSK Mismatch, using the local one as the new master");
                                KeyStoreWriter.storeOldCSK(cmCsk);
                                ksMgr.getCMCSKStore().setData(currentAlias, new EncodedCSK(ksCskCreationDate, ksCsk).getEncoded());
                            }
                        }
                    }
                }
                String[] cmAliases = ksMgr.getCMCSKStore().getAllDataKeys();
                Enumeration<String> ksAliases = ksMgr.getCSKKeystore().aliases();
                if (cmAliases != null) {
                    for (i = 0; i < cmAliases.length; ++i) {
                        alias = cmAliases[i];
                        if (alias.equals(currentAlias) || ksMgr.getCSKKeystore().containsAlias(alias) || (cmCskBytes = ksMgr.getCMCSKStore().getData(alias)) == null) continue;
                        cskTraceLogger.trace("Adding CSK with name " + alias + " to local keystore.");
                        SecretKey cmCsk = new EncodedCSK(cmCskBytes).getKey();
                        KeyStoreWriter.storeOldCSK(cmCsk);
                    }
                }
                while (ksAliases.hasMoreElements()) {
                    String alias2 = ksAliases.nextElement();
                    if (alias2.equals(currentAlias) || ksMgr.getCMCSKStore().getData(alias2) != null) continue;
                    cskTraceLogger.trace("Adding CSK with name " + alias2 + " to the CM keystore.");
                    SecretKey ksCsk = (SecretKey)ksMgr.getCSKKeystore().getKey(alias2, config.getCSKPassword().toCharArray());
                    EncodedCSK ecsk4 = new EncodedCSK(ksMgr.getCSKKeystore().getCreationDate(alias2), ksCsk);
                    ksMgr.getCMCSKStore().addData(alias2, ecsk4.getEncoded());
                }
                cskTraceLogger.trace("Done merging the CM keystore with local copy");
                if (!config.getUsingThirdPartyCA()) {
                    cskTraceLogger.trace("Sync local CA Certificate with CM");
                    CaFreshnessHandler cafh = CaFreshnessHandler.getInstance();
                    if (cafh.needSync()) {
                        CaSyncHandler cash = CaSyncHandler.getInstance();
                        cash.synchronizeCaCerts();
                    }
                }
                syncCompleted = true;
            }
        }
        catch (CMStoreWrapperException e) {
            try {
                ksMgr.getCMCSKStore();
                if (!CSKToCMSyncher.isRunning) {
                    CSKToCMSyncher cskToCmSyncer = new CSKToCMSyncher();
                    Thread cskToCMSyncherThread = new Thread(cskToCmSyncer);
                    cskToCMSyncherThread.start();
                }
            }
            catch (CMStoreWrapperException cskToCmSyncer) {}
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_cm_csk_synchronize_error"));
            cskTraceLogger.logExit(cce);
            throw cce;
        }
        cskTraceLogger.logExit(true);
    }

    public static void forceSaveOfCSKKeystore(String oldPassword) throws CAMCryptoException {
        Enumeration<String> ksEntries;
        pkiTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        if (!config.getCacheCSKLocally()) {
            File file = new File(config.getCSKLocation());
            file.delete();
            file = new File(config.getCSKLocationForCPP());
            file.delete();
            file = new File(config.getCSKLocation()).getParentFile();
            file.delete();
            pkiTraceLogger.logExit();
            return;
        }
        char[] oldPass = oldPassword.toCharArray();
        KeyStore ks = ksMgr.getCSKKeystore();
        try {
            ksEntries = ks.aliases();
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{config.getCSKLocation()}));
        }
        while (ksEntries.hasMoreElements()) {
            String alias = ksEntries.nextElement();
            try {
                if (!ksMgr.getCSKKeystore().isKeyEntry(alias)) continue;
                Key key = ks.getKey(alias, oldPass);
                ks.setKeyEntry(alias, key, config.getCSKPassword().toCharArray(), null);
            }
            catch (Exception e) {
                CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{config.getCSKLocation()}));
                pkiTraceLogger.logExit(cce);
                throw cce;
            }
        }
        KeyStoreWriter.writeCSKKeystoresToDisk();
        pkiTraceLogger.logExit(true);
    }

    public static void forceSaveOfCAKeystore(String oldPassword) throws CAMCryptoException {
        caTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        CAMKeyStore keystore = ksMgr.getCAKeystore("ca");
        keystore.updateParameters(config.getCAMKeystoreLocation(), config.getCAKeyPassword(), config.getCAFormat(), config.getAsymmKeystoreProviderName());
        keystore.saveKeyStore();
        keystore.reEncryptKeys(oldPassword);
        caTraceLogger.logExit(true);
    }

    public static void chtagKeyStoreBinaryOnzOS(File fileObj) throws Exception {
        StringBuffer sb = new StringBuffer();
        if (System.getProperty("os.name").equals("z/OS")) {
            try {
                Process p = Runtime.getRuntime().exec("chtag -b " + fileObj.getAbsolutePath());
                BufferedReader stderr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                String errStr = null;
                while ((errStr = stderr.readLine()) != null) {
                    if (errStr == null) continue;
                    sb.append("Cognos could not tag keystore " + fileObj.getAbsolutePath() + "due to error " + errStr);
                    sb.append("Either the files are missing or insufficient ownership/permissions on the files/folders.");
                }
                if (sb.length() != 0) {
                    throw new Exception(sb.toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Exception("Cognos has encountered an exception while tagging files.  A runtime error related to reading in the file or executing the tag command.", e);
            }
        }
    }

    public static boolean haveSyncedSuccessfully() {
        return syncCompleted;
    }

    private static String createV1Request(byte[] hostIP, byte[] rawEncCert, byte[] digest) throws CAMCryptoException {
        int sFlag;
        byte[] contentData;
        cskTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        PrivateKey signPrivateKey = KeyStoreReader.getSigningPrivateKey();
        Certificate[] signCertChain = KeyStoreReader.getSigningCertificateChain();
        X509Certificate[] x509SignCertChain = new X509Certificate[signCertChain.length];
        System.arraycopy(signCertChain, 0, x509SignCertChain, 0, signCertChain.length);
        signCertChain = null;
        if (digest == null) {
            contentData = new byte[1 + hostIP.length + rawEncCert.length];
            contentData[0] = (byte)hostIP.length;
            System.arraycopy(hostIP, 0, contentData, 1, hostIP.length);
            System.arraycopy(rawEncCert, 0, contentData, hostIP.length + 1, rawEncCert.length);
            sFlag = 4;
        } else {
            contentData = new byte[1 + hostIP.length + 1 + digest.length + rawEncCert.length];
            contentData[0] = (byte)hostIP.length;
            System.arraycopy(hostIP, 0, contentData, 1, hostIP.length);
            contentData[hostIP.length + 1] = (byte)digest.length;
            System.arraycopy(digest, 0, contentData, hostIP.length + 2, digest.length);
            System.arraycopy(rawEncCert, 0, contentData, hostIP.length + digest.length + 2, rawEncCert.length);
            sFlag = 5;
        }
        byte[] signedContentData = PKCS7SignedData.sign(contentData, signPrivateKey, x509SignCertChain, config.getDigestAlgorithm());
        byte[] signedRequest = new byte[1 + signedContentData.length];
        signedRequest[0] = (byte)sFlag;
        System.arraycopy(signedContentData, 0, signedRequest, 1, signedContentData.length);
        String b64CSKReqBytes = new String(CryptoWrapper.encodeBase64(signedRequest));
        String strXMLRequest = new StringBuffer().append(CSK_REQ_HEAD).append(b64CSKReqBytes).append(CSK_REQ_TAIL).toString();
        if (strXMLRequest == null || strXMLRequest.length() == 0) {
            cskTraceLogger.logExit();
        } else {
            cskTraceLogger.logExit(true);
        }
        return strXMLRequest;
    }

    private static String createCSKRequestSoapXML(byte[] locale, byte[] hostIP, byte[] rawEncCert, byte[] digest) throws CAMCryptoException {
        cskTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        PrivateKey signPrivateKey = KeyStoreReader.getSigningPrivateKey();
        Certificate[] signCertChain = KeyStoreReader.getSigningCertificateChain();
        X509Certificate[] x509SignCertChain = new X509Certificate[signCertChain.length];
        System.arraycopy(signCertChain, 0, x509SignCertChain, 0, signCertChain.length);
        signCertChain = null;
        EncodedCSKRequest encodedCSKRequest = new EncodedCSKRequest(locale, hostIP, rawEncCert, digest);
        byte[] contentData = encodedCSKRequest.genCSKRequest();
        byte[] signedContentData = PKCS7SignedData.sign(contentData, signPrivateKey, x509SignCertChain, config.getDigestAlgorithm());
        String b64CSKReqBytes = new String(CryptoWrapper.encodeBase64(signedContentData));
        String soapCSKRequest = new StringBuffer().append(CSK_REQ_HEAD).append(b64CSKReqBytes).append(CSK_REQ_TAIL).toString();
        if (soapCSKRequest == null || soapCSKRequest.length() == 0) {
            cskTraceLogger.logExit();
        } else {
            cskTraceLogger.logExit(true);
        }
        return soapCSKRequest;
    }
}

