/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.utilities;

import java.io.File;
import java.util.ArrayList;

public class EnvironmentChecks {
    static String suggestion = "Please ensure that the file exists, and use OS commands or tools (such as Dependency Walker) to check all dependencies of the file exist in your environment.";
    static String cwd = null;

    public String loadLibraries() throws Exception {
        ArrayList<String> libraries = new ArrayList<String>();
        libraries.add("CAM_Crypto_Interface");
        libraries.add("CAM_Crypto_POpenSSL");
        libraries.add("CCLCore");
        cwd = System.getProperty("user.dir");
        if (cwd.endsWith("bin")) {
            libraries.add("gsk8km");
            libraries.add("gsk8ssl");
        } else if (cwd.endsWith("bin64")) {
            libraries.add("gsk8km_64");
            libraries.add("gsk8ssl_64");
        }
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < libraries.size(); ++i) {
            this.loadLibrary((String)libraries.get(i), ret);
        }
        return ret.toString();
    }

    private boolean loadLibrary(String libraryName, StringBuffer ret) {
        boolean testOK = false;
        try {
            ret.append("\nLoading " + libraryName + "  at  " + cwd + "  ...\n");
            System.loadLibrary(libraryName);
            ret.append("Successfully Loaded " + libraryName + ".\n\n");
            testOK = true;
        }
        catch (UnsatisfiedLinkError ule) {
            ret.append("? ");
            ret.append(ule.toString() + "\n");
            File f = new File(libraryName + this.getFileExtension());
            if (f.exists()) {
                ret.append("File " + libraryName + this.getFileExtension() + " exists.\n\n");
            } else {
                ret.append("? ");
                ret.append("File " + libraryName + this.getFileExtension() + " does not exist.\n\n");
            }
        }
        catch (Exception e1) {
            ret.append("? ");
            ret.append(e1.toString() + "\n");
            ret.append(suggestion + "\n\n");
        }
        catch (Error e2) {
            ret.append("? ");
            ret.append(e2.toString() + "\n");
            ret.append(suggestion + "\n\n");
        }
        return testOK;
    }

    private String getFileExtension() {
        String os = System.getProperty("os.name");
        if (os != null && os.startsWith("Windows")) {
            return ".dll";
        }
        return ".so";
    }
}

