/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.utilities;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.FileSignatureSession;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;

public class FileSignerTool {
    public int signFile(String fileName, String keystore, String keystorePassword) throws Exception {
        CAMFactory cf = null;
        try {
            cf = new CAMFactory("FileSignature");
        }
        catch (CAMCryptoException e1) {
            e1.printStackTrace();
        }
        FileSignatureSession fileSignatureSession = null;
        try {
            fileSignatureSession = cf.createFileSignatureSession();
        }
        catch (CAMCryptoException e) {
            e.printStackTrace();
            System.out.println("\n");
            return -1;
        }
        System.out.println("Create FileSignatureSessio ...");
        byte[] b64SignedData = null;
        try {
            b64SignedData = fileSignatureSession.signData(fileName, keystore, keystorePassword);
        }
        catch (CAMCryptoException e) {
            e.printStackTrace();
            System.out.println("\n");
            return -1;
        }
        System.out.println("Successfully signed text file: " + fileName);
        try {
            FileOutputStream outputStream = new FileOutputStream(fileName + ".signature");
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.write(b64SignedData, 0, b64SignedData.length);
            dataOutputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\n");
            return -1;
        }
        System.out.println("Signature is saved in file: " + fileName + ".signature");
        return 1;
    }

    public boolean verifyFile(String fileName) {
        CAMFactory cf = null;
        try {
            cf = new CAMFactory("FileSignature");
        }
        catch (CAMCryptoException e) {
            e.printStackTrace();
        }
        FileSignatureSession fileSignatureSession = null;
        try {
            fileSignatureSession = cf.createFileSignatureSession();
        }
        catch (CAMCryptoException e) {
            e.printStackTrace();
        }
        System.out.println("Create FileSignatureSession ...");
        boolean ret = false;
        try {
            ret = fileSignatureSession.verifyData(fileName);
            if (ret) {
                System.out.println("Successfully verified signature");
            } else {
                System.out.println("Failed to verify signature");
            }
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (SignatureException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        catch (CAMCryptoException e) {
            e.printStackTrace();
        }
        return true;
    }
}

