/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.store.provider;

import com.ibm.smarts.schema.DataClue;
import com.ibm.smarts.store.api.ITypedStore;
import com.ibm.smarts.store.api.provider.IDataClueStore;
import com.ibm.smarts.store.api.query.IRecord;
import com.ibm.smarts.store.api.query.IRecordResult;
import com.ibm.smarts.store.api.query.IStoreQuery;
import com.ibm.smarts.store.api.query.IStoreQueryBuilder;
import com.ibm.smarts.store.api.query.StoreStatus;
import java.util.List;

public class SmartsDataClueStore
implements IDataClueStore {
    private final ITypedStore<DataClue> store;

    public SmartsDataClueStore(ITypedStore<DataClue> store) {
        this.store = store;
    }

    @Override
    public IStoreQueryBuilder getQueryBuilder() {
        return this.store.getQueryBuilder();
    }

    @Override
    public List<IRecordResult<DataClue>> executeSearch(IStoreQuery sq) {
        return this.store.executeSearch(sq);
    }

    @Override
    public StoreStatus store(List<IRecord<DataClue>> clues) {
        return this.store.store(clues, true);
    }

    @Override
    public StoreStatus delete(String ontoId) {
        IStoreQuery sq = this.store.getQueryBuilder().addFilter("ontologyID", new String[]{ontoId}).build();
        return this.store.deleteByQuery(sq);
    }

    @Override
    public StoreStatus delete(String ontoId, String tenantId) {
        IStoreQuery sq = this.store.getQueryBuilder().addFilter("ontologyID", new String[]{ontoId}).addFilter("tenantID", new String[]{tenantId}).build();
        return this.store.deleteByQuery(sq);
    }

    @Override
    public boolean isExist() {
        return this.store.isExists();
    }
}

