/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.store.provider;

import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.SmartsUtil;
import com.ibm.smarts.store.api.exceptions.RecordAlreadyExistsException;
import com.ibm.smarts.store.api.exceptions.RecordNotFoundException;
import com.ibm.smarts.store.api.provider.IInMemoryModuleStore;
import com.ibm.smarts.store.api.query.IRecord;
import com.ibm.smarts.store.api.query.StoreStatus;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartsModulePersistenceStore
implements IInMemoryModuleStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartsModulePersistenceStore.class);
    private final Map<String, Map<String, IRecord<SmartsModule>>> smartsModules = new ConcurrentHashMap<String, Map<String, IRecord<SmartsModule>>>();

    @Override
    public StoreStatus store(IRecord<SmartsModule> moduleRecord, String moduleId) {
        try {
            String recordId = moduleRecord.getId();
            SmartsModule record = (SmartsModule)moduleRecord.getRecord();
            record = (SmartsModule)record.clone();
            moduleRecord = IRecord.create((Object)record, (String)recordId);
            Map smartsModuleParts = this.smartsModules.computeIfAbsent(moduleId, k -> new ConcurrentHashMap());
            IRecord current = smartsModuleParts.putIfAbsent(recordId, moduleRecord);
            if (current != null) {
                throw new RecordAlreadyExistsException("SmartsModule id='" + moduleId + "', Dataset id = '" + recordId + "'", new Object[0]);
            }
            String resourceURI = IInMemoryModuleStore.buildDatasetCompositeId(moduleId, moduleRecord.getId());
            return new StoreStatus(true, Collections.emptyList(), resourceURI);
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error("Can not clone SmartsModule when store it", (Throwable)e);
            return new StoreStatus(false, Collections.singletonList(new InternalException("Can not store SmartsModule with cloning failure", new Object[0])));
        }
    }

    @Override
    public SmartsModule getById(String moduleId) {
        SmartsModule smartsModule = null;
        if (this.smartsModules.containsKey(moduleId)) {
            try {
                Map<String, IRecord<SmartsModule>> smartsModuleRecords = this.smartsModules.get(moduleId);
                SmartsModule globalSmartsModule = smartsModuleRecords.containsKey("SmartsModule") ? (SmartsModule)smartsModuleRecords.get("SmartsModule").getRecord() : null;
                List smartsModuleParts = null;
                if (globalSmartsModule != null) {
                    globalSmartsModule = (SmartsModule)globalSmartsModule.clone();
                    smartsModuleParts = smartsModuleRecords.values().stream().filter(v -> !v.getId().equals("SmartsModule")).map(IRecord::getRecord).collect(Collectors.toList());
                    smartsModule = SmartsUtil.smartsModuleFromParts(smartsModuleParts, (SmartsModule)globalSmartsModule, (boolean)true);
                } else {
                    smartsModuleParts = smartsModuleRecords.values().stream().map(IRecord::getRecord).collect(Collectors.toList());
                    smartsModule = SmartsUtil.smartsModuleFromParts(smartsModuleParts);
                    smartsModule.setAnalysisState(SmartsUtil.calculateState((SmartsModule)smartsModule));
                }
            }
            catch (CloneNotSupportedException e) {
                LOGGER.error("Can not clone SmartsModule when fetch it", (Throwable)e);
            }
        }
        return smartsModule;
    }

    @Override
    public CompletableFuture<SmartsModule> getByIdAsync(String moduleId) {
        return CompletableFuture.completedFuture(this.getById(moduleId));
    }

    @Override
    public StoreStatus deleteById(String moduleId) {
        if (StringUtils.isBlank((CharSequence)moduleId)) {
            LOGGER.error("ModuleId: " + moduleId + " is null or empty.");
            throw new IllegalArgumentException("ModuleId: " + moduleId + " is null or empty.");
        }
        if (!this.smartsModules.containsKey(moduleId)) {
            LOGGER.error("ModuleId:" + moduleId + " doesn't exists in moduleStore.");
            throw new RecordNotFoundException("ModuleId:" + moduleId + " doesn't exists in moduleStore.", new Object[0]);
        }
        this.smartsModules.remove(moduleId);
        return new StoreStatus(true, Collections.emptyList());
    }

    @Override
    public StoreStatus apply(String moduleId, Function<SmartsModule, SmartsModule> updateLambda) {
        if (moduleId == null) {
            return new StoreStatus(false, Arrays.asList(new InternalException((Throwable)new IllegalArgumentException(), "ModuleId is null", new Object[0])));
        }
        Map updatedSmartsModule = this.smartsModules.computeIfPresent(moduleId, (key, val) -> {
            val.computeIfPresent("SmartsModule", (partId, sm) -> IRecord.create(updateLambda.apply((SmartsModule)sm.getRecord()), (String)partId));
            return val;
        });
        if (updatedSmartsModule == null) {
            throw new RecordNotFoundException("SmartsModule id='" + moduleId + "'", new Object[0]);
        }
        return new StoreStatus(true, Collections.emptyList());
    }

    @Override
    public CompletableFuture<StoreStatus> applyAsync(String moduleId, Function<SmartsModule, SmartsModule> updateLambda) {
        return CompletableFuture.completedFuture(this.apply(moduleId, updateLambda));
    }

    @Override
    public SmartsModule getSmartsModulePart(String moduleId, String datasetId) {
        if (moduleId == null) {
            throw new IllegalArgumentException("ModuleId is null");
        }
        if (datasetId == null) {
            throw new IllegalArgumentException("datasetId is null");
        }
        Map<String, IRecord<SmartsModule>> smartsModule = this.smartsModules.get(moduleId);
        if (smartsModule == null) {
            return null;
        }
        IRecord<SmartsModule> smartsModulePart = smartsModule.get(datasetId);
        if (smartsModulePart == null) {
            return null;
        }
        return (SmartsModule)smartsModulePart.getRecord();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoreStatus apply(String moduleId, String datasetId, Function<DatasetInfo, DatasetInfo> updateLambda) {
        if (moduleId == null) {
            return new StoreStatus(false, Collections.singletonList(new InternalException((Throwable)new IllegalArgumentException(), "ModuleId is null", new Object[0])));
        }
        if (datasetId == null) {
            return new StoreStatus(false, Collections.singletonList(new InternalException((Throwable)new IllegalArgumentException(), "datasetId is null", new Object[0])));
        }
        if (this.smartsModules.containsKey(moduleId)) {
            IRecord<SmartsModule> part;
            Map<String, IRecord<SmartsModule>> smartsModuleRecordMap = this.smartsModules.get(moduleId);
            IRecord<SmartsModule> iRecord = part = smartsModuleRecordMap.get(datasetId);
            synchronized (iRecord) {
                DatasetInfo dataset = (DatasetInfo)((SmartsModule)part.getRecord()).getDatasets().remove(0);
                DatasetInfo newDataset = updateLambda.apply(dataset);
                try {
                    newDataset = (DatasetInfo)newDataset.clone();
                    ((SmartsModule)part.getRecord()).getDatasets().add(0, newDataset);
                }
                catch (CloneNotSupportedException e) {
                    LOGGER.error("Can not clone Dataset when update it", (Throwable)e);
                    return new StoreStatus(false, Collections.singletonList(new InternalException("Can not clone Dataset when update it", new Object[0])));
                }
            }
        }
        throw new RecordNotFoundException("SmartsModule id='" + moduleId + "'", new Object[0]);
        return new StoreStatus(true, Collections.emptyList());
    }

    @Override
    public CompletableFuture<StoreStatus> applyAsync(String moduleId, String datasetId, Function<DatasetInfo, DatasetInfo> updateLambda) {
        return CompletableFuture.completedFuture(this.apply(moduleId, datasetId, updateLambda));
    }
}

