/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.store.api.query;

import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.store.api.query.BoostedFieldSearch;
import com.ibm.smarts.store.api.query.FieldSearch;
import com.ibm.smarts.store.api.query.IFieldSearch;
import com.ibm.smarts.store.api.query.IStoreQuery;
import com.ibm.smarts.store.api.query.IStoreQueryBuilder;
import com.ibm.smarts.store.api.query.StoreQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class StoreQueryBuilder
implements IStoreQueryBuilder {
    private static final int DEFAULT_RESULT_COUNT = 10000;
    private int size = 10000;
    private float tieBreaker;
    private final List<IFieldSearch> searchFields = new ArrayList<IFieldSearch>();

    @Override
    public IStoreQueryBuilder setMaxReturnedDocs(int size) {
        if (size > 10000) {
            throw new InternalException("Size cannot be more than: {0}", new Object[]{10000});
        }
        this.size = size;
        return this;
    }

    @Override
    public IStoreQueryBuilder addFilter(String field, String ... filters) {
        if (ArrayUtils.isNotEmpty((Object[])filters)) {
            filters = (String[])Arrays.stream(filters).filter(StringUtils::isNotBlank).toArray(String[]::new);
            this.searchFields.add(new FieldSearch(field, filters, IFieldSearch.QueryType.FILTER));
        }
        return this;
    }

    @Override
    public IStoreQueryBuilder addQuery(String field, String query, float boost) {
        this.searchFields.add(new BoostedFieldSearch(field, query, IFieldSearch.QueryType.DIS_MAX, boost));
        return this;
    }

    @Override
    public IStoreQueryBuilder addQuery(String field, String query) {
        this.searchFields.add(new FieldSearch(field, query, IFieldSearch.QueryType.DIS_MAX));
        return this;
    }

    @Override
    public IStoreQuery build() {
        return new StoreQuery(this.searchFields, this.size, this.tieBreaker);
    }

    @Override
    public IStoreQueryBuilder setTieBreaker(float tieBreaker) {
        if (tieBreaker > 1.0f || tieBreaker < 0.0f) {
            throw new InternalException("tie breaker must be between 0 and 1", new Object[0]);
        }
        this.tieBreaker = tieBreaker;
        return this;
    }
}

