/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.provider;

import com.ibm.smarts.common.provider.IQueryItemStats;
import com.ibm.smarts.common.provider.ISampleData;
import com.ibm.smarts.common.provider.IValueIterator;
import com.ibm.smarts.common.provider.IValueTupleIterator;
import com.ibm.smarts.common.provider.QueryItemStats;
import com.ibm.smarts.model.dataset.DatasetData;
import com.ibm.smarts.model.dataset.DatasetDataItem;
import com.ibm.smarts.model.dataset.DatasetDataResult;
import com.ibm.smarts.model.dataset.DatasetItem;
import com.ibm.smarts.model.dataset.DatasetObject;
import com.ibm.smarts.model.value.StringValue;
import com.ibm.smarts.model.value.Value;
import com.ibm.smarts.model.value.ValueFactory;
import com.ibm.smarts.model.value.decor.ValueDecoration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class SampleData
implements ISampleData {
    private final String querySubjectId;
    private final String[] queryItemIds;
    private final QueryItemStats[] stats;
    private final List<Value[]> tuples = new ArrayList<Value[]>();
    private final Set<Value>[] distinctValues;
    private final List<ValueDecoration>[] valueDecorations;
    private final Map<String, Integer> indexOfQueryItems = new HashMap<String, Integer>();

    public static SampleData from(String querySubjectId, DatasetDataResult dataResult) {
        ArrayList queryItemIds = new ArrayList();
        List dataItems = dataResult.dataItems;
        dataItems.forEach(dataItem -> {
            String use = (String)((DatasetObject)dataItem.itemClass.h.get((int)0)).use;
            int index = use.lastIndexOf(46);
            String queryItemId = index != -1 && index != use.length() - 1 ? use.substring(index + 1, use.length()) : use;
            queryItemIds.add(queryItemId);
        });
        SampleData sample = new SampleData(querySubjectId, queryItemIds.toArray(new String[0]));
        List data = dataResult.data;
        int availableSamples = data.size();
        for (int rowIndex = 0; rowIndex < availableSamples; ++rowIndex) {
            ArrayList<Value> tuple = new ArrayList<Value>();
            List indices = ((DatasetData)data.get((int)rowIndex)).itemIndices;
            for (int columnIndex = 0; columnIndex < indices.size(); ++columnIndex) {
                Value value;
                int valueIndex = (Integer)indices.get(columnIndex);
                DatasetItem datasetItem = (DatasetItem)((DatasetDataItem)dataItems.get((int)columnIndex)).items.get(valueIndex);
                String use = (String)((DatasetObject)((DatasetDataItem)dataItems.get((int)columnIndex)).itemClass.h.get((int)0)).use;
                DatasetObject tabular = (DatasetObject)datasetItem.tabular.get(0);
                Object valueObject = tabular.display;
                if (valueObject == null && tabular.use instanceof Number) {
                    valueObject = tabular.use;
                }
                Object object = value = valueObject != null ? ValueFactory.create((Object)valueObject) : new StringValue();
                if (SampleData.isRowIdentifier(use)) continue;
                tuple.add(value);
                if (rowIndex != 0) continue;
                sample.indexOfQueryItems.put((String)queryItemIds.get(columnIndex), tuple.size() - 1);
            }
            sample.addSampleTuple(tuple.toArray(new Value[0]));
        }
        return sample;
    }

    private static boolean isRowIdentifier(String samplesResultUse) {
        return samplesResultUse.endsWith("_row_id");
    }

    public SampleData(String querySubjectId, String[] queryItemIds) {
        this.querySubjectId = querySubjectId;
        this.queryItemIds = queryItemIds;
        this.stats = new QueryItemStats[queryItemIds.length];
        this.distinctValues = new TreeSet[queryItemIds.length];
        this.valueDecorations = new ArrayList[queryItemIds.length];
        for (int i = 0; i < queryItemIds.length; ++i) {
            this.stats[i] = new QueryItemStats();
            this.distinctValues[i] = new TreeSet<Value>();
            this.valueDecorations[i] = new ArrayList<ValueDecoration>();
        }
    }

    @Override
    public int numQueryItems() {
        return this.queryItemIds.length;
    }

    @Override
    public String getQueryItemIdentifier(int queryItemIndex) {
        return this.queryItemIds[queryItemIndex];
    }

    @Override
    public int indexOfQueryItem(String queryItemId) {
        if (this.indexOfQueryItems.containsKey(queryItemId)) {
            return this.indexOfQueryItems.get(queryItemId);
        }
        return -1;
    }

    @Override
    public long numSamples() {
        return this.tuples.size();
    }

    @Override
    public IQueryItemStats getSampleStats(int queryItemIndex) {
        if (this.stats.length > queryItemIndex && queryItemIndex >= 0) {
            return this.stats[queryItemIndex];
        }
        return null;
    }

    @Override
    public IValueTupleIterator tupleIterator() {
        return new TupleIter();
    }

    @Override
    public IValueIterator valueIterator(int queryItemIndex) {
        return new ValueIter(queryItemIndex);
    }

    @Override
    public Set<Value> distinctValues(int queryItemIndex) {
        if (queryItemIndex >= 0 && queryItemIndex < this.distinctValues.length) {
            return Collections.unmodifiableSet(this.distinctValues[queryItemIndex]);
        }
        return Collections.unmodifiableSet(new TreeSet());
    }

    @Override
    public List<ValueDecoration> valueDecorations(int queryItemIndex) {
        return Collections.unmodifiableList(this.valueDecorations[queryItemIndex]);
    }

    public void addValueDecoration(int queryItemIndex, ValueDecoration valueDecoration) {
        if (queryItemIndex < this.valueDecorations.length) {
            this.valueDecorations[queryItemIndex].add(valueDecoration);
        }
    }

    public void addSampleTuple(Value[] tuple) {
        this.tuples.add(tuple);
        for (int i = 0; i < tuple.length; ++i) {
            Value v = tuple[i];
            QueryItemStats qiStats = this.stats[i];
            qiStats.setCount(qiStats.count() + 1L);
            if (v == null || v.isNull()) {
                qiStats.setNullCount(qiStats.nullCount() + 1L);
                continue;
            }
            if (!v.isOK() || !this.distinctValues[i].add(v)) continue;
            qiStats.setDistinctCount(this.distinctValues[i].size());
            if (qiStats.minValue() == null || v.compareTo((Object)qiStats.minValue()) < 0) {
                qiStats.setMinValue(v);
            }
            if (qiStats.maxValue() != null && v.compareTo((Object)qiStats.maxValue()) <= 0) continue;
            qiStats.setMaxValue(v);
        }
    }

    public void addDistinctValue(int dataItemIndex, Value value) {
        if (dataItemIndex < this.distinctValues.length) {
            this.distinctValues[dataItemIndex].add(value);
        }
    }

    public String[] getQueryItemIds() {
        return this.queryItemIds;
    }

    public Value[] getSampleValue(int tupleIndex) {
        return this.tuples.get(tupleIndex);
    }

    private final class ValueIter
    implements IValueIterator {
        private final int dataItemIndex;
        private Iterator<Value[]> source;

        public ValueIter(int dataItemIndex) {
            this.source = SampleData.this.tuples.iterator();
            this.dataItemIndex = dataItemIndex;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public Value next() {
            return this.source.next()[this.dataItemIndex];
        }

        @Override
        public void reset() {
            this.source = SampleData.this.tuples.iterator();
        }

        @Override
        public void close() {
        }
    }

    private final class TupleIter
    implements IValueTupleIterator {
        private Iterator<Value[]> source;

        private TupleIter() {
            this.source = SampleData.this.tuples.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public Value[] next() {
            return this.source.next();
        }

        @Override
        public void reset() {
            this.source = SampleData.this.tuples.iterator();
        }

        @Override
        public void close() {
        }
    }
}

