/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.ibm.smarts.core.exceptions.json.JsonDeserializeException;
import com.ibm.smarts.core.exceptions.json.JsonSerializeException;
import com.ibm.smarts.core.exceptions.xml.XmlDeserializeException;
import com.ibm.smarts.core.exceptions.xml.XmlSerializeException;
import com.ibm.smarts.schema.util.JAXBHelper;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.xml.bind.JAXBException;

public class CommonJAXBHelper {
    public static <T> String marshalToJSON(T obj) {
        try {
            return JAXBHelper.marshalToJSON(obj);
        }
        catch (Exception e) {
            throw new JsonSerializeException((Throwable)e, "marshal to json failed", new Object[]{obj});
        }
    }

    public static <T> String marshalToJSON(T obj, boolean pretty) {
        try {
            return JAXBHelper.marshalToJSON(obj, (boolean)pretty);
        }
        catch (Exception e) {
            throw new JsonSerializeException((Throwable)e, "marshal to json failed", new Object[]{obj});
        }
    }

    public static <T> String marshalAllToJSON(T obj, boolean pretty) {
        try {
            return JAXBHelper.marshalAllToJSON(obj, (boolean)pretty);
        }
        catch (Exception e) {
            throw new JsonSerializeException((Throwable)e, "marshal to json failed", new Object[]{obj});
        }
    }

    public static <T> void marshalAllToJSON(T obj, String fileName, boolean pretty) {
        try {
            JAXBHelper.marshalAllToJSON(obj, (String)fileName, (boolean)pretty);
        }
        catch (Exception e) {
            throw new JsonSerializeException((Throwable)e, "marshal to json failed", new Object[]{obj});
        }
    }

    public static <T> T unmarshalFromJSON(Class<T> clazz, String jsonSource) {
        try {
            return (T)JAXBHelper.unmarshalFromJSON(clazz, (String)jsonSource);
        }
        catch (Exception e) {
            throw new JsonDeserializeException((Throwable)e, "unmarshal from json failed", new Object[]{jsonSource, clazz});
        }
    }

    public static <T> T unmarshalFromJSON(Class<T> clazz, InputStream jsonSource) {
        try {
            return (T)JAXBHelper.unmarshalFromJSON(clazz, (InputStream)jsonSource);
        }
        catch (Exception e) {
            throw new JsonDeserializeException((Throwable)e, "unmarshal from json stream failed", new Object[]{jsonSource, clazz});
        }
    }

    public static <T> List<T> unmarshalListFromJSON(Class<T> clazz, String jsonSource) {
        try {
            return JAXBHelper.unmarshalListFromJSON(clazz, (String)jsonSource);
        }
        catch (Exception e) {
            throw new JsonDeserializeException((Throwable)e, "unmarshal from json failed", new Object[]{jsonSource, clazz});
        }
    }

    public static <T> T unmarshalFromXML(Class<T> clazz, InputStream xmlSource) {
        try {
            return (T)JAXBHelper.unmarshalFromXML(clazz, (InputStream)xmlSource);
        }
        catch (JAXBException e) {
            throw new XmlDeserializeException((Throwable)e, "unmarshal from xml stream failed", new Object[]{xmlSource, clazz});
        }
    }

    public static <T> void marshalToXML(Class<T> clazz, T obj, OutputStream os) {
        try {
            JAXBHelper.marshalToXML(clazz, obj, (OutputStream)os);
        }
        catch (JAXBException e) {
            throw new XmlSerializeException((Throwable)e, "marshal to xml stream failed", new Object[]{obj, os, clazz});
        }
    }

    public static <T> JsonNode toJsonNode(T obj) {
        try {
            return JAXBHelper.toJsonNode(obj);
        }
        catch (Throwable e) {
            throw new JsonSerializeException(e, "marshal to JsonNode failed", new Object[]{obj});
        }
    }

    public static <T> T parseJson(Class<T> klass, JsonNode jn) {
        try {
            return (T)JAXBHelper.parseJson(klass, (JsonNode)jn);
        }
        catch (Exception e) {
            throw new JsonDeserializeException((Throwable)e, "unmarshal from JsonNode failed", new Object[]{jn, klass});
        }
    }

    public static JsonNode toJsonNode(String json) {
        try {
            return JAXBHelper.toJsonNode((String)json);
        }
        catch (Exception e) {
            throw new JsonDeserializeException((Throwable)e, "unmarshal to JsonNode failed", new Object[]{json});
        }
    }

    public static <T> void marshalToJSON(T obj, OutputStream jsonOut) {
        try {
            JAXBHelper.marshalToJSON(obj, (OutputStream)jsonOut);
        }
        catch (Exception e) {
            throw new JsonSerializeException((Throwable)e, "marshal to json stream failed", new Object[]{jsonOut, obj});
        }
    }
}

