/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.util;

import com.ibm.bi.platform.moser.common.generated.metadata.BaseQueryItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Calculation;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.utils.ReferenceResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MoserModuleUtil {
    public static Module getShrinkedModuleByColumnIds(Module module, List<String> columnIds) {
        if (module == null || columnIds == null || columnIds.isEmpty()) {
            return module;
        }
        List qsList = module.getQuerySubject();
        List<Calculation> calcList = module.getCalculation();
        if (qsList.isEmpty() && calcList.isEmpty()) {
            return module;
        }
        HashMap<String, QuerySubject> qsMap = new HashMap<String, QuerySubject>();
        for (QuerySubject qs : qsList) {
            List baseQis = ReferenceResolver.getQueryItemListByIdExprListAndQuerySubject(columnIds, (QuerySubject)qs, (boolean)true);
            if (baseQis == null || baseQis.isEmpty()) continue;
            qsMap.put(qs.getIdForExpression() == null ? qs.getIdentifier() : qs.getIdForExpression(), qs);
            for (int i = 0; i < baseQis.size(); ++i) {
                columnIds.remove(((BaseQueryItemType)baseQis.get(i)).getIdForExpression());
            }
        }
        if (!columnIds.isEmpty()) {
            calcList = MoserModuleUtil.getCalculationById(columnIds, module.getCalculation());
        }
        if (qsMap.isEmpty() && calcList.isEmpty()) {
            columnIds.clear();
            return module;
        }
        Module newModule = new Module();
        newModule.setIdentifier(module.getIdentifier());
        newModule.setLabel(module.getLabel());
        newModule.setContainer(module.getContainer());
        newModule.setExpressionLocale(module.getExpressionLocale());
        newModule.setDataRetrievalMode(module.getDataRetrievalMode());
        newModule.getQuerySubject().addAll(qsMap.values());
        newModule.getCalculation().addAll(calcList);
        return newModule;
    }

    private static List<Calculation> getCalculationById(List<String> columnIds, List<Calculation> calcList) {
        ArrayList<Calculation> calcMap = new ArrayList<Calculation>();
        if (!calcList.isEmpty()) {
            block0: for (Calculation calc : calcList) {
                for (int i = columnIds.size() - 1; i >= 0; --i) {
                    String idForExpression = columnIds.get(i);
                    if (!idForExpression.equals(calc.getIdentifier()) && !idForExpression.equals(calc.getIdForExpression())) continue;
                    calcMap.add(calc);
                    columnIds.remove(i);
                    continue block0;
                }
            }
        }
        return calcMap;
    }
}

