/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.semanticsearch.impl;

import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.ontology.registry.util.ConceptsUtil;
import com.ibm.smarts.qa.api.SemanticAnnotation;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.DataClue;
import com.ibm.smarts.schema.Feature;
import com.ibm.smarts.schema.MatchedEntity;
import com.ibm.smarts.schema.PhraseInfo;
import com.ibm.smarts.schema.SemanticSearchResult;
import com.ibm.smarts.schema.TimeEntity;
import com.ibm.smarts.schema.TokenInfo;
import com.ibm.smarts.schema.util.OntologyCommon;
import com.ibm.smarts.semanticsearch.impl.AbstractSemanticSearchHandler;
import com.ibm.smarts.semanticsearch.impl.NamedEntityRecognizer;
import com.ibm.smarts.semanticsearch.impl.SemanticQueryType;
import com.ibm.smarts.semanticsearch.impl.SemanticSearchContext;
import com.ibm.smarts.semanticsearch.util.SemanticSearchHelper;
import com.ibm.smarts.store.api.provider.IDataClueStore;
import com.ibm.smarts.store.api.provider.IFeatureStore;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import com.ibm.smarts.store.api.query.IRecordResult;
import com.ibm.smarts.store.api.query.IStoreQuery;
import com.ibm.smarts.store.api.query.IStoreQueryBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeepSemanticSearchHandler
extends AbstractSemanticSearchHandler {
    private static final String DASH = "-";
    private static final String YEAR_CONCEPT = "Year";
    private static final String VALUE_FIELD = "value";
    private static final String ONTOLOGYID_FIELD = "ontologyID";
    private static final float CONFIDENCE_THRESHOLD = 0.6f;
    private static final Logger LOGGER = LoggerFactory.getLogger(DeepSemanticSearchHandler.class);
    private static final int MAX_SEARCH_RESULTS = 500;

    public DeepSemanticSearchHandler(IStoreProvider aStoreProvider) {
        super(aStoreProvider);
    }

    public SemanticSearchResult search(SemanticSearchContext ssc) {
        IFeatureStore featureStore = this.storeProvider.getFeatureStore(ssc.getReqCtx());
        NamedEntityRecognizer.analyze(this.queryFeature(ssc, featureStore), ssc, SemanticQueryType.ORIG);
        NamedEntityRecognizer.analyze(this.expandedQueryFeature(ssc, featureStore), ssc, SemanticQueryType.EXPAND);
        this.expandSearchByLexicalClue(ssc, featureStore);
        if (ssc.isInDataValue()) {
            this.annotateValueInQuestion(ssc);
            if (!ssc.getMatchedValues().isEmpty()) {
                NamedEntityRecognizer.analyze(this.valueQueryFeature(ssc, featureStore), ssc, SemanticQueryType.VALUE);
            }
        }
        return this.getSearchResult(NamedEntityRecognizer.ensemble(ssc), ssc);
    }

    void annotateValueInQuestion(SemanticSearchContext ssc) {
        IDataClueStore dataClueStore = this.storeProvider.getDataClueStore(ssc.getReqCtx());
        IStoreQuery query = this.buildValueQuery(dataClueStore, ssc.getQuestion());
        List hits = dataClueStore.executeSearch(query);
        if (LOGGER.isDebugEnabled()) {
            StringBuilder sbd = new StringBuilder().append(String.format("search in dataClue with query: [%s]", ssc.getQuestion()));
            for (IRecordResult h2 : hits) {
                sbd.append(String.format("\n[Score: %s | ID: %s]\n", Float.valueOf(h2.getScore()), h2.getRecord().getId()));
                sbd.append(CommonJAXBHelper.marshalToJSON((Object)h2.getRecord().getRecord(), (boolean)true));
            }
            LOGGER.debug("\n" + sbd.toString());
        }
        String questionUC = ssc.getQuestion().toUpperCase(ssc.getReqCtx().locale);
        if (!(hits = hits.stream().filter(h -> !((DataClue)h.getRecord().getRecord()).getConceptID().equals("http://www.ibm.com/ontologies/waca/application#Boolean")).filter(h -> questionUC.contains(((DataClue)h.getRecord().getRecord()).getValueUC())).collect(Collectors.toList())).isEmpty()) {
            for (IRecordResult hit : hits) {
                int start = ssc.getQuestion().indexOf(((DataClue)hit.getRecord().getRecord()).getValue());
                int end = -1;
                if (start < 0) {
                    start = questionUC.indexOf(((DataClue)hit.getRecord().getRecord()).getValueUC());
                }
                end = start + ((DataClue)hit.getRecord().getRecord()).getValue().length();
                String value = ssc.getQuestion().substring(start, end);
                String conceptLabel = ((DataClue)hit.getRecord().getRecord()).getConceptID().replace("http://www.ibm.com/ontologies/waca/domain/common#", "");
                if (!this.isValidBoundary(start, end, ssc)) continue;
                ssc.addMatchedValue(start, end, value, conceptLabel);
            }
        }
        this.annotateTimeInQuestion(ssc);
        ssc.getMatchedValues().values().forEach(v -> LOGGER.info(v.toString()));
    }

    boolean isValidBoundary(int start, int end, SemanticSearchContext ssc) {
        int tokenBegin = -1;
        int tokenEnd = -1;
        List<TokenInfo> tokens = ssc.getTokens();
        for (int i = 0; i < tokens.size(); ++i) {
            if (tokens.get(i).getCharOffsetBegin() == start) {
                tokenBegin = i;
            }
            if (tokens.get(i).getCharOffsetEnd() == end && tokenBegin >= 0 && i >= tokenBegin) {
                tokenEnd = i;
            }
            if (tokenBegin >= 0 && tokenEnd >= 0) break;
        }
        return tokenBegin >= 0 && tokenEnd >= 0;
    }

    private void annotateTimeInQuestion(SemanticSearchContext ssc) {
        ssc.getIUs().stream().flatMap(iu -> iu.getPhraseInfo().getEntities().stream()).filter(me -> Objects.nonNull(me.getTimeEntity())).forEach(me -> {
            TimeEntity te = me.getTimeEntity();
            if (StringUtils.isNotBlank((CharSequence)me.getTimeEntity().getValue())) {
                String[] values = te.getValue().split(DASH);
                String yearValue = values[0];
                ssc.getTokens().subList(me.getTokenBegin(), me.getTokenEnd()).stream().filter(t -> t.getText().equals(yearValue)).findFirst().ifPresent(t -> ssc.addMatchedValue(t.getCharOffsetBegin(), t.getCharOffsetEnd(), t.getText(), YEAR_CONCEPT));
            }
        });
    }

    private IStoreQuery buildValueQuery(IDataClueStore dataClueStore, String question) {
        question = question.replaceAll("\\.", " ").replaceAll(",", " ");
        IStoreQueryBuilder queryBuilder = dataClueStore.getQueryBuilder().addQuery(VALUE_FIELD, question);
        queryBuilder.addFilter(ONTOLOGYID_FIELD, new String[]{"http://www.ibm.com/ontologies/waca/domain/common"});
        return queryBuilder.build();
    }

    private SemanticSearchResult getSearchResult(List<MatchedEntity> entities, SemanticSearchContext ssc) {
        SemanticSearchResult result = new SemanticSearchResult();
        result.getMatchedEntity().addAll(entities);
        ssc.dispose();
        return result;
    }

    private void expandSearchByLexicalClue(SemanticSearchContext ssc, IFeatureStore featureStore) {
        HashMap conceptQueryCache = new HashMap();
        ssc.getInterpretation().getUnits().stream().flatMap(iu -> iu.getSemanticAnnotations().stream()).forEach(sa -> {
            ConceptInfo concept = this.getAcceptableConcets((SemanticAnnotation)sa);
            if (null != concept) {
                List featureHits = (List)conceptQueryCache.get(concept.getConceptID());
                if (featureHits == null) {
                    String conceptName = ConceptsUtil.getConceptName((ConceptInfo)concept);
                    IStoreQuery query = SemanticSearchHelper.buildQuery(ssc.getReqCtx(), featureStore, conceptName, ssc.getAssetTypes(), ssc.isInDataValue(), SemanticQueryType.CONCEPT, ssc.getAssetRefs());
                    featureHits = featureStore.executeSearch(query);
                    SemanticSearchHelper.debugRawFeatureHits(featureHits, LOGGER, String.format("querySearch by concept: [%s] tagged to token: [%s]", conceptName, sa.getPhraseInfo().getText()));
                    conceptQueryCache.put(concept.getConceptID(), featureHits);
                }
                if (featureHits != null) {
                    NamedEntityRecognizer.analyzeLexicalClueQueryResults(featureHits, concept, sa.getPhraseInfo(), ssc, SemanticQueryType.CONCEPT);
                }
            }
        });
    }

    private ConceptInfo getAcceptableConcets(SemanticAnnotation sa) {
        Optional<ConceptInfo> concept;
        if (!sa.getConcepts().isEmpty() && (concept = sa.getConcepts().stream().filter(c -> !"http://www.ibm.com/ontologies/waca/application".equals(ConceptsUtil.getOntologyId((ConceptInfo)c))).filter(c -> Float.compare(c.getConfidence(), 0.6f) > 0).filter(c -> !OntologyCommon.getUnsearcableConceptShortNames().contains(ConceptsUtil.getConceptName((ConceptInfo)c))).filter(c -> !((TokenInfo)sa.getPhraseInfo().getTokens().get(0)).getText().equalsIgnoreCase(ConceptsUtil.getConceptName((ConceptInfo)c))).filter(c -> !((TokenInfo)sa.getPhraseInfo().getTokens().get(0)).getLemma().equalsIgnoreCase(ConceptsUtil.getConceptName((ConceptInfo)c))).sorted(Comparator.comparing(ConceptInfo::getConfidence).reversed()).findFirst()).isPresent()) {
            return concept.get();
        }
        return null;
    }

    private List<IRecordResult<Feature>> queryFeature(SemanticSearchContext ssc, IFeatureStore featureStore) {
        IStoreQuery query = SemanticSearchHelper.buildQuery(ssc.getReqCtx(), featureStore, ssc.getQuestion(), ssc.getAssetTypes(), ssc.isInDataValue(), SemanticQueryType.ORIG, ssc.getAssetRefs());
        List featureHits = featureStore.executeSearch(query);
        SemanticSearchHelper.debugRawFeatureHits(featureHits, LOGGER, String.format("querySearch with query: [%s]", ssc.getQuestion()));
        this.appendQueryByAssetRefsHitsIfInDataValue(featureHits, ssc, featureStore, ssc.getQuestion());
        return featureHits;
    }

    private List<IRecordResult<Feature>> valueQueryFeature(SemanticSearchContext ssc, IFeatureStore featureStore) {
        String question = ssc.getMatchedValues().values().stream().map(SemanticSearchContext.MatchedValue::getConcept).distinct().collect(Collectors.joining(" "));
        LOGGER.info("value to question ==> " + question);
        if (StringUtils.isBlank((CharSequence)question)) {
            return Collections.emptyList();
        }
        IStoreQuery query = SemanticSearchHelper.buildQuery(ssc.getReqCtx(), featureStore, question, ssc.getAssetTypes(), ssc.isInDataValue(), SemanticQueryType.VALUE, ssc.getAssetRefs());
        List featureHits = featureStore.executeSearch(query);
        SemanticSearchHelper.debugRawFeatureHits(featureHits, LOGGER, String.format("querySearch with query: [%s]", ssc.getQuestion()));
        return featureHits;
    }

    private List<IRecordResult<Feature>> expandedQueryFeature(SemanticSearchContext ssc, IFeatureStore featureStore) {
        String queryString = this.expandQuery(ssc);
        LOGGER.info("Expanded query: " + queryString);
        if (!StringUtils.isBlank((CharSequence)queryString) && !queryString.equals(ssc.getQuestion())) {
            IStoreQuery query = SemanticSearchHelper.buildQuery(ssc.getReqCtx(), featureStore, queryString, ssc.getAssetTypes(), ssc.isInDataValue(), SemanticQueryType.EXPAND, ssc.getAssetRefs());
            List featureHits = featureStore.executeSearch(query);
            SemanticSearchHelper.debugRawFeatureHits(featureHits, LOGGER, String.format("expandedQuerySearch with query: [%s]", queryString));
            this.appendQueryByAssetRefsHitsIfInDataValue(featureHits, ssc, featureStore, queryString);
            return featureHits;
        }
        return new ArrayList<IRecordResult<Feature>>(0);
    }

    protected void appendQueryByAssetRefsHitsIfInDataValue(List<IRecordResult<Feature>> featureHits, SemanticSearchContext ssc, IFeatureStore featureStore, String queryString) {
        if (ssc.isInDataValue() && featureHits.size() == 500 && ArrayUtils.isNotEmpty((Object[])ssc.getAssetRefs())) {
            IStoreQueryBuilder queryBuilder = SemanticSearchHelper.featureQueryBuilder(ssc.getReqCtx(), featureStore, queryString, ssc.getAssetTypes());
            SemanticSearchHelper.applyAssetRefFilter(ssc.getAssetRefs(), queryBuilder);
            List filteredFeatureHits = featureStore.executeSearch(queryBuilder.build());
            SemanticSearchHelper.debugRawFeatureHits(filteredFeatureHits, LOGGER, String.format("querySearch with query: [%s]", queryString));
            List uniqueHits = filteredFeatureHits.stream().filter(filtered -> !featureHits.stream().anyMatch(unFiltered -> unFiltered.getRecord().getId().equals(filtered.getRecord().getId()))).collect(Collectors.toList());
            featureHits.addAll(uniqueHits);
        }
    }

    String expandQuery(SemanticSearchContext ssc) {
        ArrayList words = new ArrayList();
        ssc.getIUs().stream().forEach(iu -> {
            PhraseInfo phrase = iu.getPhraseInfo();
            words.add(phrase.getText());
            String phraseTextLC = phrase.getText().toLowerCase(ssc.getReqCtx().locale);
            this.addTokensIfRequired(words, phraseTextLC, phrase, ssc.getReqCtx());
            this.addLemmaIfRquired(words, phrase);
        });
        return words.stream().reduce("", (s1, s2) -> String.join((CharSequence)" ", s1, s2)).trim();
    }

    private void addLemmaIfRquired(List<String> words, PhraseInfo phrase) {
        phrase.getTokens().stream().filter(t -> !t.getText().equalsIgnoreCase(t.getLemma())).forEach(t -> words.add(t.getLemma()));
    }

    private void addTokensIfRequired(List<String> words, String phraseTextLC, PhraseInfo phrase, RequestContext reqCtx) {
        phrase.getTokens().stream().filter(t -> !phraseTextLC.contains(t.getText().toLowerCase(reqCtx.locale))).forEach(t -> words.add(t.getText()));
    }
}

