/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.semanticsearch.impl;

import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.nlp.api.grammar.PartOfSpeech;
import com.ibm.smarts.nlp.api.grammar.SimplePartOfSpeech;
import com.ibm.smarts.ontology.registry.util.ConceptsUtil;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.Feature;
import com.ibm.smarts.schema.FeatureType;
import com.ibm.smarts.schema.MatchReason;
import com.ibm.smarts.schema.MatchedEntity;
import com.ibm.smarts.schema.MatchedFeature;
import com.ibm.smarts.schema.PhraseInfo;
import com.ibm.smarts.schema.TextInfo;
import com.ibm.smarts.schema.TokenInfo;
import com.ibm.smarts.schema.util.OntologyCommon;
import com.ibm.smarts.semanticsearch.impl.SemanticQueryType;
import com.ibm.smarts.semanticsearch.impl.SemanticSearchContext;
import com.ibm.smarts.semanticsearch.util.SemanticHelper;
import com.ibm.smarts.store.api.query.IRecordResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedEntityRecognizer {
    private static final float E = 1.0E-4f;
    private static final float LOW_HIT_THRESHOLD = 0.01f;
    private static final float CONCEPT_QUERY_FACTOR = 0.4f;
    private static final double ALPHA = -1.5;
    private static final String PLURAL_S = "s";
    private static final List<String> NON_WHITESPACE_BOUND_LOCALES = Arrays.asList("zh", "ja");
    private static final List<String> STOP_WORD_POS = Arrays.asList(PartOfSpeech.CD.name(), PartOfSpeech.CC.name());
    private static final List<String> TRIVIAL_TOKEN = Arrays.asList(SimplePartOfSpeech.punctuation.name());
    private static final Logger LOGGER = LoggerFactory.getLogger(NamedEntityRecognizer.class);

    private NamedEntityRecognizer() {
    }

    static void analyze(List<IRecordResult<Feature>> featureHits, SemanticSearchContext ssc, SemanticQueryType queryType) {
        switch (queryType) {
            case ORIG: {
                NamedEntityRecognizer.analyzeQueryResults(featureHits, ssc);
                break;
            }
            case EXPAND: {
                NamedEntityRecognizer.analyzeExpandedQueryResults(featureHits, ssc);
                break;
            }
            case VALUE: {
                NamedEntityRecognizer.analyzeValueQueryResults(featureHits, ssc);
                break;
            }
            default: {
                throw new RuntimeException("Unknown SemanticQueryType");
            }
        }
    }

    static void analyzeLexicalClueQueryResults(List<IRecordResult<Feature>> featureHits, ConceptInfo concept, PhraseInfo pi, SemanticSearchContext ssc, SemanticQueryType queryType) {
        featureHits.stream().filter(hit -> ssc.isNewHit((IRecordResult<Feature>)hit)).forEach(hit -> {
            MatchedFeature aMatch = NamedEntityRecognizer.convertToMatchedFeature((IRecordResult<Feature>)hit);
            aMatch.setScore(concept.getConfidence() * 0.4f * aMatch.getScore());
            aMatch.setMatchReason(MatchReason.PARTIAL_CONCEPT);
            SemanticSearchContext.MatchedEntityCandidate candidate = new SemanticSearchContext.MatchedEntityCandidate();
            candidate.getMatchedFeatures().add(aMatch);
            candidate.setSimilarityScore(aMatch.getScore());
            candidate.setCharOffsetBegin(((TokenInfo)pi.getTokens().get(0)).getCharOffsetBegin());
            candidate.setCharOffsetEnd(((TokenInfo)pi.getTokens().get(pi.getTokens().size() - 1)).getCharOffsetEnd());
            candidate.setCoveredText(ssc.getQuestion().substring(candidate.getCharOffsetBegin(), candidate.getCharOffsetEnd()));
            List<TokenInfo> tokens = ssc.getTokens();
            for (int i = 0; i < tokens.size(); ++i) {
                if (tokens.get(i).getCharOffsetBegin() != candidate.getCharOffsetBegin()) continue;
                candidate.setTokenBegin(i);
                candidate.setTokenEnd(i);
                break;
            }
            ssc.addMatchedEntityCandiate(candidate);
            ssc.cacheRawSearchResult((IRecordResult<Feature>)hit);
            LOGGER.info("set to concept match of column [{}] by concept [{}] with clue [{}]", new Object[]{aMatch.getFeature().getFeatureKey(), ConceptsUtil.getConceptName((ConceptInfo)concept), pi.getText()});
        });
    }

    private static void analyzeValueQueryResults(List<IRecordResult<Feature>> featureHits, SemanticSearchContext ssc) {
        featureHits.stream().forEach(hit -> {
            MatchedFeature aMatch = NamedEntityRecognizer.convertToMatchedFeature((IRecordResult<Feature>)hit);
            ssc.getMatchedValues().values().forEach(v -> {
                if (aMatch.getFeature().getSearchableConcepts().contains(v.getConcept())) {
                    SemanticSearchContext.MatchedEntityCandidate candidate = new SemanticSearchContext.MatchedEntityCandidate();
                    candidate.getMatchedFeatures().add(aMatch);
                    aMatch.setMatchReason(MatchReason.DATA_VALUE);
                    candidate.setSimilarityScore(aMatch.getScore());
                    candidate.setCharOffsetBegin(v.getStart());
                    candidate.setCharOffsetEnd(v.getEnd());
                    candidate.setCoveredText(v.getValue());
                    if (NamedEntityRecognizer.valueTokenOffsetResolution(candidate, ssc)) {
                        ssc.addMatchedEntityCandiate(candidate);
                        LOGGER.info("set to value match of column [{}] Value [{}] Question: [{}] ", new Object[]{aMatch.getFeature().getFeatureKey(), v.getValue(), ssc.getQuestion()});
                    }
                }
            });
        });
    }

    private static boolean matchedFirstConcept(List<String> concepts, List<String> conceptsLC, IRecordResult<Feature> hit) {
        ColumnInfo col;
        Optional<ConceptInfo> concept;
        Feature ft = (Feature)hit.getRecord().getRecord();
        if (conceptsLC.stream().anyMatch(cl -> ft.getFeatureKeyLC().contains((CharSequence)cl))) {
            return true;
        }
        if (ft.getFeatureType() == FeatureType.COLUMN_NAME && ft.getColumnInfo() != null && (concept = (col = (ColumnInfo)CommonJAXBHelper.unmarshalFromJSON(ColumnInfo.class, (String)ft.getColumnInfo())).getSemanticInfo().getConcepts().stream().filter(c -> ConceptsUtil.getOntologyId((ConceptInfo)c).equals("http://www.ibm.com/ontologies/waca/domain/common")).filter(c -> !OntologyCommon.getUnsearcableConceptShortNames().contains(ConceptsUtil.getConceptName((ConceptInfo)c))).sorted(Comparator.comparing(ConceptInfo::getConfidence).reversed()).findFirst()).isPresent()) {
            String conceptName = ConceptsUtil.getConceptName((ConceptInfo)concept.get());
            return concepts.contains(conceptName);
        }
        return false;
    }

    private static boolean valueTokenOffsetResolution(MatchedEntity entity, SemanticSearchContext ssc) {
        boolean beginSet = false;
        boolean endSet = false;
        List<TokenInfo> tokens = ssc.getTokens();
        for (int i = 0; i < tokens.size(); ++i) {
            if (tokens.get(i).getCharOffsetBegin() == entity.getCharOffsetBegin()) {
                entity.setTokenBegin(i);
                beginSet = true;
            }
            if (tokens.get(i).getCharOffsetEnd() == entity.getCharOffsetEnd()) {
                entity.setTokenEnd(i);
                if (entity.getTokenEnd() >= entity.getTokenBegin()) {
                    endSet = true;
                }
            }
            if (beginSet && endSet) break;
        }
        return beginSet && endSet;
    }

    private static List<IRecordResult<Feature>> customSort(List<IRecordResult<Feature>> featureHits) {
        return featureHits.stream().sorted(Comparator.comparing(f -> Float.valueOf(f.getScore())).reversed().thenComparing(f -> ((Feature)f.getRecord().getRecord()).getFeatureKey().length())).collect(Collectors.toList());
    }

    private static void analyzeQueryResults(List<IRecordResult<Feature>> featureHits, SemanticSearchContext ssc) {
        featureHits.stream().forEach(hit -> {
            MatchedFeature aMatch = NamedEntityRecognizer.convertToMatchedFeature((IRecordResult<Feature>)hit);
            if (!NamedEntityRecognizer.fullMatchEpoch(aMatch, ssc)) {
                NamedEntityRecognizer.partialMatchEpoch(aMatch, ssc);
            }
        });
        ssc.cacheRawSearchResults(featureHits);
    }

    private static void analyzeExpandedQueryResults(List<IRecordResult<Feature>> featureHits, SemanticSearchContext ssc) {
        featureHits.stream().filter(hit -> ssc.isNewHit((IRecordResult<Feature>)hit)).forEach(hit -> {
            MatchedFeature aMatch = NamedEntityRecognizer.convertToMatchedFeature((IRecordResult<Feature>)hit);
            NamedEntityRecognizer.partialMatchEpoch(aMatch, ssc);
            ssc.cacheRawSearchResult((IRecordResult<Feature>)hit);
        });
    }

    private static List<IRecordResult<Feature>> pruneTrailingHits(List<IRecordResult<Feature>> hits) {
        int pt;
        hits.forEach(h -> LOGGER.debug(Float.toString(h.getScore())));
        if (hits.size() <= 1 || NamedEntityRecognizer.allLowHit(hits)) {
            return hits;
        }
        float mean = hits.stream().collect(Collectors.averagingDouble(IRecordResult::getScore)).floatValue();
        double sgm = Math.sqrt(hits.stream().map(h -> Math.pow(h.getScore() - mean, 2.0)).mapToDouble(Double::doubleValue).sum() / (double)hits.size());
        if (Math.abs(sgm - 0.0) < (double)1.0E-4f) {
            sgm = 1.0E-4f;
        }
        double sigma = sgm;
        List<Pair> p = hits.stream().map(h -> {
            double z = (double)(h.getScore() - mean) / sigma;
            return new ImmutablePair(h, (Object)z);
        }).collect(Collectors.toList());
        p.forEach(h -> LOGGER.debug(((Double)h.getRight()).toString()));
        for (pt = 1; pt < p.size() && (Double.compare((Double)((Pair)p.get(pt)).getRight(), -1.5) >= 0 || NamedEntityRecognizer.isSingleToken((Feature)((IRecordResult)((Pair)p.get(pt)).getKey()).getRecord().getRecord())); ++pt) {
        }
        List<IRecordResult<Feature>> toKeep = p.subList(0, pt).stream().map(Pair::getLeft).collect(Collectors.toList());
        float threshold = Math.max(hits.get(0).getScore() / 10.0f, 0.01f);
        toKeep.removeIf(h -> Float.compare(h.getScore(), threshold) < 0);
        toKeep.forEach(h -> LOGGER.debug(Float.toString(h.getScore())));
        return toKeep;
    }

    private static boolean isSingleToken(Feature f) {
        Optional<TextInfo> textInfo = NamedEntityRecognizer.unmarshalFeatureTextInfo(f);
        if (textInfo.isPresent()) {
            List colTokens = ((PhraseInfo)textInfo.get().getPhrases().get(0)).getTokens();
            return colTokens.size() == 1;
        }
        return false;
    }

    private static boolean allLowHit(List<IRecordResult<Feature>> hits) {
        return hits.stream().allMatch(h -> Float.compare(h.getScore(), 0.01f) < 0);
    }

    private static void partialMatchEpoch(MatchedFeature aMatch, SemanticSearchContext ssc) {
        boolean isConceptMatch;
        SemanticSearchContext.MatchedEntityCandidate candidate = new SemanticSearchContext.MatchedEntityCandidate();
        candidate.getMatchedFeatures().add(aMatch);
        LOGGER.info("set to partial match of column [{}] Question: [{}] ", (Object)aMatch.getFeature().getFeatureKey(), (Object)ssc.getQuestion());
        boolean matchedText = NamedEntityRecognizer.computeBestMatches(NamedEntityRecognizer.buildMatchMatrix(ssc, aMatch), candidate, ssc);
        if (!matchedText && (isConceptMatch = NamedEntityRecognizer.conceptTokenOffsetResolution(candidate, ssc))) {
            aMatch.setMatchReason(MatchReason.PARTIAL_CONCEPT);
            candidate.setSimilarityScore(aMatch.getScore());
            candidate.setCharOffsetBegin(ssc.getTokens().get(candidate.getTokenBegin()).getCharOffsetBegin());
            candidate.setCharOffsetEnd(ssc.getTokens().get(candidate.getTokenEnd()).getCharOffsetEnd());
            candidate.setCoveredText(ssc.getQuestion().substring(candidate.getCharOffsetBegin(), candidate.getCharOffsetEnd()));
            ssc.addMatchedEntityCandiate(candidate);
            LOGGER.info("set to concept match of column [{}] Question: [{}] ", (Object)aMatch.getFeature().getFeatureKey(), (Object)ssc.getQuestion());
        }
    }

    private static Map<Integer, List<Pair<Integer, MatchReason>>> buildMatchMatrix(SemanticSearchContext ssc, MatchedFeature aMatch) {
        HashMap<Integer, List<Pair<Integer, MatchReason>>> matrix = new HashMap<Integer, List<Pair<Integer, MatchReason>>>();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(aMatch.getFeature().getFeatureKey() + " " + aMatch.getFeature().getFeatureType());
        }
        boolean matched = false;
        Optional<TextInfo> textInfo = NamedEntityRecognizer.unmarshalFeatureTextInfo(aMatch.getFeature());
        if (textInfo.isPresent()) {
            int j;
            ArrayList<ImmutablePair> matches;
            int i;
            List featureTokens = ((PhraseInfo)textInfo.get().getPhrases().get(0)).getTokens();
            for (i = 0; i < featureTokens.size(); ++i) {
                matches = new ArrayList<ImmutablePair>();
                for (j = 0; j < ssc.getTokens().size(); ++j) {
                    MatchReason reason = MatchReason.NOT_MATCH;
                    try {
                        if (((TokenInfo)featureTokens.get(i)).getText().equalsIgnoreCase(ssc.getTokens().get(j).getText())) {
                            reason = MatchReason.PARTIAL_NAME;
                            matched = true;
                        } else if (((TokenInfo)featureTokens.get(i)).getLemma().equalsIgnoreCase(ssc.getTokens().get(j).getLemma())) {
                            reason = MatchReason.PARTIAL_LEMMA;
                            matched = true;
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn("The hit [{}] from [{}] has to be discarded because of invalid lexical information in smarts module", (Object)aMatch.getFeature().getFeatureKey(), (Object)aMatch.getFeature().getAssetRef());
                    }
                    if (reason == MatchReason.NOT_MATCH) continue;
                    ImmutablePair match = new ImmutablePair((Object)j, (Object)reason);
                    matches.add(match);
                }
                if (matches.isEmpty()) continue;
                matrix.put(i, matches);
            }
            if (!matched) {
                for (i = 0; i < featureTokens.size(); ++i) {
                    matches = new ArrayList();
                    for (j = 0; j < ssc.getTokens().size(); ++j) {
                        if (((TokenInfo)featureTokens.get(i)).getSignificance() < 5 || ssc.getTokens().get(j).getSignificance() < 5 || !ssc.getTokens().get(j).getText().equalsIgnoreCase(((TokenInfo)featureTokens.get(i)).getText().concat(PLURAL_S))) continue;
                        ImmutablePair match = new ImmutablePair((Object)j, (Object)MatchReason.PARTIAL_NAME);
                        matches.add(match);
                    }
                    if (matches.isEmpty()) continue;
                    matrix.put(i, matches);
                }
            }
        }
        return matrix;
    }

    private static Optional<ColumnInfo> unmarshalColumn(Feature feature) {
        ColumnInfo col = null;
        try {
            if (feature.getFeatureType() == FeatureType.COLUMN_NAME && feature.getColumnInfo() != null) {
                col = (ColumnInfo)CommonJAXBHelper.unmarshalFromJSON(ColumnInfo.class, (String)feature.getColumnInfo());
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Unable to unmarshal the column for " + feature.getFeatureKey());
        }
        return Optional.ofNullable(col);
    }

    private static Optional<TextInfo> unmarshalFeatureTextInfo(Feature feature) {
        TextInfo textInfo = null;
        try {
            if (feature.getFeatureTextInfo() != null) {
                textInfo = (TextInfo)CommonJAXBHelper.unmarshalFromJSON(TextInfo.class, (String)feature.getFeatureTextInfo());
            }
        }
        catch (Exception ex) {
            LOGGER.warn(String.format("Unable to unmarshal featureTextInfo for feature [%s] with type [%s]", feature.getFeatureKey(), feature.getFeatureType()));
        }
        return Optional.ofNullable(textInfo);
    }

    protected static boolean hasMatchedByConcept(Feature feature, TokenInfo t) {
        if (feature.getSearchableConcepts().isEmpty()) {
            return false;
        }
        List conceptsLC = feature.getSearchableConcepts().stream().map(String::toLowerCase).collect(Collectors.toList());
        return conceptsLC.contains(t.getText()) || conceptsLC.contains(t.getLemma());
    }

    private static boolean computeBestMatches(Map<Integer, List<Pair<Integer, MatchReason>>> matchMatrix, SemanticSearchContext.MatchedEntityCandidate candidate, SemanticSearchContext ssc) {
        if (matchMatrix.isEmpty()) {
            return false;
        }
        List<Integer> matchedColTokenVector = matchMatrix.keySet().stream().sorted().collect(Collectors.toList());
        List matchedQTokenList = matchMatrix.values().stream().collect(Collectors.toList());
        List matchedQTokenVectors = SemanticHelper.computePermutations(matchedQTokenList);
        float maxScore = 0.0f;
        List<Pair<Integer, MatchReason>> best = null;
        for (List<Pair<Integer, MatchReason>> list : matchedQTokenVectors) {
            List<Pair<Integer, MatchReason>> list2;
            float inOrderFactor = NamedEntityRecognizer.isInOrder(list);
            float score = inOrderFactor * NamedEntityRecognizer.computeSimilarity(list2 = list.stream().sorted(Comparator.comparingInt(Pair::getLeft)).collect(Collectors.toList()), matchedColTokenVector, ssc.getTokens().size());
            if (Float.compare(score, maxScore) <= 0) continue;
            maxScore = score;
            best = list2;
        }
        if (best == null) {
            return false;
        }
        candidate.setSimilarityScore(maxScore);
        MatchReason reason = NamedEntityRecognizer.decideMatchReason(best);
        ((MatchedFeature)candidate.getMatchedFeatures().get(0)).setMatchReason(reason);
        if (reason == MatchReason.PARTIAL_CONCEPT) {
            NamedEntityRecognizer.conceptTokenOffsetResolution(candidate, ssc);
        } else {
            candidate.setTokenBegin((Integer)((Pair)best.get(0)).getLeft());
            candidate.setTokenEnd((Integer)best.get(best.size() - 1).getLeft());
            candidate.setBestMatchedQTokenVector(best);
        }
        candidate.setCharOffsetBegin(ssc.getTokens().get(candidate.getTokenBegin()).getCharOffsetBegin());
        candidate.setCharOffsetEnd(ssc.getTokens().get(candidate.getTokenEnd()).getCharOffsetEnd());
        candidate.setCoveredText(ssc.getQuestion().substring(candidate.getCharOffsetBegin(), candidate.getCharOffsetEnd()));
        if (candidate.getCoveredText().equalsIgnoreCase(((MatchedFeature)candidate.getMatchedFeatures().get(0)).getFeature().getFeatureKey())) {
            ((MatchedFeature)candidate.getMatchedFeatures().get(0)).setMatchReason(MatchReason.FULL);
            ((MatchedFeature)candidate.getMatchedFeatures().get(0)).setConfidence(1.0f);
            candidate.setSimilarityScore(1.0f);
        }
        ssc.addMatchedEntityCandiate(candidate);
        return true;
    }

    private static float isInOrder(List<Pair<Integer, MatchReason>> matchedQTokenVector) {
        float f = 1.0f;
        for (int i = 0; i < matchedQTokenVector.size() - 1; ++i) {
            if ((Integer)matchedQTokenVector.get(i).getKey() <= (Integer)matchedQTokenVector.get(i + 1).getKey()) {
                f *= 1.0f;
                continue;
            }
            f *= 0.7f;
        }
        return f;
    }

    private static boolean conceptTokenOffsetResolution(SemanticSearchContext.MatchedEntityCandidate candidate, SemanticSearchContext ssc) {
        MatchedFeature feature = (MatchedFeature)candidate.getMatchedFeatures().get(0);
        int tokenIndex = NamedEntityRecognizer.lookupTokenViaConcept(ssc, feature);
        if (tokenIndex >= 0) {
            candidate.setTokenBegin(tokenIndex);
            candidate.setTokenEnd(tokenIndex);
            return true;
        }
        return false;
    }

    private static int lookupTokenViaConcept(SemanticSearchContext ssc, MatchedFeature feature) {
        List concepts = feature.getFeature().getSearchableConcepts();
        for (String concept : concepts) {
            List<TokenInfo> tokens = ssc.getTokens();
            for (int i = 0; i < tokens.size(); ++i) {
                if (!tokens.get(i).getLemma().equalsIgnoreCase(concept) && !tokens.get(i).getText().equalsIgnoreCase(concept)) continue;
                return i;
            }
        }
        return -1;
    }

    static MatchReason decideMatchReason(List<Pair<Integer, MatchReason>> best) {
        if (NamedEntityRecognizer.matchReasonRatio(best, MatchReason.PARTIAL_NAME, 0.5f) >= 0) {
            return MatchReason.PARTIAL_NAME;
        }
        if (NamedEntityRecognizer.matchReasonRatio(best, MatchReason.PARTIAL_LEMMA, 0.5f) >= 0) {
            return MatchReason.PARTIAL_LEMMA;
        }
        return MatchReason.PARTIAL_CONCEPT;
    }

    private static int matchReasonRatio(List<Pair<Integer, MatchReason>> best, MatchReason reason, float limit) {
        return Float.compare((float)best.stream().filter(p -> p.getRight() == reason).count() / (float)best.size(), limit);
    }

    private static float computeSimilarity(List<Pair<Integer, MatchReason>> matchedQTokenVector, List<Integer> matchedColTokenVector, int docLen) {
        if (matchedQTokenVector.size() != matchedColTokenVector.size()) {
            LOGGER.warn("matchedQTokenVector and matchedColTokenVector should have the same size");
        }
        int size = matchedQTokenVector.size() < matchedColTokenVector.size() ? matchedQTokenVector.size() : matchedColTokenVector.size();
        int dotProduct = 0;
        int magnitudePowA = 0;
        int magnitudePowB = 0;
        for (int i = 0; i < size; ++i) {
            dotProduct += (Integer)matchedQTokenVector.get(i).getLeft() * matchedColTokenVector.get(i);
            magnitudePowA += (Integer)matchedQTokenVector.get(i).getLeft() * (Integer)matchedQTokenVector.get(i).getLeft();
            magnitudePowB += matchedColTokenVector.get(i) * matchedColTokenVector.get(i);
        }
        int distance = (Integer)matchedQTokenVector.get(matchedQTokenVector.size() - 1).getLeft() - (Integer)matchedQTokenVector.get(0).getLeft() + 1;
        float f = (float)Math.abs(Math.log((float)docLen / ((float)distance + 1.0E-4f)));
        return (float)((double)(((float)dotProduct + 1.0E-4f) * f) / (Math.sqrt((float)magnitudePowA + 1.0E-4f) * Math.sqrt((float)magnitudePowB + 1.0E-4f)));
    }

    private static boolean fullMatchEpoch(MatchedFeature aMatch, SemanticSearchContext ssc) {
        String origQuestionLC = ssc.getQuestion().toLowerCase(ssc.getReqCtx().locale);
        int matchBegin = NamedEntityRecognizer.stringMatchBegin(origQuestionLC, aMatch.getFeature().getFeatureKeyLC(), ssc.getReqCtx().locale);
        if (matchBegin >= 0) {
            int i;
            SemanticSearchContext.MatchedEntityCandidate candidate = new SemanticSearchContext.MatchedEntityCandidate();
            candidate.getMatchedFeatures().add(aMatch);
            candidate.setCharOffsetBegin(matchBegin);
            candidate.setCharOffsetEnd(candidate.getCharOffsetBegin() + aMatch.getFeature().getFeatureKey().length());
            candidate.setCoveredText(ssc.getQuestion().substring(candidate.getCharOffsetBegin(), candidate.getCharOffsetEnd()));
            boolean tokenBeginSet = false;
            boolean tokenEndSet = false;
            for (i = 0; i < ssc.getTokens().size(); ++i) {
                if (ssc.getTokens().get(i).getCharOffsetBegin() != candidate.getCharOffsetBegin()) continue;
                candidate.setTokenBegin(i);
                tokenBeginSet = true;
                break;
            }
            while (i < ssc.getTokens().size()) {
                if (ssc.getTokens().get(i).getCharOffsetEnd() == candidate.getCharOffsetEnd()) {
                    candidate.setTokenEnd(i);
                    tokenEndSet = true;
                    break;
                }
                ++i;
            }
            if (tokenBeginSet && tokenEndSet && candidate.getTokenEnd() >= candidate.getTokenBegin() || origQuestionLC.equals(aMatch.getFeature().getFeatureKeyLC())) {
                aMatch.setMatchReason(MatchReason.FULL);
                aMatch.setConfidence(1.0f);
                candidate.setSimilarityScore(1.0f);
                ssc.addMatchedEntityCandiate(candidate);
                return true;
            }
        }
        return false;
    }

    private static int stringMatchBegin(String origQuestionLC, String featureKeyLC, Locale locale) {
        if (NamedEntityRecognizer.isWhiteSpaceWordBound(locale)) {
            int begin = -1;
            if (origQuestionLC.equals(featureKeyLC) || origQuestionLC.startsWith(featureKeyLC + " ")) {
                begin = 0;
            }
            if (begin == -1 && (begin = origQuestionLC.indexOf(" " + featureKeyLC + " ")) != -1) {
                ++begin;
            }
            if (begin == -1 && (begin = origQuestionLC.indexOf(" " + featureKeyLC)) != -1) {
                ++begin;
            }
            return begin;
        }
        return origQuestionLC.indexOf(featureKeyLC);
    }

    static boolean isWhiteSpaceWordBound(Locale locale) {
        return !NON_WHITESPACE_BOUND_LOCALES.contains(locale.getLanguage());
    }

    private static MatchedFeature convertToMatchedFeature(IRecordResult<Feature> hit) {
        MatchedFeature aMatch = new MatchedFeature();
        aMatch.setFeature((Feature)hit.getRecord().getRecord());
        aMatch.setFeatureType(aMatch.getFeature().getFeatureType());
        aMatch.setScore(hit.getScore());
        return aMatch;
    }

    public static List<MatchedEntity> ensemble(SemanticSearchContext ssc) {
        NamedEntityRecognizer.adjustScore(ssc);
        NamedEntityRecognizer.consolidateCandidates(ssc);
        return NamedEntityRecognizer.constructMatchedEntities(ssc);
    }

    private static void adjustScore(SemanticSearchContext ssc) {
        ArrayList entries = new ArrayList(ssc.getMatchedEntityCandidateMap().entrySet());
        entries.stream().flatMap(ety -> ((ArrayList)ety.getValue()).stream()).forEach(can -> can.getMatchedFeatures().forEach(f -> {
            try {
                NamedEntityRecognizer.adjustScore(f, ssc.getTokens().subList(can.getTokenBegin(), can.getTokenEnd()), ssc.getReqCtx().locale);
            }
            catch (Exception ex) {
                LOGGER.warn("Token offset incorrect for candidate {} begin is {} but end is {}", new Object[]{can.getCoveredText(), can.getTokenBegin(), can.getTokenEnd()});
            }
        }));
    }

    private static void adjustScore(MatchedFeature aMatch, List<TokenInfo> tokens, Locale locale) {
        if (aMatch.getMatchReason() == MatchReason.FULL) {
            aMatch.setConfidence(1.0f);
        } else {
            Optional<ColumnInfo> colInfo;
            if ((MatchReason.PARTIAL_CONCEPT == aMatch.getMatchReason() || MatchReason.DATA_VALUE == aMatch.getMatchReason()) && FeatureType.COLUMN_NAME == aMatch.getFeatureType() && (colInfo = NamedEntityRecognizer.unmarshalColumn(aMatch.getFeature())).isPresent()) {
                colInfo.get().getSemanticInfo().getConcepts().stream().filter(c -> NamedEntityRecognizer.tokenMatch(tokens, ConceptsUtil.getConceptName((ConceptInfo)c).toLowerCase(locale)) || aMatch.getFeature().getSearchableConcepts().contains(ConceptsUtil.getConceptName((ConceptInfo)c))).findFirst().ifPresent(c -> {
                    LOGGER.debug("Original score: " + aMatch.getScore() + "concept: " + ConceptsUtil.getConceptName((ConceptInfo)c) + "(" + c.getConfidence() + ")");
                    aMatch.setScore(aMatch.getScore() * c.getConfidence());
                    LOGGER.debug("New score: {}", (Object)Float.valueOf(aMatch.getScore()));
                });
            }
            aMatch.setConfidence((float)(1.0 - Math.exp(-aMatch.getScore())));
        }
    }

    private static boolean tokenMatch(List<TokenInfo> tokens, String conceptNameLC) {
        return tokens.stream().anyMatch(t -> t.getText().equals(conceptNameLC) || t.getLemma().equals(conceptNameLC));
    }

    private static void consolidateCandidates(SemanticSearchContext ssc) {
        MultiMap candidateMap = ssc.getMatchedEntityCandidateMap();
        ArrayList<String> toRemove = new ArrayList<String>(candidateMap.size());
        ArrayList<Map.Entry<String, ArrayList<SemanticSearchContext.MatchedEntityCandidate>>> entries = new ArrayList<Map.Entry<String, ArrayList<SemanticSearchContext.MatchedEntityCandidate>>>(candidateMap.entrySet());
        for (int i = 0; i < entries.size() - 1; ++i) {
            if (toRemove.contains(((Map.Entry)entries.get(i)).getKey())) continue;
            NamedEntityRecognizer.findOverlapper(entries, i, ssc, toRemove);
        }
        toRemove.stream().forEach(key -> candidateMap.remove(key));
    }

    private static List<MatchedEntity> constructMatchedEntities(SemanticSearchContext ssc) {
        MultiMap candidateMap = ssc.getMatchedEntityCandidateMap();
        ArrayList candidates = new ArrayList(candidateMap.entrySet());
        ArrayList<MatchedEntity> entities = new ArrayList<MatchedEntity>(candidateMap.size());
        candidates.forEach(can -> {
            List values = (List)can.getValue();
            MatchedEntity entity = new MatchedEntity();
            SemanticSearchContext.MatchedEntityCandidate top = (SemanticSearchContext.MatchedEntityCandidate)((Object)((Object)values.get(0)));
            entity.setCharOffsetBegin(top.getCharOffsetBegin());
            entity.setCharOffsetEnd(top.getCharOffsetEnd());
            entity.setCoveredText(top.getCoveredText());
            entity.setTokenBegin(top.getTokenBegin());
            entity.setTokenEnd(top.getTokenEnd());
            entity.getMatchedFeatures().addAll(top.getMatchedFeatures());
            for (int i = 1; i < values.size(); ++i) {
                entity.getMatchedFeatures().addAll(((SemanticSearchContext.MatchedEntityCandidate)((Object)((Object)values.get(i)))).getMatchedFeatures());
            }
            entity.getMatchedFeatures().sort(Comparator.comparingDouble(MatchedFeature::getConfidence).thenComparing(MatchedFeature::getScore).thenComparingLong(f -> f.getFeature().getLastModifiedDate()).reversed());
            entities.add(entity);
        });
        entities.sort(Comparator.comparingDouble(e -> ((MatchedFeature)e.getMatchedFeatures().get(0)).getConfidence()).thenComparingDouble(e -> ((MatchedFeature)e.getMatchedFeatures().get(0)).getScore()).thenComparingInt(e -> ((MatchedFeature)e.getMatchedFeatures().get(0)).getFeature().getFeatureKey().length()).thenComparingLong(e -> ((MatchedFeature)e.getMatchedFeatures().get(0)).getFeature().getLastModifiedDate()).reversed());
        NamedEntityRecognizer.detectMultiOccurrence(entities, ssc);
        return entities;
    }

    private static void detectMultiOccurrence(List<MatchedEntity> entities, SemanticSearchContext ssc) {
        String questionLC = ssc.getQuestion().toLowerCase(ssc.getReqCtx().locale);
        ArrayList moreOccurence = new ArrayList(entities.size());
        entities.forEach(entity -> {
            String prefix = NamedEntityRecognizer.isWhiteSpaceWordBound(ssc.getReqCtx().locale) ? " " : "";
            int from = entity.getCharOffsetEnd();
            while (from < questionLC.length()) {
                int anotherBegin = questionLC.indexOf(prefix + entity.getCoveredText().toLowerCase(ssc.getReqCtx().locale), from) + 1;
                if (anotherBegin >= entity.getCharOffsetEnd() && NamedEntityRecognizer.nonOverlap(entities, ssc, entity)) {
                    MatchedEntity another = new MatchedEntity();
                    another.setCharOffsetBegin(anotherBegin);
                    another.setCharOffsetEnd(anotherBegin + entity.getCoveredText().length());
                    another.setCoveredText(ssc.getQuestion().substring(another.getCharOffsetBegin(), another.getCharOffsetEnd()));
                    if (NamedEntityRecognizer.valueTokenOffsetResolution(another, ssc)) {
                        another.getMatchedFeatures().addAll(entity.getMatchedFeatures());
                        moreOccurence.add(another);
                    }
                    from = another.getCharOffsetEnd();
                    continue;
                }
                from = questionLC.length();
            }
        });
        entities.addAll(moreOccurence);
    }

    private static boolean nonOverlap(List<MatchedEntity> entities, SemanticSearchContext ssc, MatchedEntity entity) {
        return entities.stream().filter(e -> e.getCharOffsetBegin() >= entity.getCharOffsetEnd()).noneMatch(e -> e.getCoveredText().toLowerCase(ssc.getReqCtx().locale).contains(entity.getCoveredText().toLowerCase(ssc.getReqCtx().locale)));
    }

    private static void findOverlapper(List<Map.Entry<String, ArrayList<SemanticSearchContext.MatchedEntityCandidate>>> entries, int cursor, SemanticSearchContext ssc, List<String> toRemove) {
        for (int i = cursor; i < entries.size() - 1; ++i) {
            if (entries.get(cursor).getKey().length() < entries.get(i + 1).getKey().length()) {
                NamedEntityRecognizer.handleOverlapIfAny(entries.get(i + 1), entries.get(cursor), ssc, toRemove);
                continue;
            }
            NamedEntityRecognizer.handleOverlapIfAny(entries.get(cursor), entries.get(i + 1), ssc, toRemove);
        }
    }

    private static void handleOverlapIfAny(Map.Entry<String, ArrayList<SemanticSearchContext.MatchedEntityCandidate>> entryBigger, Map.Entry<String, ArrayList<SemanticSearchContext.MatchedEntityCandidate>> entry, SemanticSearchContext ssc, List<String> toRemove) {
        if (toRemove.contains(entryBigger.getKey()) || toRemove.contains(entry.getKey())) {
            return;
        }
        boolean overlap = false;
        List<Integer> vectorB = entryBigger.getValue().get(0).getMatchedQTokenIndexes();
        List<Integer> vectorS = entry.getValue().get(0).getMatchedQTokenIndexes();
        if (entryBigger.getKey().length() > entry.getKey().length() && entryBigger.getKey().toLowerCase(ssc.getReqCtx().locale).startsWith(entry.getKey().toLowerCase(ssc.getReqCtx().locale))) {
            List<Integer> notOverlapTrailingIndexesB;
            boolean trivial;
            int start = vectorB.size();
            for (int index = vectorB.size() - 1; index >= 0; --index) {
                if (vectorB.get(index) != vectorS.get(vectorS.size() - 1)) continue;
                start = ++index;
                break;
            }
            if (start < vectorB.size() && (trivial = (notOverlapTrailingIndexesB = vectorB.subList(start, vectorB.size())).stream().allMatch(i -> NamedEntityRecognizer.isTrivialMatch(i, ssc)))) {
                overlap = true;
                toRemove.add(entryBigger.getKey());
                entry.getValue().addAll((Collection<SemanticSearchContext.MatchedEntityCandidate>)entryBigger.getValue());
            }
        }
        if (!overlap) {
            List notOverlapIndexesInS = vectorS.stream().filter(e -> !vectorB.contains(e)).collect(Collectors.toList());
            if (notOverlapIndexesInS.size() < vectorS.size() && notOverlapIndexesInS.stream().allMatch(i -> STOP_WORD_POS.contains(ssc.getTokens().get((int)i).getPOSlocal()))) {
                overlap = true;
            }
            if (overlap && !NamedEntityRecognizer.isFullMatch((List<SemanticSearchContext.MatchedEntityCandidate>)entry.getValue())) {
                toRemove.add(entry.getKey());
                entryBigger.getValue().addAll((Collection<SemanticSearchContext.MatchedEntityCandidate>)entry.getValue());
            } else if (overlap && !NamedEntityRecognizer.isFullMatch((List<SemanticSearchContext.MatchedEntityCandidate>)entryBigger.getValue())) {
                entry.getValue().addAll((Collection<SemanticSearchContext.MatchedEntityCandidate>)entryBigger.getValue());
            }
        }
    }

    private static boolean isTrivialMatch(int i, SemanticSearchContext ssc) {
        return TRIVIAL_TOKEN.contains(ssc.getTokens().get(i).getPOS());
    }

    static boolean isFullMatch(List<SemanticSearchContext.MatchedEntityCandidate> candidates) {
        return !candidates.isEmpty() && candidates.stream().anyMatch(SemanticSearchContext.MatchedEntityCandidate::isFullMatch);
    }
}

