/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.nlu.schema.intent;

import com.ibm.smarts.conversation.nlu.schema.utils.ColumnModifierUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public enum Aggregator {
    AVG("avg"),
    COUNT("count"),
    COUNT_DISTINCT("countdistinct"),
    MIN("min"),
    MAX("max"),
    SUM("sum");

    private String value;
    private static final List<String> KEYWORD_AVG;
    private static final List<String> KEYWORD_COUNT;
    private static final List<String> KEYWORD_MIN;
    private static final List<String> KEYWORD_MAX;
    private static final List<String> KEYWORD_SUM;

    private Aggregator(String value) {
        this.value = value;
    }

    public static Aggregator fromValue(String modifier) {
        if (modifier != null) {
            if (ColumnModifierUtils.findMatchingKeyword(modifier, KEYWORD_AVG) != null) {
                return AVG;
            }
            if (ColumnModifierUtils.findMatchingKeyword(modifier, KEYWORD_COUNT) != null) {
                return COUNT;
            }
            if (ColumnModifierUtils.findMatchingKeyword(modifier, KEYWORD_MIN) != null) {
                return MIN;
            }
            if (ColumnModifierUtils.findMatchingKeyword(modifier, KEYWORD_MAX) != null) {
                return MAX;
            }
            if (ColumnModifierUtils.findMatchingKeyword(modifier, KEYWORD_SUM) != null) {
                return SUM;
            }
        }
        return null;
    }

    public String value() {
        return this.value;
    }

    public static Aggregator fromName(String name) {
        Optional<Aggregator> aggregator = Arrays.stream(Aggregator.values()).filter(v -> v.name().equals(name)).findFirst();
        if (aggregator.isPresent()) {
            return aggregator.get();
        }
        return null;
    }

    static {
        KEYWORD_AVG = Arrays.asList("average", "avg");
        KEYWORD_COUNT = Arrays.asList("count", "count of", "how many", "number of");
        KEYWORD_MIN = Arrays.asList("min", "minimal", "minimum");
        KEYWORD_MAX = Arrays.asList("max", "maximal", "maximum");
        KEYWORD_SUM = Arrays.asList("sum", "total");
    }
}

