/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.value;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ibm.smarts.model.datatype.BaseDataType;
import com.ibm.smarts.model.datatype.DataType;
import com.ibm.smarts.model.datatype.DataTypes;
import com.ibm.smarts.model.value.Value;
import com.ibm.smarts.model.value.ValueDeserializer;
import com.ibm.smarts.model.value.ValueSerializer;
import com.ibm.smarts.model.value.ValueStatus;
import java.math.BigDecimal;
import java.util.Date;

@JsonTypeName(value="double")
@JsonDeserialize(using=ValueDeserializer.class)
@JsonSerialize(using=ValueSerializer.class)
public class DoubleValue
extends Value {
    @JsonProperty(value="doubleValue")
    private double value;

    public DoubleValue() {
        this.setStatus(ValueStatus.NULL);
    }

    public DoubleValue(double value, ValueStatus status) {
        this.set(value, status);
    }

    public DoubleValue(double value) {
        this.set(value);
    }

    @JsonGetter(value="doubleValue")
    public double getValue() {
        return this.value;
    }

    @Override
    public DataType getType() {
        return DataTypes.getDoubleType();
    }

    public void set(double value, ValueStatus status) {
        this.value = value;
        this.setStatus(status);
    }

    public void set(double value) {
        this.set(value, ValueStatus.OK);
    }

    public void set(Double value) {
        if (null == value) {
            this.set(Double.NaN, ValueStatus.NULL);
        } else {
            this.set(value, ValueStatus.OK);
        }
    }

    @Override
    public String stringValue() {
        if (this.isNull()) {
            return null;
        }
        return Double.toString(this.value);
    }

    @Override
    public float floatValue() {
        if (this.isNull()) {
            return 0.0f;
        }
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        if (this.isNull()) {
            return 0.0;
        }
        return this.value;
    }

    @Override
    public BigDecimal bigDecimalValue() {
        if (!this.isOK() || Double.isNaN(this.value) || Double.isInfinite(this.value)) {
            return null;
        }
        return BigDecimal.valueOf(this.value);
    }

    @Override
    public Number numberValue() {
        if (!this.isOK()) {
            return null;
        }
        return this.doubleValue();
    }

    @Override
    public short shortValue() {
        if (!this.isOK()) {
            return 0;
        }
        return (short)this.value;
    }

    @Override
    public byte byteValue() {
        if (!this.isOK()) {
            return 0;
        }
        return (byte)this.value;
    }

    @Override
    public int intValue() {
        if (!this.isOK()) {
            return 0;
        }
        return (int)this.value;
    }

    @Override
    public long longValue() {
        if (!this.isOK()) {
            return 0L;
        }
        return (long)this.value;
    }

    @Override
    public Date dateValue() {
        if (!this.isOK()) {
            return null;
        }
        return new Date(this.longValue());
    }

    @Override
    public boolean booleanValue() {
        if (!this.isOK()) {
            return false;
        }
        return 0.0 != this.value;
    }

    @Override
    public int hashCode() {
        return this.getStatus().hashCode() + (int)Double.doubleToLongBits(this.value);
    }

    @Override
    public int compareTo(Value other) {
        double rightValue;
        if (this == other) {
            return 0;
        }
        if (null == other) {
            return 1;
        }
        if (other.getType().getBaseType() != BaseDataType.DOUBLE) {
            return DoubleValue.compareValue(this, other);
        }
        double leftValue = this.doubleValue();
        if (leftValue < (rightValue = other.doubleValue())) {
            return -1;
        }
        if (leftValue > rightValue) {
            return 1;
        }
        return 0;
    }

    @Override
    public void assignFrom(Value value) {
        if (null == value || ValueStatus.NULL == value.getStatus()) {
            this.set(0.0, ValueStatus.NULL);
        } else {
            this.set(value.doubleValue(), value.getStatus());
        }
    }

    @Override
    public void assignFrom(String value) {
        if (null == value) {
            this.set(0.0, ValueStatus.NULL);
        } else {
            try {
                this.set(Double.parseDouble(value), ValueStatus.OK);
            }
            catch (NumberFormatException ex) {
                this.setError();
            }
        }
    }

    protected static double convertNegativeZeroToZero(double dValue) {
        if (dValue == 0.0) {
            return 0.0;
        }
        return dValue;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DoubleValue that = (DoubleValue)o;
        return Double.compare(that.value, this.value) == 0;
    }
}

