/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.value.decor;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.ibm.smarts.model.value.decor.CurrencyDecoration;
import com.ibm.smarts.model.value.decor.OrderedDecoration;
import com.ibm.smarts.model.value.decor.PercentDecoration;
import com.ibm.smarts.model.value.decor.SubItemDecoration;
import com.ibm.smarts.model.value.decor.ThousandsSeparatorDecoration;
import com.ibm.smarts.model.value.decor.ValueDecoration;
import java.io.IOException;

public class ValueDecorationDeserializer
extends StdDeserializer<ValueDecoration> {
    private static final long serialVersionUID = -3632948464791408451L;

    public ValueDecorationDeserializer() {
        super(ValueDecoration.class);
    }

    protected ValueDecorationDeserializer(Class<?> vc) {
        super(vc);
    }

    public ValueDecoration deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        String type = node.get("type").asText();
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        switch (type.toUpperCase()) {
            case "PERCENT": {
                return (ValueDecoration)mapper.treeToValue((TreeNode)node, PercentDecoration.class);
            }
            case "CURRENCY": {
                return (ValueDecoration)mapper.treeToValue((TreeNode)node, CurrencyDecoration.class);
            }
            case "THOUSANDS_SEPARATOR": {
                return (ValueDecoration)mapper.treeToValue((TreeNode)node, ThousandsSeparatorDecoration.class);
            }
            case "ORDERED": {
                return (ValueDecoration)mapper.treeToValue((TreeNode)node, OrderedDecoration.class);
            }
            case "SUBITEM": {
                return (ValueDecoration)mapper.treeToValue((TreeNode)node, SubItemDecoration.class);
            }
        }
        return null;
    }
}

