/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.generic.recommender.internal.raw.impl.classifiers.datalayer;

import com.ibm.smarts.generic.recommender.internal.raw.impl.classifiers.datalayer.DatasetReaders;
import com.ibm.smarts.generic.recommender.internal.raw.impl.classifiers.datalayer.DatasetSpec;
import com.ibm.smarts.generic.recommender.internal.raw.impl.classifiers.datalayer.FeatureSpec;
import com.ibm.smarts.generic.recommender.internal.raw.impl.classifiers.datalayer.GenericTransformerException;
import com.ibm.smarts.generic.recommender.internal.raw.impl.classifiers.datalayer.IDatasetReader;
import com.ibm.smarts.generic.recommender.internal.raw.impl.classifiers.pipeline.DatasetPipeline;
import com.ibm.smarts.generic.recommender.internal.raw.impl.classifiers.pipeline.Numerizer;
import com.ibm.smarts.generic.recommender.internal.raw.impl.classifiers.pipeline.OneHotEncoder;
import com.ibm.smarts.generic.recommender.internal.raw.impl.classifiers.pipeline.OrdinalIndexer;
import com.ibm.smarts.generic.recommender.internal.raw.impl.classifiers.pipeline.StringIndexer;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DatasetManager
implements Serializable {
    private static final long serialVersionUID = 2751408150698075461L;
    private transient List<List<String>> rawDataset;
    private transient List<List<Double>> dataset = new ArrayList<List<Double>>();
    private transient DatasetSpec spec;
    private transient IDatasetReader reader;
    private DatasetPipeline pipeline = new DatasetPipeline();
    private StringIndexer labelIndexer;

    public DatasetManager() {
    }

    public String getLabelForIndex(double index) {
        return this.labelIndexer.getLabelForIndex(index);
    }

    public DatasetManager(List<List<String>> rawDataset, List<List<Double>> dataset, DatasetPipeline pipeline, DatasetSpec spec, IDatasetReader reader, StringIndexer labelIndexer) {
        this.rawDataset = rawDataset;
        this.dataset = dataset;
        this.pipeline = pipeline;
        this.spec = spec;
        this.reader = reader;
        this.labelIndexer = labelIndexer;
    }

    public Set<Double> getLableIds() {
        return this.labelIndexer.getLabelIds();
    }

    public DatasetManager convertToBinaryDataset(double targetClass) {
        if (this.spec == null) {
            throw new IllegalStateException("Spec is not set");
        }
        if (this.rawDataset.isEmpty()) {
            throw new IllegalStateException("req dtataset is emty");
        }
        Function<List, List> rowMapper = r -> {
            ArrayList<Double> nr = new ArrayList<Double>((Collection<Double>)r);
            if (Double.compare((Double)r.get(0), targetClass) == 0) {
                nr.set(0, 1.0);
            } else {
                nr.set(0, 0.0);
            }
            return nr;
        };
        List<List<Double>> binarySet = this.dataset.stream().map(rowMapper::apply).collect(Collectors.toList());
        return new DatasetManager(this.rawDataset, binarySet, new DatasetPipeline(this.pipeline), this.spec, this.reader, new StringIndexer(this.labelIndexer));
    }

    private void buildPipeline() {
        if (this.spec == null) {
            throw new IllegalStateException("Spec is not set");
        }
        if (this.rawDataset.isEmpty()) {
            throw new IllegalStateException("req dtataset is emty");
        }
        int column = 0;
        HashMap<String, FeatureSpec> featureToSpec = new HashMap<String, FeatureSpec>();
        for (FeatureSpec feature : this.spec.getSpecs()) {
            featureToSpec.put(feature.getName().trim(), feature);
        }
        int nrFeatures = this.rawDataset.get(0).size();
        List<String> header = this.rawDataset.get(0).subList(1, nrFeatures);
        this.labelIndexer = new StringIndexer(this.rawDataset.get(0).get(0), column);
        this.pipeline.addTransformer(this.labelIndexer);
        for (String feature : header) {
            FeatureSpec featureSpec = (FeatureSpec)featureToSpec.get(feature.trim());
            switch (featureSpec.getType()) {
                case CATEGORICAL_NONORDINAL: {
                    this.pipeline.addTransformer(new OneHotEncoder(feature, ++column));
                    break;
                }
                case CATEGORICAL_ORDINAL: {
                    this.pipeline.addTransformer(new OrdinalIndexer(feature, ++column, featureSpec.getOptions()));
                    break;
                }
                case NUMERICAL: {
                    this.pipeline.addTransformer(new Numerizer(feature, ++column));
                }
            }
        }
    }

    private void processDataset() {
        if (this.reader == null) {
            throw new IllegalStateException("Reader is not set");
        }
        this.rawDataset = this.reader.getDataset();
        this.spec = this.reader.getSpec();
        this.buildPipeline();
        int nrRows = this.rawDataset.size();
        this.dataset = new ArrayList<List<Double>>(nrRows - 1);
        int nrFeatures = this.rawDataset.get(0).size();
        for (int i = 0; i < nrRows - 1; ++i) {
            ArrayList list = new ArrayList(nrFeatures);
            this.dataset.add(list);
        }
        List<List<String>> datasetNoHdr = this.rawDataset.subList(1, this.rawDataset.size());
        this.pipeline.transform(datasetNoHdr, this.dataset);
    }

    public void readDataset(String datasetFile, String specFile) throws IOException {
        this.reader = DatasetReaders.getDatasetReader();
        this.reader.readDataset(datasetFile, specFile);
        this.processDataset();
    }

    public void readDataset(InputStream datasetStream, InputStream specStream) throws IOException {
        this.reader = DatasetReaders.getDatasetReader();
        this.reader.readDataset(datasetStream, specStream);
        this.rawDataset = this.reader.getDataset();
        this.processDataset();
    }

    public List<List<Double>> getDataset() {
        return this.dataset;
    }

    public List<Double> transformVector(List<String> in) throws GenericTransformerException {
        ArrayList<Double> out = new ArrayList<Double>();
        in.add(0, this.labelIndexer.getLabelForIndex(0.0));
        this.pipeline.transformVector(in, out);
        return out;
    }

    public List<List<String>> getRawDataset() {
        return this.rawDataset;
    }

    public DatasetPipeline getPipeline() {
        return this.pipeline;
    }

    public DatasetSpec getSpec() {
        return this.spec;
    }

    public IDatasetReader getReader() {
        return this.reader;
    }

    public StringIndexer getLabelIndexer() {
        return this.labelIndexer;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.rawDataset = Collections.emptyList();
        this.dataset = Collections.emptyList();
        this.spec = null;
        this.reader = null;
    }
}

