/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.generic.recommender.internal.raw.impl.classifiers.logisticregression;

import com.ibm.smarts.generic.recommender.api.java.classifiers.IClassification;
import com.ibm.smarts.generic.recommender.internal.raw.impl.classifiers.Classification;
import com.ibm.smarts.generic.recommender.internal.raw.impl.classifiers.datalayer.DatasetManager;
import com.ibm.smarts.generic.recommender.internal.raw.impl.classifiers.learningalgorithm.GradientDescent;
import com.ibm.smarts.generic.recommender.internal.raw.impl.classifiers.learningalgorithm.ICostFunc;
import com.ibm.smarts.generic.recommender.internal.raw.impl.classifiers.logisticregression.ITrainable;
import com.ibm.smarts.generic.recommender.internal.raw.impl.classifiers.logisticregression.LogisticRegressionGradient;
import java.util.List;
import java.util.stream.Collectors;

public class LogisticRegressionClassifier
implements ITrainable {
    private static final String ONE_CLS = "1";
    private List<List<Double>> dataset;
    private List<Double> model;
    private static final int GRADIENT_DESCENT_MAX_ITER = 1000;
    private static final double GRADIENT_DESCENT_LEARNING_RATE = 0.003;
    private static final double MAX_ACCEPTED_LOSS = 0.0;

    public LogisticRegressionClassifier(DatasetManager mgr) {
        this.dataset = mgr.getDataset();
    }

    public LogisticRegressionClassifier(List<Double> model) {
        this.model = model;
    }

    private void buildModel() {
        GradientDescent algorithm = new GradientDescent(new LogisticRegressionGradient(), new LogisticRegressionCostFunction(), this.dataset, 0.0, 0.003, 1000);
        this.model = algorithm.minimize();
    }

    @Override
    public void train() {
        this.buildModel();
    }

    private double calculateProbability(List<Double> thetas, List<Double> vector) {
        double thetaX = 0.0;
        for (int i = 1; i < thetas.size(); ++i) {
            thetaX += thetas.get(i) * vector.get(i);
        }
        double probability = 1.0 / (1.0 + Math.exp(-thetaX));
        return probability;
    }

    public IClassification getProbabilityDistributionBinary(List<Double> vector) {
        double probability = this.calculateProbability(this.model, vector);
        String label = ONE_CLS;
        return new Classification(label, probability);
    }

    public List<IClassification> getProbabilityDistributionBulkBinary(List<List<Double>> featuresVectors) {
        return featuresVectors.stream().map(this::getProbabilityDistributionBinary).collect(Collectors.toList());
    }

    List<Double> getModel() {
        return this.model;
    }

    class LogisticRegressionCostFunction
    implements ICostFunc {
        LogisticRegressionCostFunction() {
        }

        @Override
        public double calc(List<Double> thetas, List<List<Double>> dataset) {
            double cost = 0.0;
            double datasetSize = dataset.size();
            int i = 0;
            while ((double)i < datasetSize) {
                double prediction = LogisticRegressionClassifier.this.calculateProbability(thetas, dataset.get(i)) >= 0.9 ? 1.0 : 0.0;
                double label = dataset.get(i).get(0);
                cost += (prediction - label) * (prediction - label);
                ++i;
            }
            return cost / (2.0 * datasetSize);
        }
    }
}

