/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.generic.recommender.internal.raw.impl.classifiers.pipeline;

import com.ibm.smarts.generic.recommender.internal.raw.impl.classifiers.logisticregression.ITransformer;
import java.util.ArrayList;
import java.util.List;

public class OrdinalIndexer
implements ITransformer {
    private static final long serialVersionUID = 3112191542264474959L;
    private String name;
    private int column;
    private List<String> options = new ArrayList<String>();
    private static final String DEFAULT_NOT_SET_VAL = "NONE";
    private static final int DEFUALT_OFFSET_FROM_NOT_SET = 10;
    private static final int OFFSET_BETWEEN_VALUES = 5;

    public OrdinalIndexer(String name, int column, List<String> options) {
        if (options == null) {
            throw new IllegalArgumentException("Invalid options");
        }
        this.name = name;
        this.column = column;
        this.options.addAll(options);
    }

    private double transform(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Invalid vector list");
        }
        int index = this.options.indexOf(string);
        double value = 0.0;
        if (index == -1) {
            throw new IllegalArgumentException("Invalid vector list " + string);
        }
        if (index != 0) {
            value = (double)((index - 1) * 5) + 10.0;
        }
        return value;
    }

    @Override
    public void transform(List<List<String>> in, List<List<Double>> out) {
        if (in == null || out == null) {
            throw new IllegalArgumentException("Invalid vector lists");
        }
        for (int i = 0; i < in.size(); ++i) {
            List<String> vector = in.get(i);
            String string = vector.get(this.column).trim();
            List<Double> outVector = out.get(i);
            outVector.add(this.transform(string));
        }
    }

    @Override
    public void transformVector(List<String> in, List<Double> out) {
        String string = in.get(this.column).trim();
        out.add(this.transform(string));
    }

    public int getColumn() {
        return this.column;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public String toString() {
        return "OrdinalIndexer [name=" + this.name + ", column=" + this.column + ", options=" + this.options + ", defaultnotSetValue=" + DEFAULT_NOT_SET_VAL + ", defualtOffsetFromNotSet=" + 10 + ", offsetBetweenValues=" + 5 + "]";
    }
}

