/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.generic.recommender.internal.raw.impl.classifiers.pipeline;

import com.ibm.smarts.generic.recommender.internal.raw.impl.classifiers.logisticregression.ITransformer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StringIndexer
implements ITransformer {
    private static final long serialVersionUID = 5458238518239064927L;
    private final String name;
    private final int column;
    private List<String> stringIndexes = new ArrayList<String>();
    private Map<String, Double> map = new HashMap<String, Double>();

    public StringIndexer(String name, int column) {
        this.name = name;
        this.column = column;
    }

    public StringIndexer(StringIndexer other) {
        this(other.name, other.column);
        this.stringIndexes.addAll(other.stringIndexes);
        this.map.putAll(other.map);
    }

    public StringIndexer(String name, int column, List<String> stringIndexes, Map<String, Double> map) {
        this(name, column);
        this.stringIndexes.addAll(stringIndexes);
        this.map.putAll(map);
    }

    private Double transform(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Invalid vector");
        }
        return this.map.get(string);
    }

    public Set<Double> getLabelIds() {
        return new HashSet<Double>(this.map.values());
    }

    public String getLabelForIndex(double index) {
        return this.stringIndexes.get((int)index);
    }

    @Override
    public void transform(List<List<String>> in, List<List<Double>> out) {
        if (in == null || out == null) {
            throw new IllegalArgumentException("Invalid vector lists");
        }
        for (int i = 0; i < in.size(); ++i) {
            List<String> vector = in.get(i);
            String string = vector.get(this.column).trim();
            Double index = this.transform(string);
            if (index == null) {
                this.stringIndexes.add(string);
                index = (double)this.stringIndexes.size() - 1.0;
                this.map.put(string, index);
            }
            List<Double> outVector = out.get(i);
            outVector.add(index);
        }
    }

    @Override
    public void transformVector(List<String> in, List<Double> out) {
        String colStr = in.get(this.column).trim();
        Double value = this.transform(colStr);
        if (value == null) {
            throw new IllegalArgumentException("Invalid vector " + colStr);
        }
        out.add(value);
    }

    public List<String> getStringIndexes() {
        return Collections.unmodifiableList(this.stringIndexes);
    }

    public int getColumn() {
        return this.column;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "StringIndexer [name=" + this.name + ", column=" + this.column + ", stringIndexer=" + this.stringIndexes + ", map=" + this.map + "]";
    }
}

