/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.store.inmem;

import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.util.JsonParserHelper;
import com.ibm.smarts.core.util.ToString;
import com.ibm.smarts.store.api.ITypedStore;
import com.ibm.smarts.store.api.exceptions.RecordAlreadyExistsException;
import com.ibm.smarts.store.api.exceptions.RecordNotFoundException;
import com.ibm.smarts.store.api.query.IQueryResultCallback;
import com.ibm.smarts.store.api.query.IRecord;
import com.ibm.smarts.store.api.query.IRecordResult;
import com.ibm.smarts.store.api.query.IStoreQuery;
import com.ibm.smarts.store.api.query.IStoreQueryBuilder;
import com.ibm.smarts.store.api.query.StoreStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

public class InMemTypedStore<T>
implements ITypedStore<T> {
    private final ConcurrentHashMap<String, Handle<T>> hashmap = new ConcurrentHashMap();
    private final Class<T> type;
    private final boolean getOriginalValues;

    public InMemTypedStore(Class<T> type) {
        this(type, false);
    }

    public InMemTypedStore(Class<T> type, boolean getOriginalValues) {
        this.type = type;
        this.getOriginalValues = getOriginalValues;
    }

    public String toString() {
        return ToString.with((Object)this).field("class", (Object)this.type.getSimpleName()).get();
    }

    public CompletableFuture<T> getByIdAsync(String id) {
        return this.future(this.getById(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getById(String id) {
        Handle<T> h = null;
        T item = null;
        if (id == null) {
            return null;
        }
        h = this.hashmap.get(id);
        if (h != null && (item = (T)h.item) != null && !this.getOriginalValues) {
            Handle<T> handle = h;
            synchronized (handle) {
                return this.copy(item);
            }
        }
        return item;
    }

    private T copy(T item) {
        if (item == null) {
            return null;
        }
        String serializedItem = JsonParserHelper.toJson(item);
        return (T)JsonParserHelper.fromJson((String)serializedItem, this.type);
    }

    public CompletableFuture<StoreStatus> storeAsync(IRecord<T> rec, boolean replace) {
        return this.future(this.store(rec, replace));
    }

    private Handle<T> getHandle(String id) {
        Handle h = this.hashmap.computeIfAbsent(id, k -> new Handle());
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StoreStatus executeSync(String id, Function<Handle<T>, StoreStatus> f) {
        Handle<T> h;
        Handle<T> handle = h = this.getHandle(id);
        synchronized (handle) {
            StoreStatus storeStatus;
            try {
                boolean alreadyBusy = h.busy.get();
                if (alreadyBusy) {
                    throw new InternalException("Concurrency error in InMemTypedStore. h=" + h, new Object[0]);
                }
                h.busy.set(true);
                storeStatus = f.apply(h);
                h.busy.set(false);
            }
            catch (Throwable throwable) {
                h.busy.set(false);
                throw throwable;
            }
            return storeStatus;
        }
    }

    public StoreStatus store(IRecord<T> rec, boolean replace) {
        return this.executeSync(rec.getId(), h -> {
            Object item = h.item;
            if (item != null && !replace) {
                throw new RecordAlreadyExistsException("id='" + rec.getId() + "'", new Object[0]);
            }
            return this.execute(() -> {
                h.item = rec.getRecord();
            });
        });
    }

    public CompletableFuture<StoreStatus> storeAsync(List<IRecord<T>> recs, boolean replace) {
        return this.future(this.store(recs, replace));
    }

    public StoreStatus store(List<IRecord<T>> recs, boolean replace) {
        ArrayList errors = new ArrayList();
        recs.stream().forEach(r -> {
            StoreStatus status = null;
            try {
                status = this.store((IRecord<T>)r, replace);
                if (status.getErrors() != null) {
                    errors.addAll(status.getErrors());
                }
            }
            catch (RecordAlreadyExistsException ex) {
                errors.add(new InternalException((Throwable)ex, ex.getMessage(), new Object[0]));
            }
        });
        return new StoreStatus(errors.isEmpty(), errors.isEmpty() ? null : errors);
    }

    public CompletableFuture<StoreStatus> deleteByIdAsync(String id) {
        return this.future(this.deleteById(id));
    }

    public StoreStatus deleteById(String id) {
        return this.execute(() -> this.hashmap.remove(id));
    }

    public CompletableFuture<StoreStatus> createOrApplyAsync(String docId, Function<T, T> updateLambda) {
        return this.future(this.createOrApply(docId, updateLambda));
    }

    public StoreStatus createOrApply(String docId, Function<T, T> updateLambda) {
        return this.apply(docId, updateLambda, true);
    }

    public CompletableFuture<StoreStatus> applyAsync(String docId, Function<T, T> updateLambda) {
        return this.future(this.apply(docId, updateLambda));
    }

    public StoreStatus apply(String docId, Function<T, T> updateLambda) {
        return this.apply(docId, updateLambda, false);
    }

    private StoreStatus apply(String docId, Function<T, T> updateLambda, boolean create) {
        return this.executeSync(docId, h -> {
            Object doc = h.item;
            if (!create && doc == null) {
                throw new RecordNotFoundException(docId, new Object[0]);
            }
            return this.execute(() -> {
                Object updatedDoc = updateLambda.apply(doc);
                h.item = updatedDoc;
            });
        });
    }

    private StoreStatus execute(Runnable operation) {
        try {
            operation.run();
            return new StoreStatus(true, null);
        }
        catch (Throwable ex) {
            return this.failure(ex);
        }
    }

    private StoreStatus failure(Throwable ex) {
        return new StoreStatus(false, Arrays.asList(new InternalException(ex, ex.getMessage(), new Object[0])));
    }

    private <U> CompletableFuture<U> future(U value) {
        return CompletableFuture.completedFuture(value);
    }

    public T getById(String id, List<String> includedFields) {
        throw new UnsupportedOperationException("Invalid operation for InMemTypedStore");
    }

    public CompletableFuture<T> getByIdAsync(String id, List<String> includedFields) {
        throw new UnsupportedOperationException("Invalid operation for InMemTypedStore");
    }

    public IStoreQueryBuilder getQueryBuilder() {
        throw new UnsupportedOperationException("Invalid operation for InMemTypedStore");
    }

    public List<IRecordResult<T>> executeSearch(IStoreQuery sq) {
        throw new UnsupportedOperationException("Invalid operation for InMemTypedStore");
    }

    public CompletableFuture<List<IRecordResult<T>>> executeSearchAsync(IStoreQuery sq) {
        throw new UnsupportedOperationException("Invalid operation for InMemTypedStore");
    }

    public void executeSearchAsync(IStoreQuery sq, IQueryResultCallback<T> callback) {
        throw new UnsupportedOperationException("Invalid operation for InMemTypedStore");
    }

    public StoreStatus deleteByQuery(IStoreQuery sq) {
        throw new UnsupportedOperationException("Invalid operation for InMemTypedStore");
    }

    public CompletableFuture<StoreStatus> deleteByQueryAsync(IStoreQuery sq) {
        throw new UnsupportedOperationException("Invalid operation for InMemTypedStore");
    }

    public boolean isExists() {
        return true;
    }

    private static class Handle<T> {
        public T item;
        public AtomicBoolean busy = new AtomicBoolean(false);

        private Handle() {
        }

        public String toString() {
            return ToString.with((Object)this).field("busy", (Object)this.busy.get()).field("item", this.item).get();
        }
    }
}

