/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.builder;

import com.ibm.smarts.ca.api.ISmartsCa;
import com.ibm.smarts.ca.api.SmartsCaSystem;
import com.ibm.smarts.ca.core.impl.SmartsCaCoreHelper;
import com.ibm.smarts.ca.rest.CaRestDataProviderModuleInfo;
import com.ibm.smarts.common.provider.IDataProviderModuleInfo;
import com.ibm.smarts.core.rest.server.RestHandlers;
import com.ibm.smarts.core.util.JsonParserHelper;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.model.builder.KnowledgeDiscoveryRequest;
import com.ibm.smarts.model.builder.ModuleInfo;
import com.ibm.smarts.model.builder.SamplingInfo;
import com.ibm.smarts.model.builder.SmartsModuleInfo;
import com.ibm.smarts.model.builder.SmartsModuleOptions;
import com.ibm.smarts.model.module.CreateSmartModuleResponse;
import com.ibm.smarts.model.progress.SmartsModuleProgressSummary;
import com.ibm.smarts.pipeline.apis.FlowExecutor;
import com.ibm.smarts.schema.AnalysisScope;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.JAXBHelper;
import com.ibm.smarts.smartsmodule.builder.SmartsModuleBuilder;
import com.ibm.smarts.smartsmodule.builder.SmartsModuleBuilderSettings;
import com.ibm.smarts.smartsmodule.builder.api.ISmartsModuleBuilder;
import com.ibm.smarts.smartsmodule.builder.exceptions.SmartsBuilderException;
import com.ibm.smarts.store.api.TypeNames;
import com.ibm.smarts.store.api.config.StoreConfig;
import com.ibm.smarts.store.api.provider.IPersistenceProvider;
import com.ibm.smarts.store.api.query.StoreStatus;
import edu.emory.mathcs.backport.java.util.Collections;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartsCaModuleBuilderApiImpl
implements ISmartsModuleBuilder,
RestHandlers {
    private static final Logger log = LoggerFactory.getLogger(SmartsCaModuleBuilderApiImpl.class);
    private static final String CA_BAD_UNMARSHAL = "Unable to un-marshall {}, from: {}";
    private final SmartsCaSystem caSystem;

    public SmartsCaModuleBuilderApiImpl(SmartsCaSystem caSystem) {
        this.caSystem = caSystem;
    }

    private String convertIdToResourceUri(String id) {
        if (id == null) {
            return null;
        }
        String resourceUri = String.format("/bi/v1/objects", id);
        return resourceUri;
    }

    private String convertResourceUriToId(String resourceUri) {
        if (resourceUri == null) {
            return null;
        }
        String[] parts = resourceUri.split("/");
        return parts[parts.length - 1];
    }

    private <T> T unmarshallRequest(Class<T> type, String jsonString) throws IOException {
        if (jsonString == null || jsonString.trim().isEmpty()) {
            return null;
        }
        try {
            return (T)JAXBHelper.unmarshalJaxbAnnotatedObjectFromJSON(type, (String)jsonString);
        }
        catch (IOException e) {
            log.error(CA_BAD_UNMARSHAL, type, (Object)jsonString);
            throw e;
        }
    }

    private SmartsModuleBuilderSettings createSmartsModuleBuilderSettings(@Nonnull RequestContext requestContext, @Nullable String resourceUri, @Nullable AnalysisScope analysisScope, @Nullable SamplingInfo samplingInfo, @Nullable SmartsModuleOptions smartsModuleOptions, @Nullable ModuleInfo moduleInfo) {
        SmartsModuleBuilderSettings settings = new SmartsModuleBuilderSettings(requestContext);
        settings.setStoreProvider(this.caSystem.storeProvider);
        settings.setDataProvider(this.caSystem.dataProvider);
        settings.setNLP(this.caSystem.getNlp());
        settings.setDataProviderModuleInfo((IDataProviderModuleInfo)new CaRestDataProviderModuleInfo(this.caSystem.caConfig.getProperty("smarts.ca.core.caServer.url")));
        settings.setExecutorService(this.caSystem.getExecutorService());
        if (samplingInfo != null && samplingInfo.getSampleTarget() != null) {
            if (samplingInfo.getSampleTarget().getSampleSize() == 0) {
                samplingInfo.getSampleTarget().setSampleSize(Integer.valueOf(this.caSystem.caConfig.getProperty("smarts.ca.samples.size")).intValue());
            }
            if (samplingInfo.getSampleTarget().getSampleSeed() == Integer.MIN_VALUE) {
                samplingInfo.getSampleTarget().setSampleSeed(Integer.valueOf(this.caSystem.caConfig.getProperty("smarts.ca.samples.seed")).intValue());
            }
        }
        settings.setSamplingInfo(samplingInfo);
        settings.setAnalysisScope(analysisScope);
        settings.setPublishingURI(resourceUri);
        settings.setSystemConfig(this.caSystem.caConfig);
        settings.setSmartsModuleOptions(smartsModuleOptions);
        settings.setModuleHasOverwrites(moduleInfo.hasOverwrites());
        return settings;
    }

    public Response getSmartsModuleWithIdHandler(RequestContext requestContext, String id, String analysisScope, String smartsModuleOptions) {
        String resourceUri = this.convertIdToResourceUri(id);
        return this.getSmartsModuleWithUriHandler(requestContext, resourceUri, analysisScope, smartsModuleOptions);
    }

    public Response getSmartsModuleWithUriHandler(RequestContext requestContext, String resourceUri, String analysisScope, String smartsModuleOptions) {
        SmartsModuleOptions smOptions;
        AnalysisScope scope;
        if (resourceUri == null) {
            return this.badRequest();
        }
        try {
            scope = this.unmarshallRequest(AnalysisScope.class, analysisScope);
            smOptions = this.unmarshallRequest(SmartsModuleOptions.class, smartsModuleOptions);
        }
        catch (IOException e) {
            return this.badRequest();
        }
        SmartsModule smartsModule = this.getSmartsModule(requestContext, resourceUri, scope, smOptions);
        if (smartsModule != null) {
            if (smOptions != null && smOptions.isConceptsOnly()) {
                return this.GETjson(JsonParserHelper.toJsonNonNullNonEmpty((Object)smartsModule));
            }
            return this.GETjson(smartsModule);
        }
        return this.notFound();
    }

    public SmartsModule getSmartsModule(@Nonnull RequestContext requestContext, @Nonnull String resourceUri, AnalysisScope analysisScope, SmartsModuleOptions smartsModuleOptions) {
        ISmartsCa smartsCa = this.caSystem.smartsForRequest(requestContext);
        String id = this.convertResourceUriToId(resourceUri);
        return smartsCa.getSmartsModule(id, smartsModuleOptions);
    }

    public Response createSmartsModuleHandler(RequestContext requestContext, String resourceUri, String knowledgeDiscoveryRequest) {
        try {
            KnowledgeDiscoveryRequest kdsRequest = this.unmarshallRequest(KnowledgeDiscoveryRequest.class, knowledgeDiscoveryRequest);
            return this.createSmartsModuleHandler(this.convertResourceUriToId(resourceUri), requestContext, kdsRequest.getModuleInfo(), kdsRequest.getSmartsModuleInfo(), kdsRequest.getAnalysisScope(), kdsRequest.getSampleInfo(), kdsRequest.getSmartsModuleOptions());
        }
        catch (IOException e) {
            return this.badRequest();
        }
    }

    public Response createSmartsModuleHandler(RequestContext requestContext, String knowledgeDiscoveryRequest) {
        try {
            KnowledgeDiscoveryRequest kdsRequest = this.unmarshallRequest(KnowledgeDiscoveryRequest.class, knowledgeDiscoveryRequest);
            String resourceUri = kdsRequest == null ? null : kdsRequest.getResourceUri();
            return this.createSmartsModuleHandler(this.convertResourceUriToId(resourceUri), requestContext, kdsRequest.getModuleInfo(), kdsRequest.getSmartsModuleInfo(), kdsRequest.getAnalysisScope(), kdsRequest.getSampleInfo(), kdsRequest.getSmartsModuleOptions());
        }
        catch (IOException e) {
            return this.badRequest();
        }
    }

    public Response createSmartsModuleHandler(String resourceUri, RequestContext requestContext, ModuleInfo moduleInfo, SmartsModuleInfo smartsModuleInfo, AnalysisScope analysisScope, SamplingInfo samplingInfo, SmartsModuleOptions smartsModuleOptions) {
        if (moduleInfo == null) {
            return this.badRequest();
        }
        try {
            if (resourceUri != null) {
                String smartsModuleUri = this.createSmartsModuleAsync(resourceUri, requestContext, moduleInfo, smartsModuleInfo, analysisScope, samplingInfo, smartsModuleOptions);
                return this.createResponse(Response.Status.ACCEPTED, smartsModuleUri);
            }
            SmartsModule smartsModule = this.createSmartsModule(requestContext, moduleInfo, smartsModuleInfo, analysisScope, samplingInfo, smartsModuleOptions);
            return this.createResponse(Response.Status.OK, smartsModule);
        }
        catch (SmartsBuilderException e) {
            return this.createResponse(Response.Status.INTERNAL_SERVER_ERROR, "Failed during creating smartsModule" + (Object)((Object)e));
        }
    }

    public SmartsModule createSmartsModule(@Nonnull RequestContext requestContext, @Nonnull ModuleInfo moduleInfo, @Nullable SmartsModuleInfo smartsModuleInfo, @Nullable AnalysisScope analysisScope, @Nullable SamplingInfo samplingInfo, @Nullable SmartsModuleOptions smartsModuleOptions) throws SmartsBuilderException {
        SmartsModuleBuilderSettings settings = this.createSmartsModuleBuilderSettings(requestContext, null, analysisScope, samplingInfo, smartsModuleOptions, moduleInfo);
        return (SmartsModule)SmartsModuleBuilder.build((ModuleInfo)moduleInfo, (SmartsModuleInfo)smartsModuleInfo, (SmartsModuleBuilderSettings)settings).getValue();
    }

    public String createSmartsModuleAsync(@Nonnull String resourceUri, @Nonnull RequestContext requestContext, @Nonnull ModuleInfo moduleInfo, @Nullable SmartsModuleInfo smartsModuleInfo, @Nullable AnalysisScope analysisScope, @Nullable SamplingInfo samplingInfo, @Nullable SmartsModuleOptions smartsModuleOptions) throws SmartsBuilderException {
        SmartsModuleBuilderSettings settings = this.createSmartsModuleBuilderSettings(requestContext, resourceUri, analysisScope, samplingInfo, smartsModuleOptions, moduleInfo);
        return (String)SmartsModuleBuilder.build((ModuleInfo)moduleInfo, (SmartsModuleInfo)smartsModuleInfo, (SmartsModuleBuilderSettings)settings).getKey();
    }

    public Response updateSmartsModuleHandler(RequestContext requestContext, String resourceUri, String knowledgeDiscoveryRequest) {
        try {
            KnowledgeDiscoveryRequest kdsRequest = this.unmarshallRequest(KnowledgeDiscoveryRequest.class, knowledgeDiscoveryRequest);
            return this.updateSmartsModuleHandler(this.convertResourceUriToId(resourceUri), requestContext, kdsRequest.getModuleInfo(), kdsRequest.getSmartsModuleInfo(), kdsRequest.getAnalysisScope(), kdsRequest.getSampleInfo(), kdsRequest.getSmartsModuleOptions());
        }
        catch (IOException e) {
            return this.badRequest();
        }
    }

    public Response updateSmartsModuleHandler(String resourceUri, RequestContext requestContext, ModuleInfo moduleInfo, SmartsModuleInfo smartsModuleInfo, AnalysisScope analysisScope, SamplingInfo samplingInfo, SmartsModuleOptions smartsModuleOptions) {
        if (smartsModuleInfo == null || moduleInfo == null) {
            return this.badRequest();
        }
        try {
            if (resourceUri == null) {
                SmartsModule smartsModule = this.updateSmartsModule(requestContext, smartsModuleInfo, moduleInfo, analysisScope, samplingInfo, smartsModuleOptions);
                return this.createResponse(Response.Status.OK, smartsModule);
            }
            String uri = this.updateSmartsModuleAsync(resourceUri, requestContext, smartsModuleInfo, moduleInfo, analysisScope, samplingInfo, smartsModuleOptions);
            CreateSmartModuleResponse response = new CreateSmartModuleResponse("", SmartsCaCoreHelper.buildKnowledgeGetSmartsModulePath((String)uri), SmartsCaCoreHelper.buildKnowledgeGetProgressPath((String)uri, (AnalysisScope)analysisScope));
            return this.createResponse(Response.Status.ACCEPTED, response);
        }
        catch (SmartsBuilderException e) {
            return this.createResponse(Response.Status.INTERNAL_SERVER_ERROR, "Failed during updating smartsModule:" + (Object)((Object)e));
        }
        catch (IOException e) {
            return this.createResponse(Response.Status.INTERNAL_SERVER_ERROR, "Failed to generate response:" + e);
        }
    }

    public SmartsModule updateSmartsModule(@Nonnull RequestContext requestContext, @Nonnull SmartsModuleInfo smartsModuleInfo, ModuleInfo moduleInfo, AnalysisScope analysisScope, SamplingInfo samplingInfo, @Nullable SmartsModuleOptions smartsModuleOptions) throws SmartsBuilderException {
        SmartsModuleBuilderSettings settings = this.createSmartsModuleBuilderSettings(requestContext, null, analysisScope, samplingInfo, smartsModuleOptions, moduleInfo);
        settings.setUpdateSmartsModule(true);
        return (SmartsModule)SmartsModuleBuilder.build((ModuleInfo)moduleInfo, (SmartsModuleInfo)smartsModuleInfo, (SmartsModuleBuilderSettings)settings).getValue();
    }

    public String updateSmartsModuleAsync(String resourceUri, RequestContext requestContext, SmartsModuleInfo smartsModuleInfo, ModuleInfo moduleInfo, AnalysisScope analysisScope, SamplingInfo samplingInfo, @Nullable SmartsModuleOptions smartsModuleOptions) throws SmartsBuilderException {
        SmartsModuleBuilderSettings settings = this.createSmartsModuleBuilderSettings(requestContext, resourceUri, analysisScope, samplingInfo, smartsModuleOptions, moduleInfo);
        settings.setUpdateSmartsModule(true);
        return (String)SmartsModuleBuilder.build((ModuleInfo)moduleInfo, (SmartsModuleInfo)smartsModuleInfo, (SmartsModuleBuilderSettings)settings).getKey();
    }

    public SmartsModuleProgressSummary getProgressSummary(@Nonnull RequestContext requestContext, @Nonnull String resourceUri, AnalysisScope analysisScope) {
        ISmartsCa smartsCa = this.caSystem.smartsForRequest(requestContext);
        return smartsCa.getProgressSummary(this.convertResourceUriToId(resourceUri), analysisScope);
    }

    public StoreStatus cancelSmartModule(String resourceUri, RequestContext requestContext, boolean bDelete) {
        resourceUri = this.convertResourceUriToId(resourceUri);
        FlowExecutor flowExecutor = this.caSystem.storeProvider.getFlowExecutorStore().getById(resourceUri);
        if (flowExecutor != null) {
            flowExecutor.cancel();
        }
        if (bDelete) {
            return this.deleteSmartModule(resourceUri, requestContext);
        }
        return new StoreStatus(true, Collections.emptyList());
    }

    public StoreStatus deleteSmartModule(String resourceUri, RequestContext requestContext) {
        if (resourceUri != null) {
            resourceUri = this.convertResourceUriToId(resourceUri);
            StoreConfig config = new StoreConfig(requestContext.locale, TypeNames.DDS);
            IPersistenceProvider store = this.caSystem.storeProvider.getPersistenceProvider(config);
            if (store != null) {
                return store.delete(requestContext, resourceUri, "", Collections.emptyList());
            }
        }
        return new StoreStatus(false, Collections.emptyList());
    }
}

