/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.rest.handlers;

import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectFactory;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.ca.api.ISmartsCa;
import com.ibm.smarts.ca.api.SmartsCaSystem;
import com.ibm.smarts.ca.builder.SmartsCaModuleBuilderApiImpl;
import com.ibm.smarts.ca.core.impl.SmartsCaClientManager;
import com.ibm.smarts.ca.core.impl.content.CaMoserRestClient;
import com.ibm.smarts.ca.impl.SmartsCaHelper;
import com.ibm.smarts.common.mq.function.SmartsModulePublishUtil;
import com.ibm.smarts.common.util.SmartsModuleUtil;
import com.ibm.smarts.core.rest.server.RestHandlers;
import com.ibm.smarts.core.util.JsonParserHelper;
import com.ibm.smarts.core.util.ObjectCreator;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.model.builder.ModuleInfo;
import com.ibm.smarts.model.builder.SampleTarget;
import com.ibm.smarts.model.builder.SamplingInfo;
import com.ibm.smarts.model.builder.SmartsModuleOptions;
import com.ibm.smarts.model.module.CreateSmartModuleResponse;
import com.ibm.smarts.model.module.SmartsModuleStatusInfo;
import com.ibm.smarts.schema.AnalysisScope;
import com.ibm.smarts.schema.CancelOption;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.InScopeTable;
import com.ibm.smarts.schema.LoadOptions;
import com.ibm.smarts.schema.LoadOptionsRequest;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.JAXBHelper;
import com.ibm.smarts.smartsmodule.builder.exceptions.SmartsBuilderException;
import com.ibm.smarts.smartsmodule.builder.function.ProgressHandler;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartsCaModuleApiImpl
implements RestHandlers {
    private static final String STRING_SHALLOW = "shallow";
    private static final String STRING_DEEP = "deep";
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartsCaModuleApiImpl.class);
    private final SmartsCaSystem caSystem;
    private final SmartsCaModuleBuilderApiImpl builderImpl;

    public SmartsCaModuleApiImpl(SmartsCaSystem system) {
        this(system, new SmartsCaModuleBuilderApiImpl(system));
    }

    protected SmartsCaModuleApiImpl(SmartsCaSystem system, SmartsCaModuleBuilderApiImpl builderImpl) {
        this.caSystem = system;
        this.builderImpl = builderImpl;
    }

    public Response getSmartModule(RequestContext requestContext, String id) {
        SmartsModuleOptions smartsModuleOptions = new SmartsModuleOptions.SmartsModuleOptionsBuilder().addBivariates(true).build();
        return this.getSmartModule(requestContext, id, smartsModuleOptions, false);
    }

    Response getSmartModule(RequestContext requestContext, String id, SmartsModuleOptions smartsModuleOptions, boolean shallowBuildIfAbsent) {
        ISmartsCa smartsCa = this.caSystem.smartsForRequest(requestContext);
        SmartsModule result = smartsCa.getSmartsModule(id, smartsModuleOptions);
        if (result == null) {
            if (shallowBuildIfAbsent) {
                String moduleUri = CaMoserRestClient.Paths.moduleMetadataPath((String)id);
                ModuleInfo moduleInfo = new ModuleInfo(moduleUri, null, false);
                try {
                    result = this.builderImpl.createSmartsModule(requestContext, moduleInfo, null, null, null, smartsModuleOptions);
                }
                catch (SmartsBuilderException e) {
                    return this.createResponse(Response.Status.INTERNAL_SERVER_ERROR, "Failed during creating smartsModule" + (Object)((Object)e));
                }
            } else {
                return this.notFound();
            }
        }
        if (smartsModuleOptions.isConceptsOnly()) {
            return this.GETjson(JsonParserHelper.toJsonNonNullNonEmpty((Object)result));
        }
        return this.GETjson(result);
    }

    private Optional<Module> getModule(RequestContext requestContext, String id, ObjectCreator<SmartsCaClientManager> clientManagerCreator) {
        Optional<Module> module = Optional.empty();
        try (SmartsCaClientManager clientManager = (SmartsCaClientManager)clientManagerCreator.create(requestContext);){
            CaMoserRestClient moser = clientManager.getMoserClient();
            module = Optional.ofNullable(moser.getBusinessModuleMetadata(id));
        }
        catch (IOException e1) {
            LOGGER.error("Error getting Module when building shallow SmartsModule: {}", (Object)e1.getMessage());
        }
        return module;
    }

    public Response getSmartsModuleProgressSummary(RequestContext requestContext, String smartsModuleId, String analysisScope) {
        return ProgressHandler.handle((String)analysisScope, (String)smartsModuleId, scope -> {
            ISmartsCa smartsCa = this.caSystem.smartsForRequest(requestContext);
            return smartsCa.getProgressSummary(smartsModuleId, (AnalysisScope)scope);
        });
    }

    public Response getSmartsModuleStatus(RequestContext requestContext, String smartsModuleId) {
        ISmartsCa smartsCa = this.caSystem.smartsForRequest(requestContext);
        SmartsModuleStatusInfo status = smartsCa.getStatus(smartsModuleId);
        if (status == null) {
            return this.createResponse(Response.Status.NOT_FOUND, null);
        }
        return this.createResponse(Response.Status.OK, status);
    }

    Response cancelSmartModule(RequestContext requestContext, String smartsModuleId, CancelOption cancelOption) {
        Response.Status status = Response.Status.NO_CONTENT;
        Object error = null;
        status = this.builderImpl.cancelSmartModule(smartsModuleId, requestContext, cancelOption == CancelOption.CANCEL_WITH_DELETE).isSuccess() ? Response.Status.ACCEPTED : Response.Status.INTERNAL_SERVER_ERROR;
        return this.createResponse(status, error);
    }

    public Response createSmartModule(RequestContext requestContext, String dataSourceId, String dataSouceType, String moduleUri, String analysisMode, String loadOptionsRequest, String connections) {
        String mode = analysisMode == null ? STRING_DEEP : analysisMode.toLowerCase();
        SamplingInfo samplingInfo = null;
        LoadOptions loadOptions = null;
        if (loadOptionsRequest != null) {
            loadOptions = this.parseLoadOptions(loadOptionsRequest);
        }
        AnalysisScope analysisScope = null;
        if (loadOptions != null && !loadOptions.getExcludedTables().isEmpty()) {
            analysisScope = new AnalysisScope();
            analysisScope.getOutScopeTables().addAll(loadOptions.getExcludedTables().stream().map(n -> {
                InScopeTable excludedTable = new InScopeTable();
                excludedTable.setTableID(n);
                return excludedTable;
            }).collect(Collectors.toList()));
        }
        if (!mode.equals(STRING_SHALLOW)) {
            int sampleSize = loadOptions != null ? loadOptions.getDataSamplingSize() : Integer.valueOf(this.caSystem.caConfig.getProperty("smarts.ca.samples.size")).intValue();
            SampleTarget target = new SampleTarget(dataSourceId, dataSouceType, connections, sampleSize);
            samplingInfo = new SamplingInfo(null, target, null);
        }
        ModuleInfo moduleInfo = new ModuleInfo(moduleUri, null, mode.equals(STRING_SHALLOW) || "package".equals(dataSouceType));
        SmartsModuleOptions options = null;
        if (loadOptions != null) {
            Boolean prettifyLabels = loadOptions.isPrettifyLabels();
            boolean isPrettify = prettifyLabels == null || prettifyLabels != false;
            options = new SmartsModuleOptions.SmartsModuleOptionsBuilder().addBivariates(true).addColumnEmbedding(true).prettifyLabels(isPrettify).build();
        }
        try {
            String smartsModuleUri = this.builderImpl.createSmartsModuleAsync(dataSourceId, requestContext, moduleInfo, null, analysisScope, samplingInfo, options);
            smartsModuleUri = SmartsCaHelper.buildSmartsModuleUri((String)smartsModuleUri);
            CreateSmartModuleResponse response = new CreateSmartModuleResponse("", smartsModuleUri, smartsModuleUri + "/progressSummary");
            return this.createResponse(Response.Status.ACCEPTED, response);
        }
        catch (SmartsBuilderException e) {
            return this.createResponse(Response.Status.INTERNAL_SERVER_ERROR, "failed to build SmartsModule " + (Object)((Object)e));
        }
    }

    private void publishAllDataSets(RequestContext requestContext, IStoreProvider storeProvider, SmartsModule smartsModule, String dataSourceId) {
        DatasetInfo namedSets;
        smartsModule.getDatasets().forEach(dataSetInfo -> SmartsModulePublishUtil.publish((RequestContext)requestContext, (IStoreProvider)storeProvider, (String)dataSourceId, (SmartsModule)smartsModule, (DatasetInfo)dataSetInfo, null));
        DatasetInfo calculations = smartsModule.getCalculations();
        if (calculations != null) {
            SmartsModulePublishUtil.publish((RequestContext)requestContext, (IStoreProvider)storeProvider, (String)dataSourceId, (SmartsModule)smartsModule, (DatasetInfo)calculations, null);
        }
        if ((namedSets = smartsModule.getNamedSets()) != null) {
            SmartsModulePublishUtil.publish((RequestContext)requestContext, (IStoreProvider)storeProvider, (String)dataSourceId, (SmartsModule)smartsModule, (DatasetInfo)namedSets, null);
        }
    }

    Response createSmartModuleFromModule(RequestContext requestContext, String bodyModule, List<String> includeList) {
        SmartsModule smartsModule;
        try {
            JSONObject jmod = JSONObject.parse((String)bodyModule);
            Module module = Module.fromJSON((JSONObject)jmod, (ObjectFactory)new ObjectFactory());
            ModuleInfo moduleInfo = new ModuleInfo(null, module, false);
            AnalysisScope scope = null;
            if (includeList != null && !includeList.isEmpty()) {
                scope = new AnalysisScope();
                for (String id : includeList) {
                    InScopeTable table = new InScopeTable();
                    table.setTableID(id);
                    scope.getInScopeTables().add(table);
                }
            }
            SmartsModuleOptions smartsModuleOptions = SmartsModuleOptions.DEFAULT_CREATE_PATTERN;
            smartsModule = this.builderImpl.createSmartsModule(requestContext, moduleInfo, null, scope, null, smartsModuleOptions);
        }
        catch (SmartsBuilderException | IOException e) {
            LOGGER.error("Error while updating SmartsModule: {}", (Object)e.getMessage());
            return this.createResponse(Response.Status.INTERNAL_SERVER_ERROR, "failed to update smartsModule " + e);
        }
        return this.createResponse(Response.Status.OK, smartsModule);
    }

    public Response getSmartModuleKeywords(RequestContext requestContext, String smartsModuleId) {
        SmartsModuleOptions options;
        ISmartsCa smartsCa = this.caSystem.smartsForRequest(requestContext);
        SmartsModule smartsModule = smartsCa.getSmartsModule(smartsModuleId, options = new SmartsModuleOptions.SmartsModuleOptionsBuilder().build());
        if (smartsModule == null) {
            return this.createResponse(Response.Status.NOT_FOUND, null);
        }
        JSONArray keywordsJSON = new JSONArray();
        keywordsJSON.addAll((Collection)SmartsModuleUtil.getSmartModuleKeywords((List)smartsModule.getDatasets()));
        return this.createResponse(Response.Status.OK, keywordsJSON);
    }

    private LoadOptions parseLoadOptions(String request) {
        LoadOptions loadOptions = null;
        try {
            LoadOptionsRequest loadOptionsRequest = (LoadOptionsRequest)JAXBHelper.unmarshalFromJSON(LoadOptionsRequest.class, (String)request);
            if (loadOptionsRequest != null) {
                loadOptions = loadOptionsRequest.getLoadOptions();
            } else {
                LOGGER.error("Error un-marshalling load options");
            }
        }
        catch (Exception e) {
            LOGGER.error("Error un-marshalling load options", (Throwable)e);
        }
        return loadOptions;
    }

    private Set<String> getExcludedTables(LoadOptions loadOptions) {
        HashSet<String> excludedTables = loadOptions != null && loadOptions.getExcludedTables() != null ? new HashSet(loadOptions.getExcludedTables()) : new HashSet<String>();
        return excludedTables;
    }
}

