/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.rest.handlers;

import com.ibm.smarts.ca.builder.SmartsCaModuleBuilderApiImpl;
import com.ibm.smarts.ca.rest.handlers.SmartsCaBaseRestApi;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.schema.AnalysisScope;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.smartsmodule.builder.function.ProgressHandler;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="knowledge")
@Api(value="knowledge")
public class SmartsCaModuleBuilderRestApi
extends SmartsCaBaseRestApi {
    final SmartsCaModuleBuilderApiImpl builderImpl;

    public SmartsCaModuleBuilderRestApi() {
        this.setUpContext();
        this.builderImpl = new SmartsCaModuleBuilderApiImpl(this.system);
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a Smarts Module", response=SmartsModule.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Smarts module not found")})
    public Response syncGetWithResourceUri(@ApiParam(value="Resource URI", required=true) @QueryParam(value="resourceUri") String resourceUri, @ApiParam(value="Analysis Scope of Smarts Module") @QueryParam(value="analysisScope") String analysisScope, @ApiParam(value="Options for Smarts Module") @QueryParam(value="smartsModuleOptions") String smartsModuleOptions) {
        return this.handleRest(context -> this.builderImpl.getSmartsModuleWithUriHandler((RequestContext)context, resourceUri, analysisScope, smartsModuleOptions));
    }

    @POST
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a Smarts Module from a Moser Module")
    @ApiResponses(value={@ApiResponse(code=500, message="Unable to create Smarts Module"), @ApiResponse(code=400, message="Bad request. Input params not valid.")})
    public Response createSmartsModuleFromModule(@ApiParam(value="Resource URI") @QueryParam(value="resourceUri") String resourceUri, @ApiParam(value="KnowledgeDiscoveryRequest") String knowledgeDiscoveryRequest) {
        return this.handleRest(context -> this.builderImpl.createSmartsModuleHandler((RequestContext)context, resourceUri, knowledgeDiscoveryRequest));
    }

    @POST
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a Smarts Module from a Moser Module")
    @ApiResponses(value={@ApiResponse(code=500, message="Unable to create Smarts Module"), @ApiResponse(code=400, message="Bad request. Input params not valid.")})
    public Response createSmartsModuleFromModule(@ApiParam(value="KnowledgeDiscoveryRequest") String knowledgeDiscoveryRequest) {
        return this.handleRest(context -> this.builderImpl.createSmartsModuleHandler((RequestContext)context, knowledgeDiscoveryRequest));
    }

    @PUT
    @Produces(value={"application/json"})
    @ApiOperation(value="Update a Smarts Module with a given resource URI")
    @ApiResponses(value={@ApiResponse(code=500, message="Update failed"), @ApiResponse(code=400, message="Bad request. Input params not valid.")})
    public Response updateSmartModule(@ApiParam(value="Resource URI") @QueryParam(value="resourceUri") String resourceUri, @ApiParam(value="KnowledgeDiscoveryRequest") String knowledgeDiscoveryRequest) {
        return this.handleRest(context -> this.builderImpl.updateSmartsModuleHandler((RequestContext)context, resourceUri, knowledgeDiscoveryRequest));
    }

    @GET
    @Path(value="/progress")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get progress of data module analysis")
    @ApiResponses(value={@ApiResponse(code=200, message="Analysis is complete"), @ApiResponse(code=202, message="Analysis is not complete")})
    public Response syncGetProgress(@ApiParam(value="Resource URI", required=true) @QueryParam(value="resourceUri") String resourceUri, @ApiParam(value="AnalysisScope to reduce the datasets to check") @QueryParam(value="analysisScope") String analysisScope) {
        return this.handleRest(context -> ProgressHandler.handle((String)analysisScope, (String)resourceUri, scope -> this.builderImpl.getProgressSummary((RequestContext)context, resourceUri, (AnalysisScope)scope)));
    }

    @DELETE
    @Produces(value={"application/json"})
    @ApiOperation(value="Cancel data module analysis")
    @ApiResponses(value={@ApiResponse(code=202, message="Analysis is canceled"), @ApiResponse(code=404, message="Smarts module not found")})
    public Response syncCancel(@ApiParam(value="Resource URI", required=true) @QueryParam(value="resourceUri") String resourceUri, @ApiParam(value="delete") @QueryParam(value="delete") Boolean delete) {
        if (resourceUri == null) {
            return this.getResponse(Response.Status.BAD_REQUEST, "Can not delete a null resourceUri.");
        }
        boolean pDelete = delete != null ? delete : true;
        return this.handleRest(context -> {
            if (this.builderImpl.cancelSmartModule(resourceUri, (RequestContext)context, pDelete).isSuccess()) {
                return this.createResponse(Response.Status.ACCEPTED, null);
            }
            return this.createResponse(Response.Status.NOT_FOUND, null);
        });
    }
}

