/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.combinations.generator.api;

import com.ibm.smarts.combinations.generator.api.IDataSet;
import com.ibm.smarts.model.datatype.DataType;
import com.ibm.smarts.model.value.Value;
import com.ibm.smarts.model.value.decor.ValueDecoration;
import com.ibm.smarts.schema.SemanticInfo;
import com.ibm.smarts.schema.Statistic;
import com.ibm.smarts.schema.StatisticType;
import com.ibm.smarts.schema.TextInfo;
import com.ibm.smarts.schema.UsageType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IDataColumn {
    public IDataSet getDataSet();

    public String getId();

    public String getIdForExpression();

    public String getName();

    public String getDescription();

    public TextInfo getLabel();

    public DataType getDataType();

    public UsageType getUsageType();

    public SemanticInfo getSemanticInfo();

    public List<String> getSamples();

    public List<String> getSampleDistinctValues();

    public List<Integer> getSampleDistinctValueCounts();

    public List<Statistic> getStatistics();

    public List<Statistic> getSampleStatistics();

    public List<ValueDecoration> getValueDecorations();

    public String getExpression();

    public List<String> getFlatListOfConcepts();

    public boolean hasConcept(String var1);

    public boolean hasAnyOfTheseConcepts(List<String> var1);

    public boolean hasStatistic(StatisticType var1);

    public int getQuantity();

    public boolean isQuantityUndefined();

    public Value getMean();

    public Value getStdDev();

    public double getDensity();

    public Value getMax();

    public Value getMin();

    public boolean isNullable();

    public boolean isHierchical();

    public boolean isPrimary();

    public List<IDataColumn> getHierarchy();

    public void setHierarchy(List<IDataColumn> var1);

    public IDataColumn shallowCopy();

    public List<IDataColumn> getParentHierarchy();

    public static List<IDataColumn> formHierarchy(List<IDataColumn> input) {
        Logger LOGGER = LoggerFactory.getLogger(IDataColumn.class);
        LinkedList<IDataColumn> columns = new LinkedList<IDataColumn>(input);
        HashMap<List, List> hToCMap = new HashMap<List, List>();
        Iterator i = columns.iterator();
        while (i.hasNext()) {
            IDataColumn column = (IDataColumn)i.next();
            if (column.getParentHierarchy().isEmpty()) continue;
            hToCMap.putIfAbsent(column.getParentHierarchy(), new ArrayList());
            if (((List)hToCMap.get(column.getParentHierarchy())).contains(column)) continue;
            if (column.isHierchical()) {
                ((List)hToCMap.get(column.getParentHierarchy())).addAll(column.getHierarchy());
            } else {
                ((List)hToCMap.get(column.getParentHierarchy())).add(column);
            }
            i.remove();
        }
        hToCMap.values().removeIf(List::isEmpty);
        hToCMap.forEach((key, values) -> {
            if (values.size() == 1) {
                columns.add((IDataColumn)values.get(0));
            } else {
                values.sort((o1, o2) -> {
                    int val = key.indexOf(o1) - key.indexOf(o2);
                    if (val != 0) {
                        val /= Math.abs(val);
                    }
                    return val;
                });
                IDataColumn leaf = ((IDataColumn)values.get(values.size() - 1)).shallowCopy();
                leaf.setHierarchy((List<IDataColumn>)values);
                columns.add(leaf);
            }
        });
        return columns;
    }

    public void setParentHierarchy(List<IDataColumn> var1);
}

