/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.impl;

import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.ca.core.impl.SmartsCaClientManager;
import com.ibm.smarts.ca.core.impl.content.CaContentRestClient;
import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.rest.client.util.JaxRs20Exceptions;
import com.ibm.smarts.core.util.ObjectCreator;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.model.common.util.QuerySubjectUtil;
import com.ibm.smarts.schema.AnalysisScope;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.AnalysisScopes;
import com.ibm.smarts.schema.util.JAXBHelper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartsCaCoreHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartsCaCoreHelper.class);
    public static final String CA_SMARTSMODULES = "/bi/v1/smarts/module";
    public static final String CA_SMARTSMODULE = "/bi/v1/smarts/module/%s";
    public static final String PATH_CA_KNOWLEDGE_DISCOVERY = "/bi/v1/smarts/knowledge";
    public static final String QUERY_PARAM_RESOURCE_URI = "resourceUri=%s";
    public static final String QUERY_PARAM_ANALYSIS_SCOPE = "analysisScope=%s";
    public static final String PATH_CA_KNOWLEDGE_DISCOVERY_GET_SMARTSMODULE = "/bi/v1/smarts/knowledge?resourceUri=%s";
    public static final String PATH_CA_KNOWLEDGE_DISCOVERY_GET_PROGRESS = "/bi/v1/smarts/knowledge/progress?resourceUri=%s";
    public static final String PATH_CA_KNOWLEDGE_DISCOVERY_GET_PROGRESS_WITH_SCOPE = "/bi/v1/smarts/knowledge/progress?resourceUri=%s&analysisScope=%s";

    public static String buildSmartsModuleUri(String smartsModuleId) {
        return SmartsCaCoreHelper.buildSmartsModuleUriPath(smartsModuleId);
    }

    public static String buildSmartsModuleUriPath(String moduleId) {
        return String.format(CA_SMARTSMODULE, moduleId);
    }

    public static String buildKnowledgeGetSmartsModulePath(String resourceUri) {
        return String.format(PATH_CA_KNOWLEDGE_DISCOVERY_GET_SMARTSMODULE, resourceUri);
    }

    public static String buildKnowledgeGetProgressPath(String resourceUri, AnalysisScope analysisScope) throws IOException {
        boolean isOnlyValidInScopeTablesInAnalysisScope;
        boolean bl = isOnlyValidInScopeTablesInAnalysisScope = AnalysisScopes.hasInScopeTable((AnalysisScope)analysisScope) && !AnalysisScopes.isScopeExceededMaxSupportTables((AnalysisScope)analysisScope) && !AnalysisScopes.hasOutScopeTable((AnalysisScope)analysisScope);
        if (isOnlyValidInScopeTablesInAnalysisScope) {
            String analysisScopeJsonString = JAXBHelper.marshalToJSON((Object)analysisScope);
            return String.format(PATH_CA_KNOWLEDGE_DISCOVERY_GET_PROGRESS_WITH_SCOPE, resourceUri, URLEncoder.encode(analysisScopeJsonString, "UTF-8"));
        }
        return String.format(PATH_CA_KNOWLEDGE_DISCOVERY_GET_PROGRESS, resourceUri);
    }

    public static String buildCreateSmartsModuleUri(String moduleUri, String moduleId, String dataSourceId, String moduleType) {
        URI uri;
        URIBuilder builder = new URIBuilder();
        String path = String.format(CA_SMARTSMODULE, moduleId);
        builder.setPath(path);
        builder.addParameter("moduleUri", moduleUri);
        builder.addParameter("dataSourceId", dataSourceId);
        builder.addParameter("type", moduleType);
        try {
            uri = builder.build();
        }
        catch (URISyntaxException e) {
            throw new InternalException((Throwable)e, "failed to build URI for " + builder.getPath(), new Object[0]);
        }
        return uri.toString();
    }

    public static String extractModuleId(String moduleUri) {
        String[] parts = moduleUri.split("/");
        return parts.length > 5 ? parts[parts.length - 2] : null;
    }

    public static String extractSmartsModuleId(String smartsModuleUri) {
        return smartsModuleUri.substring(smartsModuleUri.lastIndexOf(47) + 1);
    }

    public static String buildModuleUriPath(String moduleId, String moduleType) {
        String path = "base_module".equals(moduleType) ? CaModulePaths.baseModulePath(moduleId) : CaModulePaths.modulePath(moduleId);
        return path;
    }

    public static String buildModuleUriPath(String moduleId) {
        return CaModulePaths.modulePath(moduleId);
    }

    public static String buildModuleUri(String hostUrl, String moduleId, String moduleType) {
        URI uri;
        URIBuilder builder;
        try {
            builder = new URIBuilder(hostUrl);
        }
        catch (URISyntaxException e) {
            throw new InternalException((Throwable)e, "failed to build URI for " + hostUrl, new Object[0]);
        }
        String path = SmartsCaCoreHelper.buildModuleUriPath(moduleId, moduleType);
        builder.setPath(path);
        try {
            uri = builder.build();
        }
        catch (URISyntaxException e) {
            throw new InternalException((Throwable)e, "failed to build URI for " + builder.getPath(), new Object[0]);
        }
        return uri.toString();
    }

    public static Map<String, String> buildDataIndexUris(String hostUrl, String moduleId, Module module, String type, Set<String> excludedTables, int maxDistinctValue, JSONObject connections) {
        URIBuilder builder;
        HashMap<String, String> uris = new HashMap<String, String>();
        try {
            builder = new URIBuilder(hostUrl);
        }
        catch (URISyntaxException e) {
            throw new InternalException((Throwable)e, "failed to build URI for " + hostUrl, new Object[0]);
        }
        builder.setPath(CaDatasetPaths.datasetDataPath(moduleId));
        List<QuerySubject> querySubjects = SmartsCaCoreHelper.getQuerySubjects(module, excludedTables);
        for (QuerySubject qs : querySubjects) {
            List items = QuerySubjectUtil.getVisibleQueryItems((QuerySubject)qs, (boolean)true);
            int columnCount = items.size();
            for (int i = 0; i < columnCount; ++i) {
                URI uri;
                builder.clearParameters();
                JSONObject querySpec = new JSONObject();
                JSONArray dataItems = new JSONArray();
                JSONArray projections = new JSONArray();
                QueryItem qi = (QueryItem)items.get(i);
                JSONObject dataItem = new JSONObject();
                dataItem.put((Object)"id", (Object)String.valueOf(i));
                dataItem.put((Object)"itemId", (Object)qi.getIdForExpression());
                dataItems.add((Object)dataItem);
                projections.add((Object)String.valueOf(i));
                querySpec.put((Object)"dataItems", (Object)dataItems);
                querySpec.put((Object)"projections", (Object)projections);
                querySpec.put((Object)"offset", (Object)0);
                querySpec.put((Object)"limit", (Object)maxDistinctValue);
                if (connections != null) {
                    querySpec.put((Object)"connections", connections.get((Object)"connections"));
                }
                builder.addParameter("type", type);
                builder.addParameter("querySpec", querySpec.toString());
                try {
                    uri = builder.build();
                }
                catch (URISyntaxException e) {
                    throw new InternalException((Throwable)e, "failed to build URI for " + builder.getPath(), new Object[0]);
                }
                uris.put(qi.getIdForExpression(), uri.toString());
            }
        }
        return uris;
    }

    private static List<QuerySubject> getQuerySubjects(Module module, Set<String> excludedTables) {
        if (excludedTables == null) {
            return module.getQuerySubject();
        }
        return module.getQuerySubject().stream().filter(qs -> !excludedTables.contains(qs.getIdentifier())).collect(Collectors.toList());
    }

    public static SmartsModule getSmartsModuleById(RequestContext context, String moduleId, List<String> columnIdTags, boolean includeFailedDataset, boolean includeBivariates) {
        SmartsModule smartsModule = null;
        ObjectCreator clientManagerCreator = (ObjectCreator)context.getRequestAttribute("com.ibm.smarts.rest.clientManager");
        try (SmartsCaClientManager clientManager = (SmartsCaClientManager)((Object)clientManagerCreator.create(context));){
            CaContentRestClient cmClient = clientManager.getContentClient();
            if (moduleId != null && !moduleId.isEmpty()) {
                smartsModule = cmClient.getObjectSmartsModule(moduleId, columnIdTags, includeFailedDataset, includeBivariates);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error retrieving smartsModule", (Throwable)e);
        }
        catch (JaxRs20Exceptions.ResponseProcessingException e) {
            if (e.getResponse().getStatus() == 404) {
                LOGGER.warn("ResponseProcessingException trying to retrieve SmartsModule");
            }
            throw e;
        }
        return smartsModule;
    }

    public static SmartsModule getSmartsModuleByUri(RequestContext context, String moduleURI, List<String> columnIdTags, boolean includeFailedDataset, boolean includeBivariates) {
        String smartsModuleId = SmartsCaCoreHelper.extractModuleId(moduleURI);
        return SmartsCaCoreHelper.getSmartsModuleById(context, smartsModuleId, columnIdTags, includeFailedDataset, includeBivariates);
    }

    public static SmartsModule getSmartsModule(RequestContext context, String moduleId, String smartsModuleURI, String smartsModuleJSON, List<String> columnIdTags, boolean includeFailedDataset, boolean includeBivariates) {
        SmartsModule smartsModule = null;
        if (moduleId != null && !moduleId.isEmpty()) {
            smartsModule = SmartsCaCoreHelper.getSmartsModuleById(context, moduleId, columnIdTags, includeFailedDataset, includeBivariates);
        } else if (smartsModuleURI != null && !smartsModuleURI.isEmpty()) {
            smartsModule = SmartsCaCoreHelper.getSmartsModuleByUri(context, smartsModuleURI, columnIdTags, includeFailedDataset, includeBivariates);
        } else if (smartsModuleJSON != null && !smartsModuleJSON.isEmpty()) {
            smartsModule = (SmartsModule)CommonJAXBHelper.unmarshalFromJSON(SmartsModule.class, (String)smartsModuleJSON);
        }
        return smartsModule;
    }

    public static class CaDataIndexQueryFields {
        public static final String ID = "id";
        public static final String ITEM_ID = "itemId";
        public static final String TYPE = "type";
        public static final String DATA_ITEMS = "dataItems";
        public static final String PROJECTIONS = "projections";
        public static final String QUERY_SPEC = "querySpec";
        public static final String OFFSET = "offset";
        public static final String LIMIT = "limit";
    }

    public static class CaStatsQueryFields {
        public static final String STATS_API_VERSION = "1";
        public static final String VERSION = "version";
        public static final String ID = "id";
        public static final String ITEM_ID = "itemId";
        public static final String TYPE = "type";
        public static final String AGGREGATE = "aggregate";
        public static final String DATA_ITEMS = "dataItems";
        public static final String PROJECTIONS = "projections";
        public static final String NULL_VALUES = "nullValues";
        public static final String QUERY_SPEC = "querySpec";
        public static final String STATS = "stats";
        public static final String STATS_SPEC = "statsSpec";
        public static final String ITEMS = "items";
        public static final String MIN_ITEMS = "minItems";
        public static final String REFRESH_MD = "refreshmd";
    }

    public static class CaSampleQueryFields {
        public static final String SAMPLE_API_VERSION = "1";
        public static final String SAMPLE_TYPE_DETAIL = "detail";
        public static final String SEED = "seed";
        public static final String SAMPLE_SIZE = "rowCount";
        public static final String SAMPLE_RESULT_LIMIT = "resultLimit";
        public static final String SAMPLE_PERCENTAGE = "percentage";
        public static final String PROJECTIONS = "projections";
        public static final String TYPE = "type";
        public static final String OFFSET = "offset";
        public static final String LIMIT = "limit";
        public static final String QUERYSPEC = "querySpec";
        public static final String DATA_ITEMS = "dataItems";
        public static final String ID = "id";
        public static final String ITEM_ID = "itemId";
        public static final String VERSION = "version";
        public static final String SAMPLING = "sampling";
        public static final String CONNECTIONS = "connections";
        public static final String SELECTION = "selection";
    }

    public static class CaModulePaths {
        public static final String MODULES = "/bi/v1/metadata/modules";
        public static final String BASE_MODULES = "/bi/v1/metadata/base_modules";
        public static final String MODULE = "/bi/v1/metadata/modules/%s/metadata?shortIdForExpression=true";
        public static final String BASE_MODULE = "/bi/v1/metadata/base_modules/%s/metadata?shortIdForExpression=true";

        public static String modulePath(String id) {
            return String.format(MODULE, id);
        }

        public static String baseModulePath(String id) {
            return String.format(BASE_MODULE, id);
        }
    }

    public static class CaDatasetTypes {
        public static final String MODULE = "module";
        public static final String BASE_MODULE = "base_module";
        public static final String DATABASE = "database";
        public static final String UPLOADED_FILE = "uploadedFile";
        public static final String DATASET_2 = "dataSet2";
    }

    public static class CaDatasetPaths {
        public static final String DATASETS = "/bi/v1/datasets";
        public static final String DATASETS_DATA = "/bi/v1/datasets/%s/data";
        public static final String DATASETS_STATS = "/bi/v1/datasets/%s/stats";

        public static String datasetDataPath(String id) {
            return String.format(DATASETS_DATA, id);
        }

        public static String datasetStatsPath(String id) {
            return String.format(DATASETS_STATS, id);
        }
    }

    public static class CaModuleFields {
        public static final String MODULE_URI = "moduleUri";
        public static final String DATA_SOURCE_ID = "dataSourceId";
        public static final String TYPE = "type";
    }
}

