/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.impl.insights;

import com.ibm.smarts.ca.core.impl.insights.RelatedColRequest;
import com.ibm.smarts.ca.core.impl.insights.RelatedColResponse;
import com.ibm.smarts.ca.core.impl.insights.RelatedVisRequest;
import com.ibm.smarts.ca.core.impl.insights.RelatedVisResponse;
import com.ibm.smarts.ca.core.rest.client.CaRestClient;
import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.core.rest.client.RestClient;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.schema.FieldsRecommendationResponse;
import com.ibm.smarts.schema.FieldsRequest;
import com.ibm.smarts.schema.InfluencersRequest;
import com.ibm.smarts.schema.SemanticSearchRequest;
import com.ibm.smarts.schema.SemanticSearchResult;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class CaInsightsClient
extends CaRestClient {
    public CaInsightsClient(RestClient.RestCallContextFactory rccf, RequestContext requestContext, String uri) {
        super(rccf, requestContext, uri);
    }

    public CompletableFuture<SemanticSearchResult> semanticSearchAsync(String question) {
        return this.semanticSearchAsync(question, null, null, false);
    }

    public CompletableFuture<SemanticSearchResult> semanticSearchAsync(String question, String assetTypes) {
        return this.semanticSearchAsync(question, assetTypes, null, false);
    }

    public CompletableFuture<SemanticSearchResult> semanticSearchAsync(String question, String assetTypes, List<String> smartsModuleRefs, boolean inDataValue) {
        String path = Paths.semanticSearchPath();
        RestClient.QueryParams queryParams = new RestClient.QueryParams();
        queryParams.add("question", new String[]{question});
        queryParams.add("inDataValue", new String[]{Boolean.toString(inDataValue)});
        if (assetTypes != null && !assetTypes.isEmpty()) {
            queryParams.add("assetTypes", new String[]{assetTypes});
        }
        if (smartsModuleRefs != null && !smartsModuleRefs.isEmpty()) {
            queryParams.add("assetRefs", smartsModuleRefs.toArray(new String[smartsModuleRefs.size()]));
        }
        return this.getAsync(path, queryParams).thenApply(json -> (SemanticSearchResult)CommonJAXBHelper.unmarshalFromJSON(SemanticSearchResult.class, (String)json));
    }

    public SemanticSearchResult semanticSearch(String question) {
        return this.semanticSearch(question, null, null);
    }

    public SemanticSearchResult semanticSearch(String question, String assetTypes) {
        return this.semanticSearch(question, assetTypes, null);
    }

    public SemanticSearchResult semanticSearch(SemanticSearchRequest request) {
        String path = Paths.semanticSearchPath();
        String jsonRequest = CommonJAXBHelper.marshalToJSON((Object)request);
        CompletionStage future = this.postAsync(path, jsonRequest).thenApply(json -> (SemanticSearchResult)CommonJAXBHelper.unmarshalFromJSON(SemanticSearchResult.class, (String)json));
        return (SemanticSearchResult)this.get((CompletableFuture)future);
    }

    public SemanticSearchResult semanticSearch(String question, String assetTypes, List<String> smartsModuleRefs) {
        CompletableFuture<SemanticSearchResult> future = this.semanticSearchAsync(question, assetTypes, smartsModuleRefs, false);
        return (SemanticSearchResult)this.get(future);
    }

    public SemanticSearchResult semanticSearch(String question, String assetTypes, boolean inDataValue) {
        CompletableFuture<SemanticSearchResult> future = this.semanticSearchAsync(question, assetTypes, null, inDataValue);
        return (SemanticSearchResult)this.get(future);
    }

    public SemanticSearchResult semanticSearch(String question, String assetTypes, String moduleId, boolean inDataValue) {
        List<String> assets = moduleId == null ? null : Arrays.asList(moduleId);
        CompletableFuture<SemanticSearchResult> future = this.semanticSearchAsync(question, assetTypes, assets, inDataValue);
        return (SemanticSearchResult)this.get(future);
    }

    public CompletableFuture<SemanticSearchResult> semanticSearchWithNluAsync(List<String> nluEntities, String assetTypes, List<String> assetRefs, boolean inDataValue) {
        String path = Paths.semanticSearchNluPath();
        RestClient.QueryParams queryParams = new RestClient.QueryParams();
        if (nluEntities != null && !nluEntities.isEmpty()) {
            queryParams.add("nluEntities", nluEntities.toArray(new String[0]));
        }
        queryParams.add("inDataValue", new String[]{Boolean.toString(inDataValue)});
        if (assetTypes != null && !assetTypes.isEmpty()) {
            queryParams.add("assetTypes", new String[]{assetTypes});
        }
        if (assetRefs != null && !assetRefs.isEmpty()) {
            queryParams.add("assetRefs", assetRefs.toArray(new String[0]));
        }
        return this.getAsync(path, queryParams).thenApply(json -> (SemanticSearchResult)CommonJAXBHelper.unmarshalFromJSON(SemanticSearchResult.class, (String)json));
    }

    public SemanticSearchResult semanticSearchNlu(List<String> nluEntities, String assetTypes, String moduleId, boolean inDataValue) {
        List<String> assetRefs = moduleId == null ? null : Arrays.asList(moduleId);
        CompletableFuture<SemanticSearchResult> future = this.semanticSearchWithNluAsync(nluEntities, assetTypes, assetRefs, inDataValue);
        return (SemanticSearchResult)this.get(future);
    }

    public FieldsRecommendationResponse relatedFields(InfluencersRequest request) {
        String path = Paths.influencersPath();
        String jsonRequest = CommonJAXBHelper.marshalToJSON((Object)request);
        String jsonResponse = this.post(path, jsonRequest);
        return (FieldsRecommendationResponse)CommonJAXBHelper.unmarshalFromJSON(FieldsRecommendationResponse.class, (String)jsonResponse);
    }

    public FieldsRecommendationResponse interestingFields(FieldsRequest request) {
        String path = Paths.interestingFieldsPath();
        String jsonRequest = CommonJAXBHelper.marshalToJSON((Object)request);
        String jsonResponse = this.post(path, jsonRequest);
        return (FieldsRecommendationResponse)CommonJAXBHelper.unmarshalFromJSON(FieldsRecommendationResponse.class, (String)jsonResponse);
    }

    public FieldsRecommendationResponse potentialTargets(FieldsRequest request) {
        String path = Paths.potentialTargetsPath();
        String jsonRequest = CommonJAXBHelper.marshalToJSON((Object)request);
        String jsonResponse = this.post(path, jsonRequest);
        return (FieldsRecommendationResponse)CommonJAXBHelper.unmarshalFromJSON(FieldsRecommendationResponse.class, (String)jsonResponse);
    }

    public CompletableFuture<RelatedVisResponse> relatedVisualizationsAsync(RelatedVisRequest request) {
        String path = Paths.relatedVisualizationsPath();
        return this.postAsync(path, request.toJSON()).thenApply(RelatedVisResponse::fromJSON);
    }

    public RelatedVisResponse relatedVisualizations(RelatedVisRequest request) {
        CompletableFuture<RelatedVisResponse> future = this.relatedVisualizationsAsync(request);
        return (RelatedVisResponse)this.get(future);
    }

    public CompletableFuture<RelatedColResponse> relatedColumnsAsync(RelatedColRequest request) {
        String path = Paths.relatedColumnsPath();
        return this.postAsync(path, request.toJSON()).thenApply(RelatedColResponse::fromJSON);
    }

    public RelatedColResponse relatedColumns(RelatedColRequest request) {
        CompletableFuture<RelatedColResponse> future = this.relatedColumnsAsync(request);
        return (RelatedColResponse)this.get(future);
    }

    public CompletableFuture<SemanticSearchResult> similarityClassifierAsync(String smartsModuleId, String question) {
        String path = Paths.similarityClassifierPath();
        RestClient.QueryParams queryParams = new RestClient.QueryParams();
        queryParams.add("smartsModuleId", new String[]{smartsModuleId});
        queryParams.add("question", new String[]{question});
        return this.getAsync(path, queryParams).thenApply(json -> (SemanticSearchResult)CommonJAXBHelper.unmarshalFromJSON(SemanticSearchResult.class, (String)json));
    }

    public SemanticSearchResult similarityClassifier(String smartsModuleID, String question) {
        CompletableFuture<SemanticSearchResult> future = this.similarityClassifierAsync(smartsModuleID, question);
        return (SemanticSearchResult)this.get(future);
    }

    private static class Paths {
        private static final String INSIGHTS = "/bi/v1/smarts/insights";
        private static final String SIMILARITY_CLASSIFIER = "/bi/v1/smarts/insights/semantic-search/similarity-classifier";
        private static final String SEMANTIC_SEARCH = "/bi/v1/smarts/insights/semantic-search/ner";
        private static final String SEMANTIC_SEARCH_NLU = "/bi/v1/smarts/insights/semantic-search/semanticWithNlu";
        private static final String INFLUENCERS = "/bi/v1/smarts/insights/influencers";
        private static final String INTERESTING_FIELDS = "/bi/v1/smarts/insights/interesting-fields";
        private static final String POTENTIAL_TARGETS = "/bi/v1/smarts/insights/potential-targets";
        private static final String RELATED_VISUALIZATIONS = "/bi/v1/smarts/insights/related-visualizations";
        private static final String RELATED_COLUMNS = "/bi/v1/smarts/insights/related-columns";

        private Paths() {
        }

        public static String similarityClassifierPath() {
            return SIMILARITY_CLASSIFIER;
        }

        public static String semanticSearchPath() {
            return SEMANTIC_SEARCH;
        }

        public static String semanticSearchNluPath() {
            return SEMANTIC_SEARCH_NLU;
        }

        public static String influencersPath() {
            return INFLUENCERS;
        }

        public static String interestingFieldsPath() {
            return INTERESTING_FIELDS;
        }

        public static String potentialTargetsPath() {
            return POTENTIAL_TARGETS;
        }

        public static String relatedVisualizationsPath() {
            return RELATED_VISUALIZATIONS;
        }

        public static String relatedColumnsPath() {
            return RELATED_COLUMNS;
        }
    }
}

