/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.impl.modeling;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectFactory;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.ca.core.impl.modeling.SmartsModelingStatus;
import com.ibm.smarts.core.util.JsonParserHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleProposalsResponse {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleProposalsResponse.class);
    public final SmartsModelingStatus status;
    public final List<Module> moduleProposals;

    public ModuleProposalsResponse(SmartsModelingStatus status, List<Module> moduleProposals) {
        this.status = status;
        this.moduleProposals = moduleProposals;
    }

    public String toJson() {
        JsonNodeFactory factory = JsonNodeFactory.instance;
        ObjectNode result = factory.objectNode();
        result.set("status", JsonParserHelper.toJsonNode((Object)this.status));
        ArrayNode proposals = factory.arrayNode();
        result.set("moduleProposals", (JsonNode)proposals);
        this.moduleProposals.forEach(p -> {
            JsonNode moduleNode = JsonParserHelper.parseJson((String)p.toJSON().toString());
            proposals.add(moduleNode);
        });
        return result.toString();
    }

    public static ModuleProposalsResponse fromJson(String json) {
        JsonNode responseNode = JsonParserHelper.parseJson((String)json);
        SmartsModelingStatus status = null;
        JsonNode statusNode = responseNode.get("status");
        if (statusNode != null) {
            status = (SmartsModelingStatus)JsonParserHelper.parseJson((JsonNode)statusNode, SmartsModelingStatus.class);
        }
        ArrayList<Module> proposals = new ArrayList<Module>();
        ArrayNode proposalNodes = (ArrayNode)responseNode.get("moduleProposals");
        if (proposalNodes != null) {
            proposalNodes.forEach(proposalNode -> {
                try {
                    JSONObject jsonObject = JSONObject.parse((String)proposalNode.toString());
                    Module module = Module.fromJSON((JSONObject)jsonObject, (ObjectFactory)new ObjectFactory());
                    proposals.add(module);
                }
                catch (IOException e) {
                    LOGGER.error("failed to parse proposed module", (Throwable)e);
                }
            });
        }
        return new ModuleProposalsResponse(status, proposals);
    }
}

