/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.rest.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.util.ToString;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BIRestClientConfigInfo {
    public static final int CA_DEFAULT_PORT = 9300;
    public final String context;
    public final String scheme;
    public final String server;
    public final int port;
    public final Map<String, List<String>> headers;

    @JsonCreator
    public BIRestClientConfigInfo(@JsonProperty(value="context") String context, @JsonProperty(value="scheme") String scheme, @JsonProperty(value="host") String server, @JsonProperty(value="port") int port, @JsonProperty(value="headers") Map<String, List<String>> headers) {
        this.context = context;
        this.scheme = scheme;
        this.server = server;
        this.port = port;
        this.headers = headers;
    }

    public BIRestClientConfigInfo(BIRestClientConfigInfo config, Map<String, List<String>> headers) {
        this(config.context, config.scheme, config.server, config.port, headers);
    }

    public BIRestClientConfigInfo(BIRestClientConfigInfo config) {
        this(config.context, config.scheme, config.server, config.port, new HashMap<String, List<String>>(config.headers));
    }

    public String toString() {
        return ToString.with((Object)this).field("scheme", (Object)this.scheme).field("server", (Object)this.server).field("port", (Object)this.port).field("context", (Object)this.context).get();
    }

    public static BIRestClientConfigInfo getDefault() {
        String scheme = "http";
        String server = "localhost";
        int port = 9300;
        return BIRestClientConfigInfo.getDefault("http", "localhost", 9300);
    }

    public static BIRestClientConfigInfo getDefault(String hostUrl) {
        URI hostUri;
        try {
            hostUri = new URI(hostUrl);
        }
        catch (URISyntaxException e) {
            throw new InternalException((Throwable)e, "Invalid host URL " + hostUrl, new Object[0]);
        }
        String scheme = hostUri.getScheme();
        String server = hostUri.getHost();
        int port = hostUri.getPort();
        return BIRestClientConfigInfo.getDefault(scheme, server, port);
    }

    public static BIRestClientConfigInfo getDefault(String scheme, String server, int port) {
        String context = "/bi/v1";
        Map<String, List<String>> headers = null;
        BIRestClientConfigInfo ret = new BIRestClientConfigInfo("/bi/v1", scheme, server, port, headers);
        return ret;
    }
}

