/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.rest.client;

import com.ibm.smarts.ca.core.impl.SmartsCaCoreHelper;
import com.ibm.smarts.ca.core.rest.client.CaRestClient;
import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.core.rest.client.RestClient;
import com.ibm.smarts.core.rest.client.util.JaxRs20Exceptions;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.model.module.CreateSmartModuleResponse;
import com.ibm.smarts.model.progress.SmartsModuleProgressSummary;
import com.ibm.smarts.schema.SmartsModule;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class CaKnowledgeDiscoveryClient
extends CaRestClient {
    private static final long SMARTS_MODULE_POLLING_INTERVAL = 60L;
    private static final TimeUnit SMARTS_MODULE_POLLING_INTERVAL_UNIT = TimeUnit.SECONDS;
    private ScheduledExecutorService completionExecutor = Executors.newSingleThreadScheduledExecutor();

    public CaKnowledgeDiscoveryClient(RestClient.RestCallContextFactory rccf, RequestContext requestContext, String uri) {
        super(rccf, requestContext, uri);
    }

    public CompletableFuture<SmartsModule> getSmartsModuleByIdAsync(String id) {
        String path = Paths.smartsModulePath(id);
        RestClient.QueryParams queryParams = new RestClient.QueryParams();
        queryParams.add("includeBivariates", new String[]{"true"});
        return this.getAsync(path, queryParams).thenApply(json -> (SmartsModule)CommonJAXBHelper.unmarshalFromJSON(SmartsModule.class, (String)json));
    }

    public CompletableFuture<SmartsModule> getSmartsModuleByIdAsync(String id, boolean includeFailedDatasets, boolean includeBivariates, boolean shallowBuildIfAbsent) {
        String path = Paths.smartsModulePath(id);
        RestClient.QueryParams queryParams = new RestClient.QueryParams();
        queryParams.add("includeFailedDatasets", new String[]{Boolean.valueOf(includeFailedDatasets).toString()});
        queryParams.add("includeBivariates", new String[]{Boolean.valueOf(includeBivariates).toString()});
        queryParams.add("shallowBuildIfAbsent", new String[]{Boolean.valueOf(shallowBuildIfAbsent).toString()});
        return this.getAsync(path, queryParams).thenApply(json -> (SmartsModule)CommonJAXBHelper.unmarshalFromJSON(SmartsModule.class, (String)json));
    }

    public SmartsModule getSmartsModuleById(String id) {
        CompletableFuture<SmartsModule> future = this.getSmartsModuleByIdAsync(id);
        return (SmartsModule)this.get(future);
    }

    public SmartsModule getSmartsModuleById(String id, boolean includeFailedDatasets, boolean includeBivariates, boolean shallowBuildIfAbsent) {
        CompletableFuture<SmartsModule> future = this.getSmartsModuleByIdAsync(id, includeFailedDatasets, includeBivariates, shallowBuildIfAbsent);
        return (SmartsModule)this.get(future);
    }

    public CompletableFuture<SmartsModule> getSmartsModuleAsync(String uri) {
        String id = SmartsCaCoreHelper.extractModuleId(uri);
        return this.getSmartsModuleByIdAsync(id);
    }

    public SmartsModule getSmartsModule(String uri) {
        String id = SmartsCaCoreHelper.extractModuleId(uri);
        return this.getSmartsModuleById(id);
    }

    private CompletableFuture<SmartsModuleProgressSummary> getSmartsModuleProgressSummaryByIdAsync(String id) {
        String path = Paths.smartsModuleProgressPath(id);
        return this.getAsync(path).thenApply(json -> (SmartsModuleProgressSummary)CommonJAXBHelper.unmarshalFromJSON(SmartsModuleProgressSummary.class, (String)json));
    }

    public SmartsModuleProgressSummary getSmartsModuleProgressSummaryById(String id) {
        CompletableFuture<SmartsModuleProgressSummary> future = this.getSmartsModuleProgressSummaryByIdAsync(id);
        return (SmartsModuleProgressSummary)this.get(future);
    }

    public SmartsModuleProgressSummary getSmartsModuleProgressSummary(String uri) {
        String id = SmartsCaCoreHelper.extractModuleId(uri);
        return this.getSmartsModuleProgressSummaryById(id);
    }

    public CompletableFuture<CreateSmartModuleResponse> createSmartsModuleAsync(String moduleUri, String assetId, String moduleType, String analysisMode) {
        String path = Paths.smartsModulePath(assetId);
        RestClient.QueryParams queryParams = new RestClient.QueryParams();
        queryParams.add("moduleUri", new String[]{moduleUri});
        queryParams.add("type", new String[]{moduleType});
        if (analysisMode != null) {
            queryParams.add("analysisMode", new String[]{analysisMode});
        }
        return this.postAsync(path, "{}", queryParams).thenApply(json -> (CreateSmartModuleResponse)CommonJAXBHelper.unmarshalFromJSON(CreateSmartModuleResponse.class, (String)json));
    }

    public CreateSmartModuleResponse createSmartsModule(String moduleUri, String assetId, String moduleType, String analysisMode) {
        CompletableFuture<CreateSmartModuleResponse> future = this.createSmartsModuleAsync(moduleUri, assetId, moduleType, analysisMode);
        return (CreateSmartModuleResponse)this.get(future);
    }

    public CompletableFuture<SmartsModule> createSmartsModuleFuture(String moduleUri, String assetId, String moduleType, String analysisMode) {
        this.createSmartsModuleAsync(moduleUri, assetId, moduleType, analysisMode);
        return this.getSmartsModuleFuture(assetId);
    }

    public CompletableFuture<SmartsModule> getSmartsModuleFutureById(String id, boolean includeFailedDatasets, boolean includeBivariates, boolean shallowBuildIfAbsent) {
        CompletableFuture<SmartsModule> completeSmartsModule = new CompletableFuture<SmartsModule>();
        ScheduledFuture<?> checkFuture = this.completionExecutor.scheduleAtFixedRate(() -> {
            SmartsModuleProgressSummary progress = this.getSmartsModuleProgressSummaryById(id);
            if (progress == null || progress.isFinished()) {
                SmartsModule smartsModule;
                block3: {
                    smartsModule = null;
                    try {
                        smartsModule = this.getSmartsModuleById(id, includeFailedDatasets, includeBivariates, shallowBuildIfAbsent);
                    }
                    catch (JaxRs20Exceptions.ResponseProcessingException e) {
                        if (e.getResponse().getStatus() == 404) break block3;
                        throw e;
                    }
                }
                completeSmartsModule.complete(smartsModule);
            }
        }, 0L, 60L, SMARTS_MODULE_POLLING_INTERVAL_UNIT);
        completeSmartsModule.whenComplete((result, thrown) -> checkFuture.cancel(true));
        return completeSmartsModule;
    }

    public CompletableFuture<SmartsModule> getSmartsModuleFutureById(String id) {
        CompletableFuture<SmartsModule> completeSmartsModule = new CompletableFuture<SmartsModule>();
        ScheduledFuture<?> checkFuture = this.completionExecutor.scheduleAtFixedRate(() -> {
            SmartsModuleProgressSummary progress = this.getSmartsModuleProgressSummaryById(id);
            if (progress == null || progress.isFinished()) {
                SmartsModule smartsModule;
                block3: {
                    smartsModule = null;
                    try {
                        smartsModule = this.getSmartsModuleById(id);
                    }
                    catch (JaxRs20Exceptions.ResponseProcessingException e) {
                        if (e.getResponse().getStatus() == 404) break block3;
                        throw e;
                    }
                }
                completeSmartsModule.complete(smartsModule);
            }
        }, 0L, 60L, SMARTS_MODULE_POLLING_INTERVAL_UNIT);
        completeSmartsModule.whenComplete((result, thrown) -> checkFuture.cancel(true));
        return completeSmartsModule;
    }

    public CompletableFuture<SmartsModule> getSmartsModuleFuture(String uri) {
        String id = SmartsCaCoreHelper.extractModuleId(uri);
        return this.getSmartsModuleFutureById(id);
    }

    public SmartsModule waitForSmartsModuleById(String id) {
        CompletableFuture<SmartsModule> smartsModuleFuture = this.getSmartsModuleFutureById(id);
        return (SmartsModule)this.get(smartsModuleFuture);
    }

    public SmartsModule waitForSmartsModuleById(String id, boolean includeFailedDatasets, boolean includeBivariates, boolean shallowBuildIfAbsent) {
        CompletableFuture<SmartsModule> smartsModuleFuture = this.getSmartsModuleFutureById(id, includeFailedDatasets, includeBivariates, shallowBuildIfAbsent);
        return (SmartsModule)this.get(smartsModuleFuture);
    }

    public SmartsModule waitForSmartsModule(String uri) {
        String id = SmartsCaCoreHelper.extractModuleId(uri);
        return this.waitForSmartsModuleById(id);
    }

    public static class Paths {
        public static final String KNOWLEDGE_DISCOVERY = "/bi/v1/smarts";
        public static final String SMARTS_MODULE = "/bi/v1/smarts/module/%s";
        private static final String SMARTS_MODULE_PROGRESS_SUMMARY = "/bi/v1/smarts/module/%s/progressSummary";

        public static String smartsModulePath(String id) {
            return String.format(SMARTS_MODULE, id);
        }

        public static String smartsModuleProgressPath(String id) {
            return String.format(SMARTS_MODULE_PROGRESS_SUMMARY, id);
        }
    }
}

