/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.fields.recommender.core.influencers;

import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.fields.recommender.api.RecommendationStatus;
import com.ibm.smarts.fields.recommender.core.BaseFieldsAnalysisContext;
import com.ibm.smarts.fields.recommender.core.exceptions.IFRInvalidInputException;
import com.ibm.smarts.ontology.registry.Concept;
import com.ibm.smarts.ontology.registry.ConceptsRegistry;
import com.ibm.smarts.ontology.registry.util.ConceptsUtil;
import com.ibm.smarts.ontology.util.Pair;
import com.ibm.smarts.schema.AnalysisScope;
import com.ibm.smarts.schema.BivariateStatistics;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.FieldsRecommendation;
import com.ibm.smarts.schema.FieldsRecommendationType;
import com.ibm.smarts.schema.InfluencerTuningParams;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.Builder;
import com.ibm.smarts.schema.util.OntologyCommon;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluencersAnalysisContext
extends BaseFieldsAnalysisContext {
    private String targetFieldID;
    private String targetFieldTableID;
    private ColumnInfo targetField;
    private Map<String, Float> influencerConceptMap;
    private Map<String, InfluencerCandidate> candidatesMap;
    private List<ConceptInfo> targetConcepts;
    private List<String> specificTargetConcepts;
    private boolean canContinue = true;
    private boolean resolvedJoin = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(InfluencersAnalysisContext.class);

    public InfluencersAnalysisContext(RequestContext reqCtx, SmartsModule sModule, String tfID, String ttID, AnalysisScope scope) {
        super(reqCtx, sModule, scope, null);
        this.targetFieldID = tfID;
        this.targetFieldTableID = ttID;
        this.initOthers();
        this.resolveJoin(sModule, (List<String>)null);
    }

    public InfluencersAnalysisContext(RequestContext reqCtx, SmartsModule smartsModule, String targetIdForExpression, AnalysisScope scope, InfluencerTuningParams tuningParams, Set<String> joinableTables, Map<String, Map<Pair<String, String>, BivariateStatistics>> bivariatesMap) {
        super(reqCtx, smartsModule, scope, bivariatesMap);
        this.lookUpTargetColumn(targetIdForExpression);
        this.initOthers();
        this.resolveJoin(smartsModule, joinableTables);
        if (null != tuningParams) {
            this.populateTuningParams(tuningParams);
        }
    }

    public InfluencersAnalysisContext(RequestContext reqCtx, SmartsModule smartsModule, String targetIdForExpression, AnalysisScope scope, InfluencerTuningParams tuningParams, List<String> relatedFields, Map<String, Map<Pair<String, String>, BivariateStatistics>> bivariatesMap) {
        super(reqCtx, smartsModule, scope, bivariatesMap);
        this.lookUpTargetColumn(targetIdForExpression);
        this.initOthers();
        this.resolveJoin(smartsModule, relatedFields);
        if (null != tuningParams) {
            this.populateTuningParams(tuningParams);
        }
    }

    @Deprecated
    private void resolveJoin(SmartsModule sModule, Set<String> joinableTables) {
        if (!"_global_calculations".equals(this.targetFieldTableID)) {
            this.joinableDatasets.add(this.targetFieldTableID);
        }
        if (sModule.getDatasets().size() == 1) {
            this.resolvedJoin = true;
        }
        if (joinableTables != null) {
            this.joinableDatasets.addAll(joinableTables);
            this.resolvedJoin = true;
        }
    }

    void resolveJoin(SmartsModule sModule, List<String> rFields) {
        if (!"_global_calculations".equals(this.targetFieldTableID)) {
            this.joinableDatasets.add(this.targetFieldTableID);
        }
        if (sModule.getDatasets().size() == 1) {
            this.resolvedJoin = true;
        }
        if (rFields != null) {
            List<BaseFieldsAnalysisContext.Column> columns = rFields.stream().map(this.allFieldsMap::get).filter(Objects::nonNull).filter(t -> !"_global_calculations".equals(t.getDatasetID())).collect(Collectors.toList());
            this.getJoinableTables(columns);
            columns.forEach(col -> this.relatedFieldsMap.put(col.getColumnInfo().getIdForExpression(), col));
            this.resolvedJoin = true;
        }
    }

    private void getJoinableTables(List<BaseFieldsAnalysisContext.Column> columns) {
        Set<String> tables = columns.stream().collect(Collectors.groupingBy(BaseFieldsAnalysisContext.Column::getDatasetID)).keySet();
        this.joinableDatasets.addAll(tables);
    }

    boolean isResolvedJoin() {
        return this.resolvedJoin;
    }

    private void populateTuningParams(InfluencerTuningParams tuningParams) {
        if (null != tuningParams.isAllowCategoryTarget()) {
            this.allowCategoryTarget = tuningParams.isAllowCategoryTarget();
        }
        if (null != tuningParams.isIncludeCorrelatedMeasure()) {
            this.includeCorrelatedMeasure = tuningParams.isIncludeCorrelatedMeasure();
        }
        if (null != tuningParams.isNoCorrelationLimit()) {
            this.noCorrelationLimit = tuningParams.isNoCorrelationLimit();
        }
        if (null != tuningParams.getCorrelationLowerLimit()) {
            this.correlationLowerLimit = tuningParams.getCorrelationLowerLimit().floatValue();
        }
        if (null != tuningParams.getCorrelationUpperLimit()) {
            this.correlationUpperLimit = tuningParams.getCorrelationUpperLimit().floatValue();
        }
        if (null != tuningParams.getSemanticDelta()) {
            this.semanticDelta = tuningParams.getSemanticDelta().floatValue();
        }
        if (null != tuningParams.getSemanticRelavenceThreshold()) {
            this.semanticRelavenceThreshold = tuningParams.getSemanticRelavenceThreshold().floatValue();
        }
        if (this.noCorrelationLimit) {
            this.semanticDelta = 0.0f;
        }
    }

    private void initOthers() {
        this.influencerConceptMap = new HashMap<String, Float>(0);
        this.candidatesMap = new HashMap<String, InfluencerCandidate>(0);
    }

    private void lookUpTargetColumn(String tfIDForExpression) {
        BaseFieldsAnalysisContext.Column col;
        if (!StringUtils.isBlank((CharSequence)tfIDForExpression) && (col = (BaseFieldsAnalysisContext.Column)this.allFieldsMap.get(tfIDForExpression)) != null) {
            this.targetFieldID = col.getColumnInfo().getId();
            this.targetFieldTableID = col.getDatasetID();
            this.targetField = col.getColumnInfo();
            return;
        }
        throw new IFRInvalidInputException(RecommendationStatus.INVALID_TARGET_FIELD);
    }

    Map<String, InfluencerCandidate> getCandidatesMap() {
        return this.candidatesMap;
    }

    Collection<InfluencerCandidate> getInfluencersCandidates() {
        return this.candidatesMap.values();
    }

    String getTargetFieldID() {
        return this.targetFieldID;
    }

    public String getTargetFieldTableID() {
        return this.targetFieldTableID;
    }

    ColumnInfo getTargetField() {
        return this.targetField;
    }

    void storeInfluencialConceptMap(Map<String, Float> influencerConceptMap) {
        this.setInfluencerConceptMap(influencerConceptMap);
    }

    List<ConceptInfo> getTargetConcepts() {
        return this.targetConcepts;
    }

    List<String> getSpecificTargetConcepts() {
        return this.specificTargetConcepts;
    }

    void setTargetConcepts(List<ConceptInfo> concepts) {
        LOGGER.info("Target Concepts: ");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(concepts.stream().map(ConceptsUtil::getConceptName).collect(Collectors.joining(", ")));
        }
        this.targetConcepts = concepts;
        this.specificTargetConcepts = this.targetConcepts.stream().filter(c -> !OntologyCommon.getCommonConceptIDs().contains(c.getConceptID())).map(ConceptInfo::getConceptID).collect(Collectors.toList());
    }

    void addInfluentialCandidate(ColumnInfo col, Map.Entry<String, Float> influentialConcept, String fieldUID, String tableID) {
        this.addInfluentialCandidate(col, influentialConcept.getKey(), influentialConcept.getValue().floatValue(), fieldUID, tableID);
    }

    void addInfluentialCandidate(ColumnInfo col, String conceptID, float confidance, String fieldUID, String tableID) {
        InfluencerCandidate can = new InfluencerCandidate(col, tableID);
        Optional<ConceptInfo> concept = this.getMatchingConcept(col, conceptID);
        if (concept.isPresent()) {
            float f = concept.get().getConfidence();
            can.setInfluentialScore(confidance * f);
            this.candidatesMap.compute(fieldUID, (k, v) -> {
                if (v == null) {
                    return can;
                }
                if (Float.compare(can.getInfluentialScore(), v.getInfluentialScore()) > 0) {
                    can.setStatsScore(v.getStatsScore());
                    return can;
                }
                return v;
            });
        } else {
            LOGGER.warn("Column [{}] doesn't have the influential concepts : [{}]", (Object)col.getId(), (Object)CommonJAXBHelper.marshalToJSON((Object)col.getSemanticInfo()));
        }
    }

    private Optional<ConceptInfo> getMatchingConcept(ColumnInfo col, String aConcept) {
        if (Objects.isNull(col.getSemanticInfo())) {
            return Optional.empty();
        }
        Optional<ConceptInfo> concept = this.getDomainConcepts(col).filter(c -> c.getConceptID().equals(aConcept)).findFirst();
        if (concept.isPresent()) {
            return concept;
        }
        List concepts = this.getDomainConcepts(col).collect(Collectors.toList());
        for (ConceptInfo c2 : concepts) {
            Optional<ConceptInfo> conceptFromParent = this.getMatchingConceptFromParent(c2, aConcept);
            if (!conceptFromParent.isPresent()) continue;
            return conceptFromParent;
        }
        return Optional.empty();
    }

    private Stream<ConceptInfo> getDomainConcepts(ColumnInfo col) {
        return col.getSemanticInfo().getConcepts().stream().filter(c -> !ConceptsUtil.getOntologyId((ConceptInfo)c).equals("http://www.ibm.com/ontologies/waca/application"));
    }

    private Optional<ConceptInfo> getMatchingConceptFromParent(ConceptInfo c, String aConcept) {
        Concept concept = ConceptsRegistry.instance().getConcept(c.getConceptID());
        if (concept.getParents().isEmpty()) {
            return Optional.empty();
        }
        List parentConcepts = concept.getParents();
        for (Concept pc : parentConcepts) {
            if (aConcept.equals(pc.getIRI())) {
                return Optional.of(pc.toConceptInfo(c.getConfidence()));
            }
            Optional<ConceptInfo> conceptFromParent = this.getMatchingConceptFromParent(pc.toConceptInfo(c.getConfidence()), aConcept);
            if (!conceptFromParent.isPresent()) continue;
            return conceptFromParent;
        }
        return Optional.empty();
    }

    void addCorrlatedColumn(ColumnInfo col, String fieldUID, String tableID) {
        InfluencerCandidate can = new InfluencerCandidate(col, tableID);
        this.addCandidate(fieldUID, can);
    }

    void addCorrlatedColumn(ColumnInfo col, String fieldUID, String tableID, float statsScore) {
        InfluencerCandidate can = new InfluencerCandidate(col, tableID);
        can.setStatsScore(statsScore);
        this.addCandidate(fieldUID, can);
    }

    private void addCandidate(String fieldUID, InfluencerCandidate can) {
        this.candidatesMap.compute(fieldUID, (k, v) -> {
            if (v == null) {
                return can;
            }
            can.setInfluentialScore(v.getInfluentialScore());
            return can;
        });
    }

    Map<String, Float> getInfluencerConceptMap() {
        return this.influencerConceptMap;
    }

    private void setInfluencerConceptMap(Map<String, Float> aMap) {
        this.influencerConceptMap = aMap;
    }

    boolean canContinue() {
        return this.canContinue;
    }

    void setCanContinue(boolean cont) {
        this.canContinue = cont;
        if (!this.canContinue) {
            this.createEmptyRecommendation();
        }
    }

    void setJoinableDatasets(Set<String> joinedDatasets) {
        this.joinableDatasets = joinedDatasets;
    }

    private void createEmptyRecommendation() {
        this.fieldsRecommendation = (FieldsRecommendation)Builder.create(FieldsRecommendation.class).with(fr -> fr.setType(FieldsRecommendationType.INFLUENCER)).with(FieldsRecommendation::getRecommendedFields).build();
    }

    void dispose() {
        this.candidatesMap.clear();
        this.influencerConceptMap.clear();
        this.scopedTableIDFilter.clear();
        this.scopedFieldIDFilter.clear();
        this.joinableDatasets.clear();
        this.allFieldsMap.clear();
        this.relatedFieldsMap.clear();
    }

    void setRecommendation(FieldsRecommendation recommendation) {
        this.fieldsRecommendation = recommendation;
    }

    Map<String, Map.Entry<String, Float>> getFlattenInfluencerConceptChildren() {
        Map<String, Float> m = this.getInfluencerConceptMap();
        HashMap<String, Map.Entry<String, Float>> children = new HashMap<String, Map.Entry<String, Float>>();
        m.entrySet().forEach(entry -> {
            Map.Entry value = (Map.Entry)children.get(entry.getKey());
            if (value == null || Float.compare(((Float)value.getValue()).floatValue(), ((Float)entry.getValue()).floatValue()) < 0) {
                children.put((String)entry.getKey(), (Map.Entry<String, Float>)entry);
                this.getFlattenInfluencerConceptChildren((String)entry.getKey(), (Map<String, Map.Entry<String, Float>>)children, (Map.Entry<String, Float>)entry);
            }
        });
        return children;
    }

    private void getFlattenInfluencerConceptChildren(String key, Map<String, Map.Entry<String, Float>> children, Map.Entry<String, Float> origin) {
        ConceptsRegistry.instance().getConceptChildren(key).forEach(child -> {
            Map.Entry value = (Map.Entry)children.get(child.getIRI());
            if (value == null || Float.compare(((Float)value.getValue()).floatValue(), ((Float)origin.getValue()).floatValue()) < 0) {
                children.put(child.getIRI(), origin);
                this.getFlattenInfluencerConceptChildren(child.getIRI(), children, origin);
            }
        });
    }

    static class InfluencerCandidate {
        private ColumnInfo field;
        private String tableID;
        private float influentialScore;
        private float statsScore;
        private float confidence;

        InfluencerCandidate(ColumnInfo col, String tid) {
            this.field = col;
            this.tableID = tid;
        }

        ColumnInfo getField() {
            return this.field;
        }

        void setField(ColumnInfo field) {
            this.field = field;
        }

        float getStatsScore() {
            return this.statsScore;
        }

        void setStatsScore(float statsScore) {
            this.statsScore = statsScore;
        }

        float getInfluentialScore() {
            return this.influentialScore;
        }

        void setInfluentialScore(float influentialScore) {
            this.influentialScore = influentialScore;
        }

        float getConfidence() {
            return this.confidence;
        }

        void setConfidence(float confidence) {
            this.confidence = confidence;
        }

        String getTableID() {
            return this.tableID;
        }

        public String toString() {
            return "InfluencerCandidate [field=" + this.field.getId() + ", tableID=" + this.tableID + ", influentialScore=" + this.influentialScore + ", statsScore=" + this.statsScore + ", confidence=" + this.confidence + "]";
        }
    }
}

