/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.fields.recommender.core.keywords;

import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.ontology.registry.util.ConceptsUtil;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.FieldRecommendationRecord;
import com.ibm.smarts.schema.FieldsRecommendation;
import com.ibm.smarts.schema.SemanticInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.TextInfo;
import com.ibm.smarts.schema.WeightedKeyword;
import com.ibm.smarts.schema.util.Builder;
import com.ibm.smarts.schema.util.OntologyCommon;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeightedKeywordsDiscoverer {
    private static final List<String> UNWANTED_POS = Arrays.asList("CD", "SYM");
    private static final Logger LOGGER = LoggerFactory.getLogger(WeightedKeywordsDiscoverer.class);

    public List<WeightedKeyword> recommend(RequestContext reqCtx, SmartsModule smartsModule, FieldsRecommendation interestingFields) {
        LinkedList<WKRecord> wkRecordList = new LinkedList<WKRecord>();
        this.collectWKRecord(reqCtx, wkRecordList, smartsModule.getDatasets());
        this.applyInterestingScore(wkRecordList, interestingFields);
        List<WKRecord> aggregatedWKRecords = this.aggregate(wkRecordList);
        this.computeWeight(aggregatedWKRecords);
        if (LOGGER.isDebugEnabled()) {
            aggregatedWKRecords.forEach(rec -> LOGGER.debug(rec.toString()));
        }
        return this.output(aggregatedWKRecords);
    }

    private List<WeightedKeyword> output(List<WKRecord> aggregatedWKRecords) {
        return aggregatedWKRecords.stream().map(rec -> (WeightedKeyword)Builder.create(WeightedKeyword.class).with(w -> w.setKeyword(rec.getKeyword())).with(w -> w.setWeight(rec.getWeight())).build()).sorted(Comparator.comparing(WeightedKeyword::getWeight).reversed()).collect(Collectors.toList());
    }

    private void collectWKRecord(RequestContext reqCtx, List<WKRecord> wkRecordList, List<DatasetInfo> dataSets) {
        dataSets.forEach(ds -> {
            this.collectWKRecordFromLabel(reqCtx, wkRecordList, ds.getLabel());
            this.collectWKRecordFromColumns(reqCtx, wkRecordList, SmartsModuleUtil.getFlattenedColumns((BaseItemObject)ds));
        });
    }

    private void collectWKRecordFromLabel(RequestContext reqCtx, List<WKRecord> wkRecordList, TextInfo label) {
        this.collectWKRecordFromLabel(reqCtx, wkRecordList, label, 0.0f, null);
    }

    private void collectWKRecordFromLabel(RequestContext reqCtx, List<WKRecord> wkRecordList, TextInfo label, float semanticScore, String idForExp) {
        if (label != null && label.getPhrases() != null) {
            label.getPhrases().forEach(p -> {
                List records = p.getTokens().stream().filter(t -> t.getSignificance() > 2).filter(t -> t.getText().length() > 1).filter(t -> !UNWANTED_POS.contains(t.getPOSlocal())).map(t -> {
                    WKRecord rec = new WKRecord();
                    rec.setKeyword(t.getText().toLowerCase(reqCtx.locale));
                    rec.setLexicalScore((float)t.getSignificance() * 0.1f);
                    rec.setSemanticScore(semanticScore);
                    rec.setIdForExpression(idForExp);
                    return rec;
                }).collect(Collectors.toList());
                wkRecordList.addAll(records);
            });
        }
    }

    private void collectWKRecordFromColumns(RequestContext reqCtx, List<WKRecord> wkRecordList, List<ColumnInfo> flattenedColumns) {
        if (flattenedColumns == null) {
            return;
        }
        flattenedColumns.forEach(col -> {
            List<ConceptInfo> conceptList;
            float semanticScore = 0.0f;
            SemanticInfo semanticInfo = col.getSemanticInfo();
            if (semanticInfo != null && !(conceptList = semanticInfo.getConcepts().stream().filter(concept -> ConceptsUtil.getOntologyId((ConceptInfo)concept).equals("http://www.ibm.com/ontologies/waca/domain/common")).filter(concept -> !OntologyCommon.getCommonConceptIDs().contains(concept.getConceptID())).sorted(Comparator.comparing(ConceptInfo::getConfidence).reversed()).collect(Collectors.toList())).isEmpty()) {
                semanticScore = ((ConceptInfo)conceptList.get(0)).getConfidence();
                this.coolectWKRecordFromConcepts(reqCtx, wkRecordList, conceptList, col.getIdForExpression());
            }
            this.collectWKRecordFromLabel(reqCtx, wkRecordList, col.getLabel(), semanticScore, col.getIdForExpression());
        });
    }

    private void coolectWKRecordFromConcepts(RequestContext reqCtx, List<WKRecord> wkRecordList, List<ConceptInfo> conceptList, String idForExp) {
        conceptList.forEach(conceptInfo -> {
            WKRecord rec = new WKRecord();
            rec.setKeyword(ConceptsUtil.getConceptName((ConceptInfo)conceptInfo).toLowerCase(reqCtx.locale));
            rec.setSemanticScore(conceptInfo.getConfidence());
            rec.setIdForExpression(idForExp);
            wkRecordList.add(rec);
        });
    }

    private void applyInterestingScore(List<WKRecord> wkRecordList, FieldsRecommendation interestingFields) {
        Map<String, Float> interestingScore = interestingFields.getRecommendedFields().stream().collect(Collectors.toMap(FieldRecommendationRecord::getFieldIDForExpression, FieldRecommendationRecord::getConfidence));
        wkRecordList.forEach(wkRec -> wkRec.setInterstingScore(interestingScore.getOrDefault(wkRec.getIdForExpression(), Float.valueOf(0.0f)).floatValue()));
    }

    private void computeWeight(List<WKRecord> recordList) {
        recordList.forEach(rec -> rec.setWeight((float)(1.0 - Math.exp(-(rec.getInterstingScore() + rec.getLexicalScore() + rec.getSemanticScore() + rec.getTfScore())))));
    }

    private List<WKRecord> aggregate(List<WKRecord> wkRecordList) {
        Map<String, List<WKRecord>> wkRecordGroups = wkRecordList.stream().collect(Collectors.groupingBy(WKRecord::getKeyword));
        ArrayList<WKRecord> consolidatedWKRecords = new ArrayList<WKRecord>(wkRecordGroups.size());
        wkRecordGroups.values().forEach(recList -> {
            WKRecord rec = new WKRecord();
            float maxLexicalScore = 0.0f;
            float maxSemanticScore = 0.0f;
            float maxInterstingScore = 0.0f;
            for (WKRecord aRec : recList) {
                maxLexicalScore = Float.max(maxLexicalScore, aRec.getLexicalScore());
                maxSemanticScore = Float.max(maxSemanticScore, aRec.getSemanticScore());
                maxInterstingScore = Float.max(maxInterstingScore, aRec.getInterstingScore());
            }
            rec.setKeyword(((WKRecord)recList.get(0)).getKeyword());
            rec.setTfScore(Float.min(1.0f, (float)recList.size() / (float)wkRecordList.size() * 10.0f));
            rec.setLexicalScore(maxLexicalScore);
            rec.setSemanticScore(maxSemanticScore);
            rec.setInterstingScore(maxInterstingScore);
            consolidatedWKRecords.add(rec);
        });
        return consolidatedWKRecords;
    }

    private static class WKRecord {
        String keyword;
        String idForExpression;
        float interstingScore;
        float lexicalScore;
        float semanticScore;
        float tfScore;
        private float weight;

        private WKRecord() {
        }

        public String getKeyword() {
            return this.keyword;
        }

        public void setKeyword(String keyword) {
            this.keyword = keyword;
        }

        public String getIdForExpression() {
            return this.idForExpression;
        }

        public void setIdForExpression(String idForExpression) {
            this.idForExpression = idForExpression;
        }

        float getInterstingScore() {
            return this.interstingScore;
        }

        void setInterstingScore(float interstingScore) {
            this.interstingScore = interstingScore;
        }

        float getLexicalScore() {
            return this.lexicalScore;
        }

        void setLexicalScore(float lexicalScore) {
            this.lexicalScore = lexicalScore;
        }

        float getSemanticScore() {
            return this.semanticScore;
        }

        void setSemanticScore(float semanticScore) {
            this.semanticScore = semanticScore;
        }

        float getTfScore() {
            return this.tfScore;
        }

        void setTfScore(float tfScore) {
            this.tfScore = tfScore;
        }

        public float getWeight() {
            return this.weight;
        }

        public void setWeight(float weight) {
            this.weight = weight;
        }

        public String toString() {
            return "WKRecord [keyword=" + this.keyword + ", interstingScore=" + this.interstingScore + ", lexicalScore=" + this.lexicalScore + ", semanticScore=" + this.semanticScore + ", tfScore=" + this.tfScore + ", weight=" + this.weight + ", idForExpression=" + this.idForExpression + "]";
        }
    }
}

