/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.fields.recommender.core.targets;

import com.ibm.smarts.fields.recommender.core.AnalysisStep;
import com.ibm.smarts.fields.recommender.core.BaseFieldsAnalysisContext;
import com.ibm.smarts.fields.recommender.core.targets.TargetsAnalysisContext;
import com.ibm.smarts.ontology.util.Pair;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.BivariateStatistics;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.Statistic;
import com.ibm.smarts.schema.StatisticType;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumericMetadataEvaluation
implements AnalysisStep<TargetsAnalysisContext> {
    private static final String OUTLIER_ID = "http://www.ibm.com/ontologies/waca/application#HasOutlier";
    private static final Logger LOGGER = LoggerFactory.getLogger(NumericMetadataEvaluation.class);

    @Override
    public void execute(@Nonnull TargetsAnalysisContext tac) {
        tac.getTargetCandidates().iterator().forEachRemaining(t -> {
            if (this.isDegenerated(t.getField())) {
                LOGGER.debug("{} is degenerated", (Object)t.getField().getId());
                t.setStatsScore(-1.0f);
            }
            this.setStatsScore((TargetsAnalysisContext.TargetCandidate)t, tac);
            if (t.getField().getSemanticInfo().getConcepts().stream().anyMatch(c -> OUTLIER_ID.equals(c.getConceptID()))) {
                LOGGER.debug("{} has outlier", (Object)t.getField().getId());
                t.setStatsScore(t.getStatsScore() + 0.5f);
            }
            this.adjustScoreViaDataQuality((TargetsAnalysisContext.TargetCandidate)t);
        });
    }

    private void setStatsScore(TargetsAnalysisContext.TargetCandidate t, BaseFieldsAnalysisContext tac) {
        DatasetInfo targetTable = tac.getSmartsModule().getDatasets().stream().filter(ds -> ds.getId().equals(t.getTableID())).findFirst().get();
        Map<Pair<String, String>, BivariateStatistics> bvMap = this.getBVMapAndStoreIfAbsent(tac, targetTable);
        if (bvMap == null && targetTable.getBivariateStatistics().isEmpty()) {
            LOGGER.info("The target dataset [{}] doesn't have bivariates.", (Object)targetTable.getName());
            t.setStatsScore(1.0f / (float)SmartsModuleUtil.getFlattenedColumns((BaseItemObject)targetTable).size());
            return;
        }
        if (bvMap != null) {
            SmartsModuleUtil.getFlattenedColumns((BaseItemObject)targetTable).forEach(col -> {
                BivariateStatistics bv = this.getBivariate(bvMap, t.getField().getId(), col.getId());
                if (bv != null && this.valueInRange(bv, tac, CORR_MEASURE)) {
                    t.getCounter().incrementAndGet();
                }
            });
            t.setStatsScore((float)t.getCounter().get() / (float)SmartsModuleUtil.getFlattenedColumns((BaseItemObject)targetTable).size());
        }
    }

    private boolean isDegenerated(ColumnInfo col) {
        return col.getSemanticInfo().getConcepts().stream().anyMatch(this::isDegenerated);
    }

    private void adjustScoreViaDataQuality(TargetsAnalysisContext.TargetCandidate tc) {
        if (Optional.ofNullable(tc.getField().getStatistics()).isPresent()) {
            float f = this.computeNullScore(tc);
            float stats = tc.getStatsScore() - f;
            tc.setStatsScore(Float.compare(stats, 0.0f) > 0 ? stats : 0.0f);
        }
    }

    private float computeNullScore(TargetsAnalysisContext.TargetCandidate tc) {
        List stats = tc.getField().getStatistics();
        Optional<Statistic> totalCnt = stats.stream().filter(st -> st.getType() == StatisticType.TOTAL_COUNT).findFirst();
        Optional<Statistic> nullCnt = stats.stream().filter(st -> st.getType() == StatisticType.NULL_COUNT).findFirst();
        if (totalCnt.isPresent() && nullCnt.isPresent()) {
            long totalCount = totalCnt.get().getValue().longValue();
            long nullCount = nullCnt.get().getValue().longValue();
            return totalCount == 0L || nullCount == totalCount ? 1.0f : (float)nullCount / (float)totalCount;
        }
        return 0.0f;
    }
}

