/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.fields.recommender.core.targets;

import com.ibm.smarts.fields.recommender.core.AnalysisStep;
import com.ibm.smarts.fields.recommender.core.targets.TargetsAnalysisContext;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetsCandidateDiscovery
implements AnalysisStep<TargetsAnalysisContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TargetsCandidateDiscovery.class);
    private static final List<String> NON_DATASET_IDS = Arrays.asList("_global_namedSets");

    @Override
    public void execute(@Nonnull TargetsAnalysisContext tac) {
        tac.getSmartsModule().getDatasets().stream().filter(ds -> !NON_DATASET_IDS.contains(ds.getId()) && (tac.getScopedTableIDFilter().isEmpty() || tac.getScopedTableIDFilter().contains(ds.getId()))).forEach(ds -> SmartsModuleUtil.getFlattenedColumns((BaseItemObject)ds).stream().filter(col -> tac.getScopedFieldIDFilter().isEmpty() || tac.getScopedFieldIDFilter().contains(this.toFieldUID(col.getId(), ds.getId()))).filter(col -> Objects.nonNull(col.getSemanticInfo())).filter(this::isSemanticEligible).forEach(col -> tac.addTargetCandidate((ColumnInfo)col, this.toFieldUID(col.getId(), ds.getId()), ds.getId())));
        LOGGER.info("Potential targets candidates: [{}]", tac.getTargetCandidates());
    }
}

